/*
 * Decompiled with CFR 0.152.
 */
package com.icontrol.protector;

import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class AudioUtils {
    public static byte[] addWavHeader(byte[] pcmData, int sampleRate, int channels, int bitsPerSample) throws IOException {
        long totalAudioLen = pcmData.length;
        long totalDataLen = totalAudioLen + 36L;
        long byteRate = sampleRate * channels * bitsPerSample / 8;
        byte[] header = AudioUtils.wavFileHeader(totalAudioLen, totalDataLen, sampleRate, channels, byteRate, (byte)bitsPerSample);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        out.write(header);
        out.write(pcmData);
        return out.toByteArray();
    }

    private static byte[] wavFileHeader(long totalAudioLen, long totalDataLen, long longSampleRate, int channels, long byteRate, byte bitsPerSample) {
        byte[] header = new byte[]{82, 73, 70, 70, (byte)(totalDataLen & 0xFFL), (byte)(totalDataLen >> 8 & 0xFFL), (byte)(totalDataLen >> 16 & 0xFFL), (byte)(totalDataLen >> 24 & 0xFFL), 87, 65, 86, 69, 102, 109, 116, 32, 16, 0, 0, 0, 1, 0, (byte)channels, 0, (byte)(longSampleRate & 0xFFL), (byte)(longSampleRate >> 8 & 0xFFL), (byte)(longSampleRate >> 16 & 0xFFL), (byte)(longSampleRate >> 24 & 0xFFL), (byte)(byteRate & 0xFFL), (byte)(byteRate >> 8 & 0xFFL), (byte)(byteRate >> 16 & 0xFFL), (byte)(byteRate >> 24 & 0xFFL), (byte)(channels * (bitsPerSample / 8)), 0, bitsPerSample, 0, 100, 97, 116, 97, (byte)(totalAudioLen & 0xFFL), (byte)(totalAudioLen >> 8 & 0xFFL), (byte)(totalAudioLen >> 16 & 0xFFL), (byte)(totalAudioLen >> 24 & 0xFFL)};
        return header;
    }
}

