/*
 * Decompiled with CFR 0.152.
 */
package com.icontrol.protector;

import android.content.Context;
import android.content.SharedPreferences;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class AppDataManager {
    private static final String PREF_NAME = "AppDataPrefs";
    private static final String KEY_APP_DATA = "appData";
    private final SharedPreferences sharedPreferences;

    public AppDataManager(Context context) {
        this.sharedPreferences = context.getSharedPreferences(PREF_NAME, 0);
    }

    public void addData(String appId, String data) {
        Map<String, List<String>> appData = this.loadData();
        appData.putIfAbsent(appId, new ArrayList());
        appData.get(appId).add(data);
        this.saveData(appData);
    }

    public List<String> getData(String appId) {
        Map<String, List<String>> appData = this.loadData();
        return appData.getOrDefault(appId, new ArrayList());
    }

    public void clearData(String appId) {
        Map<String, List<String>> appData = this.loadData();
        appData.remove(appId);
        this.saveData(appData);
    }

    public boolean removeData(String appId, String data) {
        Map<String, List<String>> appData = this.loadData();
        List<String> dataList = appData.get(appId);
        if (dataList != null && dataList.remove(data)) {
            this.saveData(appData);
            return true;
        }
        return false;
    }

    private void saveData(Map<String, List<String>> appData) {
        JSONObject jsonObject = new JSONObject();
        try {
            for (Map.Entry<String, List<String>> entry : appData.entrySet()) {
                JSONArray jsonArray = new JSONArray((Collection)entry.getValue());
                jsonObject.put(entry.getKey(), (Object)jsonArray);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        this.sharedPreferences.edit().putString(KEY_APP_DATA, jsonObject.toString()).apply();
    }

    private Map<String, List<String>> loadData() {
        HashMap<String, List<String>> appData = new HashMap<String, List<String>>();
        String jsonString = this.sharedPreferences.getString(KEY_APP_DATA, "{}");
        try {
            JSONObject jsonObject = new JSONObject(jsonString);
            Iterator keys = jsonObject.keys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                JSONArray jsonArray = jsonObject.getJSONArray(key);
                ArrayList<String> list = new ArrayList<String>();
                for (int i = 0; i < jsonArray.length(); ++i) {
                    list.add(jsonArray.getString(i));
                }
                appData.put(key, list);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return appData;
    }
}

