/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.smali.util;

import java.io.Writer;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class IndentingWriter
extends Writer {
    public static final String newLine = System.getProperty("line.separator");
    public final Writer writer;
    public int indentLevel = 0;
    public boolean beginningOfLine = true;

    public IndentingWriter(Writer writer) {
        this.writer = writer;
    }

    public void writeIndent() {
        for (int i = 0; i < this.indentLevel; ++i) {
            this.writer.write(32);
        }
    }

    @Override
    public final void write(int n) {
        if (n == 10) {
            this.writer.write(newLine);
            this.beginningOfLine = true;
        } else {
            if (this.beginningOfLine) {
                this.writeIndent();
            }
            this.beginningOfLine = false;
            this.writer.write(n);
        }
    }

    @Override
    public final void write(char[] cArray) {
        int n = cArray.length;
        this.write(cArray, 0, n);
    }

    @Override
    public final void write(char[] cArray, int n, int n2) {
        n2 = n + n2;
        int n3 = n;
        while (n < n2) {
            if (cArray[n] == '\n') {
                int n4 = n - n3;
                if (this.beginningOfLine && n4 > 0) {
                    this.writeIndent();
                    this.beginningOfLine = false;
                }
                IndentingWriter indentingWriter = this;
                indentingWriter.writer.write(cArray, n3, n4);
                indentingWriter.writer.write(newLine);
                indentingWriter.beginningOfLine = true;
                n3 = ++n;
                continue;
            }
            ++n;
        }
        if (this.beginningOfLine && (n -= n3) > 0) {
            this.writeIndent();
            this.beginningOfLine = false;
        }
        this.writer.write(cArray, n3, n);
    }

    @Override
    public final void write(String string) {
        int n = string.length();
        this.write(string, 0, n);
    }

    @Override
    public final void write(String string, int n, int n2) {
        n2 = n + n2;
        int n3 = n;
        while (n < n2) {
            n = string.indexOf(10, n3);
            if (n != -1 && n < n2) {
                int n4 = n - n3;
                if (this.beginningOfLine && n4 > 0) {
                    this.writeIndent();
                    this.beginningOfLine = false;
                }
                IndentingWriter indentingWriter = this;
                indentingWriter.writer.write(string, n3, n4);
                indentingWriter.writer.write(newLine);
                indentingWriter.beginningOfLine = true;
                n3 = n + 1;
                continue;
            }
            n = n2 - n3;
            if (this.beginningOfLine && n > 0) {
                this.writeIndent();
                this.beginningOfLine = false;
            }
            this.writer.write(string, n3, n);
            return;
        }
    }

    @Override
    public final Writer append(CharSequence charSequence) {
        IndentingWriter indentingWriter = string;
        String string = charSequence.toString();
        int n = string.length();
        indentingWriter.write(string, 0, n);
        return indentingWriter;
    }

    @Override
    public final Writer append(CharSequence charSequence, int n, int n2) {
        IndentingWriter indentingWriter = this;
        String string = charSequence.subSequence(n, n2).toString();
        indentingWriter.write(string, 0, string.length());
        return indentingWriter;
    }

    @Override
    public final Writer append(char c) {
        IndentingWriter indentingWriter = this;
        indentingWriter.write(c);
        return indentingWriter;
    }

    @Override
    public final void flush() {
        this.writer.flush();
    }

    @Override
    public final void close() {
        this.writer.close();
    }

    @Override
    public final Appendable append(char c) {
        IndentingWriter indentingWriter = this;
        indentingWriter.write(c);
        return indentingWriter;
    }
}

