/*
 * Decompiled with CFR 0.152.
 */
package org.jf.util.collection;

import java.util.Iterator;

public class ConcatIterators<T>
implements Iterator<T> {
    private final Iterator<? extends Iterator<? extends T>> iterators;
    private final Iterator<? extends Iterable<? extends T>> iterables;
    private Iterator<? extends T> mCurrentIterator;

    public ConcatIterators(Iterator<? extends Iterator<? extends T>> iterators) {
        this.iterators = iterators;
        this.iterables = null;
    }

    public ConcatIterators(Iterator<? extends Iterable<? extends T>> iterables, boolean nothing) {
        this.iterators = null;
        this.iterables = iterables;
    }

    @Override
    public boolean hasNext() {
        Iterator<T> current = this.getCurrent();
        return current != null && current.hasNext();
    }

    @Override
    public T next() {
        return this.getCurrent().next();
    }

    private Iterator<? extends T> getCurrent() {
        if (this.iterators != null) {
            return this.getCurrentIterator();
        }
        return this.getCurrentIterables();
    }

    private Iterator<? extends T> getCurrentIterator() {
        Iterator<Object> current = this.mCurrentIterator;
        if (current != null && current.hasNext()) {
            return current;
        }
        this.mCurrentIterator = null;
        if (this.iterators == null || !this.iterators.hasNext()) {
            return null;
        }
        current = null;
        while (current == null && this.iterators.hasNext()) {
            current = this.iterators.next();
            if (current == null || current.hasNext()) continue;
            current = null;
        }
        this.mCurrentIterator = current;
        return current;
    }

    private Iterator<? extends T> getCurrentIterables() {
        Iterator<Object> current = this.mCurrentIterator;
        if (current != null && current.hasNext()) {
            return current;
        }
        this.mCurrentIterator = null;
        if (this.iterables == null || !this.iterables.hasNext()) {
            return null;
        }
        current = null;
        while (current == null && this.iterables.hasNext()) {
            Iterable<T> itr = this.iterables.next();
            if (itr != null) {
                current = itr.iterator();
            }
            if (current == null || current.hasNext()) continue;
            current = null;
        }
        this.mCurrentIterator = current;
        return current;
    }
}

