/*
 * Decompiled with CFR 0.152.
 */
package org.jf.util;

import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jf.util.ArraySortedSet;
import org.jf.util.collection.ArraySet;
import org.jf.util.collection.ListUtil;

public abstract class ImmutableConverter<ImmutableItem, Item> {
    protected abstract boolean isImmutable(@Nonnull Item var1);

    @Nonnull
    protected abstract ImmutableItem makeImmutable(@Nonnull Item var1);

    @Nonnull
    public List<ImmutableItem> toList(@Nullable Iterable<? extends Item> iterable) {
        if (iterable == null) {
            return ListUtil.of();
        }
        boolean needsCopy = false;
        if (iterable instanceof List) {
            for (Item element : iterable) {
                if (this.isImmutable(element)) continue;
                needsCopy = true;
                break;
            }
        } else {
            needsCopy = true;
        }
        if (!needsCopy) {
            return (List)iterable;
        }
        final Iterator<? extends Item> iter = iterable.iterator();
        return ListUtil.copyOf(new Iterator<ImmutableItem>(){

            @Override
            public boolean hasNext() {
                return iter.hasNext();
            }

            @Override
            public ImmutableItem next() {
                return ImmutableConverter.this.makeImmutable(iter.next());
            }

            @Override
            public void remove() {
                iter.remove();
            }
        });
    }

    @Nonnull
    public ArraySet<ImmutableItem> toSet(@Nullable Iterable<? extends Item> iterable) {
        if (iterable == null) {
            return ArraySet.of();
        }
        boolean needsCopy = false;
        if (iterable instanceof ArraySet) {
            for (Item element : iterable) {
                if (this.isImmutable(element)) continue;
                needsCopy = true;
                break;
            }
        } else {
            needsCopy = true;
        }
        if (!needsCopy) {
            return (ArraySet)iterable;
        }
        final Iterator<? extends Item> iter = iterable.iterator();
        return ArraySet.copyOf(new Iterator<ImmutableItem>(){

            @Override
            public boolean hasNext() {
                return iter.hasNext();
            }

            @Override
            public ImmutableItem next() {
                return ImmutableConverter.this.makeImmutable(iter.next());
            }

            @Override
            public void remove() {
                iter.remove();
            }
        }).sort();
    }

    @Nonnull
    public ArraySet<ImmutableItem> toSortedSet(Iterable<? extends Item> iterable) {
        if (iterable == null) {
            return ArraySet.of();
        }
        boolean needsCopy = false;
        if (iterable instanceof ArraySet) {
            for (Item element : iterable) {
                if (this.isImmutable(element)) continue;
                needsCopy = true;
                break;
            }
        } else {
            needsCopy = true;
        }
        if (!needsCopy) {
            return (ArraySet)iterable;
        }
        final Iterator<? extends Item> iter = iterable.iterator();
        return ArraySet.copyOf(new Iterator<ImmutableItem>(){

            @Override
            public boolean hasNext() {
                return iter.hasNext();
            }

            @Override
            public ImmutableItem next() {
                return ImmutableConverter.this.makeImmutable(iter.next());
            }

            @Override
            public void remove() {
                iter.remove();
            }
        }).sort();
    }

    @Nonnull
    public SortedSet<ImmutableItem> toSortedSet(@Nonnull Comparator<? super ImmutableItem> comparator, @Nullable SortedSet<? extends Item> sortedSet) {
        if (sortedSet == null || sortedSet.size() == 0) {
            return ArraySortedSet.of(comparator, new Object[0]);
        }
        Object[] newItems = new Object[sortedSet.size()];
        int index = 0;
        for (Object item : sortedSet) {
            newItems[index++] = this.makeImmutable(item);
        }
        return ArraySortedSet.of(comparator, newItems);
    }
}

