/*
 * Decompiled with CFR 0.152.
 */
package org.jf.util;

import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Set;
import java.util.SortedSet;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import org.jf.util.collection.ArraySet;

public class CollectionUtils {
    public static <T> int listHashCode(@Nonnull Iterable<T> iterable) {
        int hashCode = 1;
        for (T item : iterable) {
            hashCode = hashCode * 31 + item.hashCode();
        }
        return hashCode;
    }

    public static <T> int lastIndexOf(@Nonnull Iterable<T> iterable, @Nonnull Predicate<? super T> predicate) {
        int index = 0;
        int lastMatchingIndex = -1;
        for (T item : iterable) {
            if (predicate.test(item)) {
                lastMatchingIndex = index;
            }
            ++index;
        }
        return lastMatchingIndex;
    }

    public static <T extends Comparable<? super T>> int compareAsList(@Nonnull Collection<? extends T> list1, @Nonnull Collection<? extends T> list2) {
        int res = Integer.compare(list1.size(), list2.size());
        if (res != 0) {
            return res;
        }
        Iterator<T> elements2 = list2.iterator();
        for (Comparable element1 : list1) {
            res = element1.compareTo(elements2.next());
            if (res == 0) continue;
            return res;
        }
        return 0;
    }

    public static <T> int compareAsIterable(@Nonnull Comparator<? super T> comparator, @Nonnull Iterable<? extends T> it1, @Nonnull Iterable<? extends T> it2) {
        Iterator<T> elements2 = it2.iterator();
        for (T element1 : it1) {
            if (!elements2.hasNext()) {
                return 1;
            }
            T element2 = elements2.next();
            int res = comparator.compare(element1, element2);
            if (res == 0) continue;
            return res;
        }
        if (elements2.hasNext()) {
            return -1;
        }
        return 0;
    }

    public static <T extends Comparable<? super T>> int compareAsIterable(@Nonnull Iterable<? extends T> it1, @Nonnull Iterable<? extends T> it2) {
        Iterator<T> elements2 = it2.iterator();
        for (Comparable element1 : it1) {
            if (!elements2.hasNext()) {
                return 1;
            }
            Comparable element2 = (Comparable)elements2.next();
            int res = element1.compareTo(element2);
            if (res == 0) continue;
            return res;
        }
        if (elements2.hasNext()) {
            return -1;
        }
        return 0;
    }

    public static <T> int compareAsList(@Nonnull Comparator<? super T> elementComparator, @Nonnull Collection<? extends T> list1, @Nonnull Collection<? extends T> list2) {
        int res = Integer.compare(list1.size(), list2.size());
        if (res != 0) {
            return res;
        }
        Iterator<T> elements2 = list2.iterator();
        for (T element1 : list1) {
            res = elementComparator.compare(element1, elements2.next());
            if (res == 0) continue;
            return res;
        }
        return 0;
    }

    @Nonnull
    public static <T> Comparator<Collection<? extends T>> listComparator(final @Nonnull Comparator<? super T> elementComparator) {
        return new Comparator<Collection<? extends T>>(){

            @Override
            public int compare(Collection<? extends T> list1, Collection<? extends T> list2) {
                return CollectionUtils.compareAsList(elementComparator, list1, list2);
            }
        };
    }

    public static <T> boolean isNaturalSortedSet(@Nonnull Iterable<? extends T> it) {
        return it instanceof ArraySet;
    }

    public static <T> boolean isSortedSet(@Nonnull Comparator<? extends T> elementComparator, @Nonnull Iterable<? extends T> it) {
        return it instanceof ArraySet;
    }

    @Nonnull
    private static <T> Set<? extends T> toNaturalSortedSet(@Nonnull Collection<? extends T> collection) {
        if (CollectionUtils.isNaturalSortedSet(collection)) {
            return (SortedSet)collection;
        }
        return ArraySet.sortedCopy(collection.iterator());
    }

    @Nonnull
    private static <T> Set<? extends T> toSortedSet(@Nonnull Comparator<? super T> elementComparator, @Nonnull Collection<? extends T> collection) {
        SortedSet sortedSet;
        Comparator comparator;
        if (collection instanceof SortedSet && (comparator = (sortedSet = (SortedSet)collection).comparator()) != null && comparator.equals(elementComparator)) {
            return sortedSet;
        }
        ArraySet<? super T> arraySet = new ArraySet<T>(collection);
        arraySet.sort(elementComparator);
        return arraySet;
    }

    @Nonnull
    public static <T> Comparator<Collection<? extends T>> setComparator(final @Nonnull Comparator<? super T> elementComparator) {
        return new Comparator<Collection<? extends T>>(){

            @Override
            public int compare(Collection<? extends T> list1, Collection<? extends T> list2) {
                return CollectionUtils.compareAsSet(elementComparator, list1, list2);
            }
        };
    }

    public static <T extends Comparable<T>> int compareAsSet(@Nonnull Collection<? extends T> set1, @Nonnull Collection<? extends T> set2) {
        int res = Integer.compare(set1.size(), set2.size());
        if (res != 0) {
            return res;
        }
        Iterator<T> elements2 = set2.iterator();
        for (Comparable element1 : set1) {
            res = element1.compareTo((Comparable)elements2.next());
            if (res == 0) continue;
            return res;
        }
        return 0;
    }

    public static <T> int compareAsSet(@Nonnull Comparator<? super T> elementComparator, @Nonnull Collection<? extends T> list1, @Nonnull Collection<? extends T> list2) {
        int res = Integer.compare(list1.size(), list2.size());
        if (res != 0) {
            return res;
        }
        Set<T> set1 = CollectionUtils.toSortedSet(elementComparator, list1);
        Set<T> set2 = CollectionUtils.toSortedSet(elementComparator, list2);
        Iterator<T> elements2 = set2.iterator();
        for (T element1 : set1) {
            res = elementComparator.compare(element1, elements2.next());
            if (res == 0) continue;
            return res;
        }
        return 0;
    }
}

