/*
 * Decompiled with CFR 0.152.
 */
package org.jf.smali;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.Token;
import org.antlr.runtime.tree.CommonTree;
import org.antlr.runtime.tree.CommonTreeNodeStream;
import org.jf.dexlib2.Opcodes;
import org.jf.dexlib2.extra.DexMarker;
import org.jf.dexlib2.writer.builder.DexBuilder;
import org.jf.dexlib2.writer.io.FileDataStore;
import org.jf.smali.SmaliOptions;
import org.jf.smali.smaliFlexLexer;
import org.jf.smali.smaliParser;
import org.jf.smali.smaliTreeWalker;
import org.jf.util.StringUtils;

public class Smali {
    public static boolean assemble(SmaliOptions options, String ... input) throws IOException {
        return Smali.assemble(options, Arrays.asList(input));
    }

    public static boolean assemble(SmaliOptions options, List<String> input) throws IOException {
        boolean success = false;
        DexBuilder dexBuilder = new DexBuilder(Opcodes.forApi(options.apiLevel));
        if (options.markersListFile != null) {
            List<DexMarker> markerList = DexMarker.readMarkers(new File(options.markersListFile));
            dexBuilder.addMarkers(markerList.iterator());
        }
        for (String fileToProcess : input) {
            File argFile = new File(fileToProcess);
            if (!argFile.exists()) {
                throw new IOException("Cannot find file or directory \"" + fileToProcess + "\"");
            }
            if (!Smali.assemble(dexBuilder, argFile, options)) continue;
            success = true;
        }
        if (!success) {
            return false;
        }
        dexBuilder.writeTo(new FileDataStore(new File(options.outputDexFile)));
        return true;
    }

    private static boolean assemble(DexBuilder dexBuilder, File fileOrDir, SmaliOptions options) throws IOException {
        if (fileOrDir.isFile()) {
            if (!fileOrDir.getName().endsWith(".smali")) {
                return true;
            }
            return Smali.assembleSmaliFile(fileOrDir, dexBuilder, options);
        }
        File[] files = fileOrDir.listFiles();
        if (files == null) {
            return false;
        }
        boolean has_error = false;
        for (File file : files) {
            if (Smali.assemble(dexBuilder, file, options)) continue;
            has_error = true;
        }
        return !has_error;
    }

    public static boolean printTokens(SmaliOptions options, List<String> input) throws IOException {
        TreeSet<File> filesToProcessSet = new TreeSet<File>();
        for (String fileToProcess : input) {
            File argFile = new File(fileToProcess);
            if (!argFile.exists()) {
                throw new IllegalArgumentException("Cannot find file or directory \"" + fileToProcess + "\"");
            }
            if (argFile.isDirectory()) {
                Smali.getSmaliFilesInDir(argFile, filesToProcessSet);
                continue;
            }
            if (!argFile.isFile()) continue;
            filesToProcessSet.add(argFile);
        }
        boolean errors = false;
        for (File file : filesToProcessSet) {
            try {
                errors |= !Smali.printTokensForSingleFile(file, options);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        return !errors;
    }

    private static void getSmaliFilesInDir(@Nonnull File dir, @Nonnull Set<File> smaliFiles) {
        File[] files = dir.listFiles();
        if (files != null) {
            for (File file : files) {
                if (file.isDirectory()) {
                    Smali.getSmaliFilesInDir(file, smaliFiles);
                    continue;
                }
                if (!file.getName().endsWith(".smali")) continue;
                smaliFiles.add(file);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean assembleSmaliFile(File smaliFile, DexBuilder dexBuilder, SmaliOptions options) throws IOException {
        try (FileInputStream fis = null;){
            fis = new FileInputStream(smaliFile);
            InputStreamReader reader = new InputStreamReader((InputStream)fis, "UTF-8");
            smaliFlexLexer lexer = new smaliFlexLexer(reader, options.apiLevel);
            lexer.setSourceFile(smaliFile);
            CommonTokenStream tokens = new CommonTokenStream(lexer);
            if (options.printTokens) {
                tokens.getTokens();
                for (int i = 0; i < tokens.size(); ++i) {
                    Token token = tokens.get(i);
                    if (token.getChannel() == 99) continue;
                    String tokenName = token.getType() == -1 ? "EOF" : smaliParser.tokenNames[token.getType()];
                    System.out.println(tokenName + ": " + token.getText());
                }
                System.out.flush();
            }
            smaliParser parser = new smaliParser(tokens);
            parser.setVerboseErrors(options.verboseErrors);
            parser.setAllowOdex(options.allowOdexOpcodes);
            parser.setApiLevel(options.apiLevel);
            smaliParser.smali_file_return result = null;
            try {
                result = parser.smali_file();
            }
            catch (RecognitionException ex) {
                throw new IOException(ex);
            }
            if (parser.getNumberOfSyntaxErrors() > 0 || lexer.getNumberOfSyntaxErrors() > 0) {
                boolean ex = false;
                return ex;
            }
            CommonTree t = result.getTree();
            CommonTreeNodeStream treeStream = new CommonTreeNodeStream(t);
            treeStream.setTokenStream(tokens);
            if (options.printTokens) {
                System.out.println(t.toStringTree());
            }
            smaliTreeWalker dexGen = new smaliTreeWalker(treeStream);
            dexGen.setApiLevel(options.apiLevel);
            dexGen.setVerboseErrors(options.verboseErrors);
            dexGen.setDexBuilder(dexBuilder);
            try {
                dexGen.smali_file();
            }
            catch (RecognitionException ex) {
                throw new IOException(ex);
            }
            boolean bl = dexGen.getNumberOfSyntaxErrors() == 0;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean printTokensForSingleFile(File smaliFile, SmaliOptions options) throws Exception {
        try (FileInputStream fis = null;){
            fis = new FileInputStream(smaliFile);
            InputStreamReader reader = new InputStreamReader((InputStream)fis, "UTF-8");
            smaliFlexLexer lexer = new smaliFlexLexer(reader, options.apiLevel);
            lexer.setSourceFile(smaliFile);
            CommonTokenStream tokens = new CommonTokenStream(lexer);
            tokens.fill();
            for (int i = 0; i < tokens.size(); ++i) {
                Token token = tokens.get(i);
                if (token.getChannel() == 99) continue;
                String tokenName = token.getType() == -1 ? "EOF" : smaliParser.tokenNames[token.getType()];
                System.out.println(tokenName + "(\"" + StringUtils.escapeString(token.getText()) + "\")");
            }
            System.out.flush();
            boolean bl = lexer.getNumberOfSyntaxErrors() == 0;
            return bl;
        }
    }
}

