/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.rewriter;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import org.jf.dexlib2.Opcodes;
import org.jf.dexlib2.extra.DexMarker;
import org.jf.dexlib2.iface.ClassDef;
import org.jf.dexlib2.iface.DexFile;
import org.jf.dexlib2.rewriter.Rewriter;
import org.jf.dexlib2.rewriter.RewriterUtils;
import org.jf.dexlib2.rewriter.Rewriters;

public class DexFileRewriter
implements Rewriter<DexFile> {
    @Nonnull
    protected final Rewriters rewriters;

    public DexFileRewriter(@Nonnull Rewriters rewriters) {
        this.rewriters = rewriters;
    }

    @Override
    @Nonnull
    public DexFile rewrite(@Nonnull DexFile value) {
        return new RewrittenDexFile(value);
    }

    protected class RewrittenDexFile
    implements DexFile {
        @Nonnull
        protected final DexFile dexFile;
        private final List<DexMarker> markerList;

        public RewrittenDexFile(DexFile dexFile) {
            this.dexFile = dexFile;
            this.markerList = new ArrayList<DexMarker>(dexFile.getMarkers());
        }

        @Override
        public List<DexMarker> getMarkers() {
            return this.markerList;
        }

        @Override
        @Nonnull
        public Set<? extends ClassDef> getClasses() {
            return RewriterUtils.rewriteSet(DexFileRewriter.this.rewriters.getClassDefRewriter(), this.dexFile.getClasses());
        }

        @Override
        @Nonnull
        public Opcodes getOpcodes() {
            return this.dexFile.getOpcodes();
        }
    }
}

