/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.dexbacked.model;

import java.util.AbstractList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.jf.dexlib2.dexbacked.DexBuffer;
import org.jf.dexlib2.dexbacked.model.DexString;
import org.jf.dexlib2.dexbacked.model.DexStringSection;
import org.jf.dexlib2.dexbacked.model.DexTypeString;
import org.jf.util.collection.ArrayIterator;
import org.jf.util.collection.ComputingList;

public class DexTypeStringSection
extends AbstractList<DexTypeString>
implements Function<DexTypeString, String> {
    private final DexTypeString[] array;
    private final List<String> stringList;

    public DexTypeStringSection(int typeCount) {
        this.array = new DexTypeString[typeCount];
        this.stringList = new ComputingList<DexTypeString, String>(this, this);
    }

    public List<String> getStringList() {
        return this.stringList;
    }

    @Override
    public DexTypeString get(int i) {
        if (i < 0) {
            return null;
        }
        return this.array[i];
    }

    @Override
    public int size() {
        return this.array.length;
    }

    @Override
    @Nonnull
    public Iterator<DexTypeString> iterator() {
        return new ArrayIterator<DexTypeString>(this.array);
    }

    public void load(DexBuffer dexBuffer, int startOffset, DexStringSection stringSection) {
        DexTypeString[] array = this.array;
        int count = array.length;
        int itemSize = 4;
        for (int i = 0; i < count; ++i) {
            int typeOffset = startOffset + i * itemSize;
            int stringIndex = dexBuffer.readSmallUint(typeOffset);
            DexString dexString = stringSection.get(stringIndex);
            array[i] = new DexTypeString(dexString, i);
        }
    }

    @Override
    public String apply(DexTypeString dexTypeString) {
        if (dexTypeString != null) {
            return dexTypeString.getValue();
        }
        return null;
    }
}

