/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.xml;

import com.reandroid.common.Namespace;
import com.reandroid.utils.StringsUtil;
import com.reandroid.utils.collection.ArrayCollection;
import com.reandroid.utils.collection.CollectionUtil;
import com.reandroid.utils.collection.IndexIterator;
import com.reandroid.utils.collection.SizedSupplier;
import com.reandroid.xml.XMLAttribute;
import com.reandroid.xml.XMLComment;
import com.reandroid.xml.XMLDocument;
import com.reandroid.xml.XMLNamespace;
import com.reandroid.xml.XMLNode;
import com.reandroid.xml.XMLNodeTree;
import com.reandroid.xml.XMLText;
import com.reandroid.xml.XMLUtil;
import com.reandroid.xml.base.Attribute;
import com.reandroid.xml.base.Element;
import com.reandroid.xml.kxml2.KXmlParser;
import com.reandroid.xml.kxml2.KXmlSerializer;
import java.io.IOException;
import java.io.StringWriter;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

public class XMLElement
extends XMLNodeTree
implements Element<XMLNode> {
    private ArrayCollection<XMLAttribute> mAttributes = EMPTY_ATTRIBUTES;
    private String mName;
    private XMLNamespace mNamespace;
    private ArrayCollection<XMLNamespace> mNamespaceList = EMPTY_NAMESPACES;
    private boolean mVoidHtml;
    private static final ArrayCollection<XMLAttribute> EMPTY_ATTRIBUTES = ArrayCollection.empty();
    private static final ArrayCollection<XMLNamespace> EMPTY_NAMESPACES = ArrayCollection.empty();

    public XMLElement() {
    }

    public XMLElement(String tagName) {
        this();
        this.setName(tagName);
    }

    public void addText(String text) {
        this.newText(text);
    }

    @Override
    public XMLAttribute getAttributeAt(int index) {
        return this.mAttributes.get(index);
    }

    @Override
    public Iterator<? extends XMLAttribute> getAttributes() {
        return new IndexIterator<XMLAttribute>(new SizedSupplier<XMLAttribute>(){

            @Override
            public int size() {
                return XMLElement.this.getAttributeCount();
            }

            @Override
            public XMLAttribute get(int index) {
                return XMLElement.this.getAttributeAt(index);
            }
        });
    }

    @Override
    public String getUri() {
        XMLNamespace namespace = this.getNamespace();
        if (namespace != null) {
            return namespace.getUri();
        }
        return null;
    }

    @Override
    public String getPrefix() {
        XMLNamespace namespace = this.getNamespace();
        if (namespace != null) {
            return namespace.getPrefix();
        }
        return null;
    }

    @Override
    public XMLNamespace getNamespace() {
        return this.mNamespace;
    }

    public void setNamespace(XMLNamespace namespace) {
        this.mNamespace = namespace;
    }

    @Override
    public void setNamespace(Namespace namespace) {
        if (namespace == null) {
            this.setNamespace(null, null);
        } else {
            this.setNamespace(namespace.getUri(), namespace.getPrefix());
        }
    }

    public void setNamespace(String uri, String prefix) {
        this.setNamespace(this.getOrCreateXMLNamespace(uri, prefix));
    }

    @Override
    public int getNamespaceCount() {
        return this.mNamespaceList.size();
    }

    @Override
    public XMLNamespace getNamespaceAt(int index) {
        return this.mNamespaceList.get(index);
    }

    @Override
    public Iterator<? extends XMLNamespace> getNamespaces() {
        return this.mNamespaceList.iterator();
    }

    @Override
    public XMLNamespace newNamespace(String uri, String prefix) {
        XMLNamespace namespace = new XMLNamespace(uri, prefix);
        this.addNamespace(namespace);
        return namespace;
    }

    @Override
    public XMLElement newElement() {
        XMLElement element = new XMLElement();
        this.add(element);
        return element;
    }

    @Override
    public XMLText newText() {
        XMLText xmlText = new XMLText();
        this.add(xmlText);
        return xmlText;
    }

    @Override
    public XMLComment newComment() {
        XMLComment comment = new XMLComment();
        this.add(comment);
        return comment;
    }

    @Override
    public XMLAttribute newAttribute() {
        XMLAttribute attribute = new XMLAttribute();
        this.addAttribute(attribute);
        return attribute;
    }

    public void addNamespace(String uri, String prefix) {
        if (uri == null || prefix == null) {
            return;
        }
        this.newNamespace(uri, prefix);
    }

    public void addNamespace(XMLNamespace namespace) {
        if (namespace != null && !this.mNamespaceList.contains(namespace)) {
            if (this.mNamespaceList == EMPTY_NAMESPACES) {
                this.mNamespaceList = new ArrayCollection();
            } else if (this.mNamespaceList.contains(namespace)) {
                return;
            }
            this.mNamespaceList.add(namespace);
        }
    }

    public XMLNamespace getOrCreateXMLNamespace(String uri, String prefix) {
        if (uri == null || prefix == null) {
            return null;
        }
        XMLNamespace namespace = this.getXMLNamespace(uri, prefix);
        if (namespace != null) {
            return namespace;
        }
        namespace = this.getRootElement().newNamespace(uri, prefix);
        return namespace;
    }

    public XMLNamespace getXMLNamespace(String uri, String prefix) {
        if (uri == null || prefix == null) {
            return null;
        }
        int count = this.getNamespaceCount();
        for (int i = 0; i < count; ++i) {
            XMLNamespace namespace = this.getNamespaceAt(i);
            if (!namespace.isEqual(uri, prefix)) continue;
            return namespace;
        }
        XMLElement parent = this.getParentElement();
        if (parent != null) {
            return parent.getXMLNamespace(uri, prefix);
        }
        return null;
    }

    public XMLNamespace getXMLNamespaceByUri(String uri) {
        if (uri == null) {
            return null;
        }
        int count = this.getNamespaceCount();
        for (int i = 0; i < count; ++i) {
            XMLNamespace namespace = this.getNamespaceAt(i);
            if (!uri.equals(namespace.getUri())) continue;
            return namespace;
        }
        XMLElement parent = this.getParentElement();
        if (parent != null) {
            return parent.getXMLNamespaceByUri(uri);
        }
        return null;
    }

    public XMLNamespace getXMLNamespaceByPrefix(String prefix) {
        if (prefix == null) {
            return null;
        }
        int count = this.getNamespaceCount();
        for (int i = 0; i < count; ++i) {
            XMLNamespace namespace = this.getNamespaceAt(i);
            if (!prefix.equals(namespace.getPrefix())) continue;
            return namespace;
        }
        XMLElement parent = this.getParentElement();
        if (parent != null) {
            return parent.getXMLNamespaceByPrefix(prefix);
        }
        return null;
    }

    public Collection<XMLAttribute> listAttributes() {
        return this.mAttributes;
    }

    public int getChildElementsCount() {
        return super.countNodeWithType(XMLElement.class);
    }

    public List<XMLElement> getChildElementList() {
        return CollectionUtil.toList(this.iterator(XMLElement.class));
    }

    public Iterator<XMLElement> getElements(Predicate<XMLElement> filter) {
        return this.iterator(XMLElement.class, filter);
    }

    @Override
    public int getAttributeCount() {
        return this.mAttributes.size();
    }

    public String getAttributeValue(String name) {
        XMLAttribute attribute = this.getAttribute(name);
        if (attribute != null) {
            return attribute.getValueAsString();
        }
        return null;
    }

    public XMLAttribute getAttribute(String name) {
        if (name == null) {
            return null;
        }
        int count = this.getAttributeCount();
        for (int i = 0; i < count; ++i) {
            XMLAttribute attribute = this.getAttributeAt(i);
            if (!attribute.equalsName(name)) continue;
            return attribute;
        }
        return null;
    }

    public void clearAttributes() {
        if (this.mAttributes.size() == 0) {
            return;
        }
        for (int i = 0; i < this.mAttributes.size(); ++i) {
            XMLAttribute attribute = this.mAttributes.get(i);
            attribute.setParentNode(null);
        }
        this.mAttributes.clear();
        this.mAttributes.trimToSize();
    }

    public XMLAttribute removeAttribute(String name) {
        return this.removeAttribute(this.getAttribute(name));
    }

    public XMLAttribute removeAttribute(XMLAttribute attribute) {
        if (this.mAttributes.remove(attribute) && attribute != null) {
            attribute.setParentNode(null);
        }
        return attribute;
    }

    public XMLAttribute removeAttributeAt(int index) {
        XMLAttribute attribute = this.mAttributes.remove(index);
        if (attribute != null) {
            attribute.setParentNode(null);
        }
        return attribute;
    }

    public XMLAttribute setAttribute(String name, String value) {
        if (StringsUtil.isEmpty(name)) {
            return null;
        }
        XMLAttribute xmlAttribute = this.getAttribute(name);
        if (xmlAttribute == null) {
            if (XMLNamespace.looksNamespace(name, value)) {
                this.newNamespace(value, XMLUtil.splitName(name));
            } else {
                this.newAttribute().set(name, value);
            }
        } else {
            xmlAttribute.setValue(value);
        }
        return xmlAttribute;
    }

    public XMLElement addAttribute(String name, String value) {
        if (!StringsUtil.isEmpty(name)) {
            if (XMLNamespace.looksNamespace(name, value)) {
                this.newNamespace(value, XMLUtil.splitName(name));
            } else {
                this.newAttribute().set(name, value);
            }
        }
        return this;
    }

    public XMLElement addAttribute(String uri, String prefix, String name, String value) {
        if (!StringsUtil.isEmpty(name)) {
            if (XMLNamespace.looksNamespace(name, value)) {
                this.newNamespace(value, XMLUtil.splitName(name));
            } else {
                XMLAttribute attribute = new XMLAttribute();
                this.addAttribute(attribute);
                attribute.setName(uri, prefix, name);
                attribute.setValue(value);
            }
        }
        return this;
    }

    public void addAttribute(Attribute attribute) {
        if (attribute == null) {
            return;
        }
        XMLAttribute xmlAttribute = (XMLAttribute)attribute;
        if (this.mAttributes == EMPTY_ATTRIBUTES) {
            this.mAttributes = new ArrayCollection();
        }
        this.mAttributes.add(xmlAttribute);
        xmlAttribute.setParentNode(this);
    }

    public void addAttribute(int i, Attribute attribute) {
        if (attribute == null) {
            return;
        }
        XMLAttribute xmlAttribute = (XMLAttribute)attribute;
        if (this.mAttributes == EMPTY_ATTRIBUTES) {
            this.mAttributes = new ArrayCollection();
        }
        this.mAttributes.add(i, xmlAttribute);
        xmlAttribute.setParentNode(this);
    }

    public XMLElement getParentElement() {
        XMLNode parent = this.getParentNode();
        if (parent instanceof XMLElement) {
            return (XMLElement)parent;
        }
        return null;
    }

    public XMLElement getRootElement() {
        XMLElement parent = this.getParentElement();
        if (parent != null) {
            return parent.getRootElement();
        }
        return this;
    }

    public XMLDocument getParentDocument() {
        XMLElement root = this.getRootElement();
        XMLNode parent = root.getParentNode();
        if (parent instanceof XMLDocument) {
            return (XMLDocument)parent;
        }
        return null;
    }

    public int getDepth() {
        int result = 1;
        for (XMLElement parent = this.getParentElement(); parent != null; parent = parent.getParentElement()) {
            ++result;
        }
        return result;
    }

    public boolean equalsName(String name) {
        if (name == null) {
            return this.getName() == null;
        }
        String prefix = XMLUtil.splitPrefix(name);
        if (prefix != null && !prefix.equals(this.getPrefix())) {
            return false;
        }
        return name.equals(this.getName());
    }

    @Override
    public String getName() {
        return this.mName;
    }

    @Override
    public String getName(boolean includePrefix) {
        String name = this.getName();
        if (!includePrefix) {
            return name;
        }
        String prefix = this.getPrefix();
        if (prefix != null) {
            name = prefix + ":" + name;
        }
        return name;
    }

    @Override
    public void setName(String name) {
        this.setName(null, null, name);
    }

    public void setName(String uri, String name) {
        this.setName(uri, null, name);
    }

    public void setName(String uri, String prefix, String name) {
        XMLNamespace namespace;
        this.mName = XMLUtil.splitName(name);
        if (prefix == null) {
            prefix = XMLUtil.splitPrefix(name);
        }
        if (XMLUtil.isEmpty(uri)) {
            uri = null;
        }
        if (uri == null && prefix == null) {
            return;
        }
        if (uri == null) {
            namespace = this.getXMLNamespaceByPrefix(prefix);
            if (namespace == null) {
                throw new IllegalArgumentException("Namespace not found for prefix: " + prefix);
            }
        } else {
            namespace = this.getXMLNamespaceByUri(uri);
            if (namespace == null) {
                throw new IllegalArgumentException("Namespace not found for uri: " + uri);
            }
        }
        this.setNamespace(namespace);
    }

    public String getTextContent() {
        return this.getTextContent(false);
    }

    public String getTextContent(boolean escapeXmlText) {
        StringWriter writer = new StringWriter();
        try {
            for (XMLNode child : this) {
                child.write(writer, true, escapeXmlText);
            }
            writer.flush();
            writer.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return writer.toString();
    }

    public boolean hasAttribute(String name) {
        return this.getAttribute(name) != null;
    }

    public void setTextContent(String text, boolean escape) {
        super.clear();
        if (escape) {
            text = XMLUtil.escapeXmlChars(text);
        }
        this.addText(text);
    }

    public boolean isVoidHtml() {
        return this.mVoidHtml;
    }

    public void setVoidHtml(boolean voidHtml) {
        this.mVoidHtml = voidHtml;
        if (voidHtml) {
            this.transferChildrenToParent();
        }
    }

    private void transferChildrenToParent() {
        XMLNodeTree parentNode = (XMLNodeTree)this.getParentNode();
        if (parentNode != null) {
            int index = parentNode.indexOfExact(this);
            List<XMLNode> nodeList = CollectionUtil.toList(this.iterator());
            this.clear();
            for (XMLNode node : nodeList) {
                parentNode.add(++index, node);
            }
        }
    }

    @Override
    void startSerialize(XmlSerializer serializer) throws IOException {
        int i;
        int count = this.getNamespaceCount();
        for (i = 0; i < count; ++i) {
            XMLNamespace namespace = this.getNamespaceAt(i);
            serializer.setPrefix(namespace.getPrefix(), namespace.getUri());
        }
        serializer.startTag(this.getUri(), this.getName(false));
        count = this.getAttributeCount();
        for (i = 0; i < count; ++i) {
            this.getAttributeAt(i).serialize(serializer);
        }
    }

    @Override
    void endSerialize(XmlSerializer serializer) throws IOException {
        if (!this.isVoidHtml()) {
            serializer.endTag(this.getUri(), this.getName(false));
        } else {
            KXmlSerializer kXmlSerializer = XMLUtil.getKXmlSerializer(serializer);
            if (kXmlSerializer != null) {
                kXmlSerializer.endTag(true, this.getUri(), this.getName(false));
            }
        }
    }

    @Override
    protected void onStartParse(XmlPullParser parser) throws XmlPullParserException, IOException {
        XMLUtil.expectEvent(parser, 2);
        this.parseNamespaces(parser);
        this.setName(parser.getNamespace(), parser.getPrefix(), parser.getName());
        this.parseAttributes(parser);
        parser.nextToken();
    }

    @Override
    protected void onEndParse(XmlPullParser parser) throws XmlPullParserException, IOException {
        int event = parser.getEventType();
        if (event == 3) {
            KXmlParser kXmlParser;
            if (parser instanceof KXmlParser && this.size() == 0 && (kXmlParser = (KXmlParser)parser).isClosedWithTag()) {
                this.newText("");
            }
            if (this.equalsName(parser.getName())) {
                parser.nextToken();
            } else if (XMLUtil.hasFeatureRelaxed(parser)) {
                this.setVoidHtml(true);
            }
        } else if (event == 1) {
            this.setVoidHtml(true);
        }
    }

    private void parseNamespaces(XmlPullParser parser) throws XmlPullParserException {
        int i;
        int count = parser.getNamespaceCount(this.getDepth());
        for (i = 0; i < count; ++i) {
            this.addNamespace(parser.getNamespaceUri(i), parser.getNamespacePrefix(i));
        }
        count = parser.getAttributeCount();
        for (i = 0; i < count; ++i) {
            String value;
            String name = parser.getAttributeName(i);
            if (!XMLNamespace.looksNamespace(name, value = parser.getAttributeValue(i))) continue;
            this.addNamespace(value, XMLUtil.splitName(name));
        }
    }

    public void parseAttributes(XmlPullParser parser) {
        boolean processNamespaces = parser.getFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces");
        int count = parser.getAttributeCount();
        for (int i = 0; i < count; ++i) {
            String value;
            String name = parser.getAttributeName(i);
            if (XMLNamespace.looksNamespace(name, value = parser.getAttributeValue(i))) continue;
            String uri = parser.getAttributeNamespace(i);
            String prefix = parser.getAttributePrefix(i);
            if (processNamespaces) {
                name = XMLUtil.splitName(name);
            }
            this.addAttribute(uri, prefix, name, value);
        }
    }

    @Override
    void write(Appendable appendable, boolean xml, boolean escapeXmlText) throws IOException {
        appendable.append('<');
        appendable.append(this.getName());
        this.appendAttributes(appendable, xml, escapeXmlText);
        boolean haveChildes = false;
        Iterator<XMLNode> iterator = this.iterator();
        while (iterator.hasNext()) {
            if (!haveChildes) {
                appendable.append(">");
            }
            XMLNode child = iterator.next();
            child.write(appendable, xml, escapeXmlText);
            haveChildes = true;
        }
        if (!this.isVoidHtml()) {
            if (haveChildes) {
                appendable.append("</");
                appendable.append(this.getName());
                appendable.append('>');
            } else {
                appendable.append(" />");
            }
        }
    }

    void appendAttributes(Appendable appendable, boolean xml, boolean escapeXmlText) throws IOException {
        char separator = xml ? (char)' ' : ';';
        Iterator<? extends XMLAttribute> iterator = this.getAttributes();
        while (iterator.hasNext()) {
            appendable.append(separator);
            iterator.next().write(appendable, xml, escapeXmlText);
        }
    }

    public static XMLElement parseElement(XmlPullParser parser) throws IOException, XmlPullParserException {
        XMLElement element = new XMLElement();
        element.parse(parser);
        return element;
    }
}

