/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.xml;

import com.reandroid.utils.collection.IndexIterator;
import com.reandroid.utils.collection.SizedSupplier;
import com.reandroid.xml.Span;
import com.reandroid.xml.SpanAttributesEncoder;
import com.reandroid.xml.StyleAttribute;
import com.reandroid.xml.StyleText;
import com.reandroid.xml.XMLAttribute;
import com.reandroid.xml.XMLCDSect;
import com.reandroid.xml.XMLComment;
import com.reandroid.xml.XMLElement;
import com.reandroid.xml.XMLNode;
import com.reandroid.xml.XMLNodeTree;
import com.reandroid.xml.XMLText;
import com.reandroid.xml.XMLUtil;
import com.reandroid.xml.base.Attribute;
import java.io.IOException;
import java.util.Iterator;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

public class StyleElement
extends XMLElement
implements Span {
    @Override
    public StyleElement getParentElement() {
        return (StyleElement)super.getParentElement();
    }

    @Override
    public StyleAttribute getAttributeAt(int i) {
        return (StyleAttribute)super.getAttributeAt(i);
    }

    @Override
    public void addAttribute(Attribute attribute) {
        if (!(attribute instanceof StyleAttribute)) {
            throw new ClassCastException("Incompatible attribute type: " + attribute.getClass());
        }
        super.addAttribute(attribute);
    }

    @Override
    public StyleAttribute getAttribute(String name) {
        return (StyleAttribute)super.getAttribute(name);
    }

    public Iterator<StyleElement> getElements() {
        return this.iterator(StyleElement.class);
    }

    @Override
    public Iterator<StyleAttribute> getAttributes() {
        return new IndexIterator<StyleAttribute>(new SizedSupplier<StyleAttribute>(){

            @Override
            public int size() {
                return StyleElement.this.getAttributeCount();
            }

            @Override
            public StyleAttribute get(int index) {
                return StyleElement.this.getAttributeAt(index);
            }
        });
    }

    public String getTagString() {
        String tag = this.getTagName();
        String attributes = this.getSpanAttributes();
        if (attributes == null) {
            return tag;
        }
        return tag + attributes;
    }

    @Override
    public String getTagName() {
        return this.getName();
    }

    @Override
    public int getFirstChar() {
        XMLNode child;
        XMLNode parent = this.getRootParentNode();
        int result = 0;
        Iterator<XMLNode> itr = ((XMLNodeTree)parent).recursiveNodes();
        while (itr.hasNext() && (child = itr.next()) != this) {
            result += child.getTextLength();
        }
        return result;
    }

    @Override
    public int getLastChar() {
        int result = this.getFirstChar() + this.getLength();
        if (result != 0) {
            --result;
        }
        return result;
    }

    @Override
    public int getSpanOrder() {
        XMLNode child;
        XMLNode parent = this.getRootParentNode();
        int result = 0;
        Iterator<XMLNode> iterator = ((XMLNodeTree)parent).recursiveNodes();
        while (iterator.hasNext() && (child = iterator.next()) != this) {
            if (!(child instanceof StyleElement)) continue;
            ++result;
        }
        return result;
    }

    @Override
    public String getSpanAttributes() {
        return SpanAttributesEncoder.encodeAttributes(this);
    }

    @Override
    public StyleElement toElement() {
        return this;
    }

    @Override
    int getLength() {
        int result = 0;
        for (XMLNode child : this) {
            result += child.getLength();
        }
        return result;
    }

    void writeStyledText(Appendable appendable) throws IOException {
        for (XMLNode xmlNode : this) {
            if (xmlNode instanceof StyleText) {
                StyleText styleText = (StyleText)xmlNode;
                styleText.writeStyledText(appendable);
                continue;
            }
            if (!(xmlNode instanceof StyleElement)) continue;
            StyleElement element = (StyleElement)xmlNode;
            element.writeStyledText(appendable);
        }
    }

    @Override
    void startSerialize(XmlSerializer serializer) throws IOException {
        serializer.startTag(null, this.getName());
        Iterator<StyleAttribute> itr = this.getAttributes();
        while (itr.hasNext()) {
            itr.next().serialize(serializer);
        }
    }

    @Override
    void endSerialize(XmlSerializer serializer) throws IOException {
        serializer.endTag(null, this.getName());
    }

    @Override
    public void parse(XmlPullParser parser) throws XmlPullParserException, IOException {
        XMLUtil.expectEvent(parser, 2);
        this.setName(parser.getName());
        int count = parser.getAttributeCount();
        for (int i = 0; i < count; ++i) {
            this.newAttribute().set(parser.getAttributeName(i), parser.getAttributeValue(i));
        }
        int event = parser.next();
        while (event != 3 && event != 1) {
            if (event == 2) {
                this.newElement().parse(parser);
            } else if (XMLText.isTextEvent(event)) {
                this.newText().parse(parser);
            } else {
                parser.next();
            }
            event = parser.getEventType();
        }
        if (parser.getEventType() == 3) {
            parser.next();
        }
    }

    @Override
    public StyleElement newElement() {
        StyleElement element = new StyleElement();
        this.add(element);
        return element;
    }

    @Override
    public StyleText newText() {
        StyleText styleText = new StyleText();
        this.add(styleText);
        return styleText;
    }

    @Override
    public StyleText newText(String text) {
        StyleText styleText = this.newText();
        styleText.setText(text);
        return styleText;
    }

    @Override
    public XMLComment newComment() {
        return null;
    }

    @Override
    public StyleAttribute newAttribute() {
        StyleAttribute attribute = new StyleAttribute();
        this.addAttribute(attribute);
        return attribute;
    }

    void copyFrom(XMLElement xmlElement) {
        this.setName(xmlElement.getName());
        this.setVoidHtml(xmlElement.isVoidHtml());
        Iterator<? extends XMLAttribute> attributes = xmlElement.getAttributes();
        while (attributes.hasNext()) {
            this.newAttribute().setFrom(attributes.next());
        }
        for (XMLNode xmlNode : xmlElement) {
            if (xmlNode instanceof XMLElement) {
                this.newElement().copyFrom((XMLElement)xmlNode);
                continue;
            }
            if (xmlNode instanceof XMLText) {
                XMLText xmlText = (XMLText)xmlNode;
                this.getOrCreateLastText().appendText(xmlText.getText());
                continue;
            }
            if (!(xmlNode instanceof XMLCDSect)) continue;
            XMLCDSect xmlcdSect = (XMLCDSect)xmlNode;
            this.getOrCreateLastText().appendText(xmlcdSect.getText());
        }
    }

    @Override
    public String toString() {
        return "[" + this.getFirstChar() + ", " + this.getLastChar() + "] " + this.getTagString();
    }
}

