/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.utils.collection;

import com.reandroid.utils.collection.ArrayCollection;
import com.reandroid.utils.collection.EmptyIterator;
import com.reandroid.utils.collection.SingleIterator;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Function;

public class GroupMap<K, V> {
    private final int initialSize;
    private Map<K, Object> itemsMap;

    public GroupMap(int initialSize) {
        this.initialSize = initialSize;
        HashMap<K, Object> itemsMap = initialSize > 0 ? new HashMap(initialSize) : new HashMap<K, Object>();
        this.itemsMap = itemsMap;
    }

    public GroupMap() {
        this(0);
    }

    public void clear() {
        Map<K, Object> itemsMap = this.itemsMap;
        if (itemsMap.size() == 0) {
            return;
        }
        itemsMap.clear();
        itemsMap = this.initialSize > 0 ? new HashMap<K, Object>(this.initialSize) : new HashMap<K, Object>();
        this.itemsMap = itemsMap;
    }

    private void initializeEmpty(int size) {
        Map<K, Object> itemsMap = this.itemsMap;
        if (itemsMap.size() != 0) {
            return;
        }
        if (size < this.initialSize) {
            size = this.initialSize;
        }
        itemsMap = size > 0 ? new HashMap<K, Object>(size) : new HashMap<K, Object>();
        this.itemsMap = itemsMap;
    }

    public int size() {
        return this.itemsMap.size();
    }

    public boolean contains(K key) {
        return this.itemsMap.containsKey(key);
    }

    public Iterator<V> getAll(K key) {
        Map<K, Object> itemsMap = this.itemsMap;
        Object obj = itemsMap.get(key);
        if (obj == null) {
            return EmptyIterator.of();
        }
        if (obj instanceof Groups) {
            return ((Groups)obj).iterator();
        }
        return SingleIterator.of(obj);
    }

    public V get(K key) {
        Map<K, Object> itemsMap = this.itemsMap;
        Object obj = itemsMap.get(key);
        if (obj == null) {
            return null;
        }
        if (obj instanceof Groups) {
            return (V)((Groups)obj).getFirst();
        }
        return (V)obj;
    }

    public void putAll(Collection<? extends V> collection, Function<? super V, K> function) {
        if (collection.isEmpty()) {
            return;
        }
        this.initializeEmpty(collection.size());
        for (V value : collection) {
            this.put(function.apply(value), value);
        }
    }

    public void put(K key, V value) {
        Groups<Object> groups;
        if (key == null || value == null) {
            return;
        }
        Map<K, Object> itemsMap = this.itemsMap;
        Object obj = itemsMap.get(key);
        if (obj == null) {
            itemsMap.put(key, value);
            return;
        }
        if (obj instanceof Groups) {
            groups = (Groups<Object>)obj;
        } else {
            groups = new Groups<Object>();
            groups.add(obj);
            itemsMap.remove(key);
        }
        groups.addIfAbsent(value);
    }

    public void updateKey(K old, K key) {
        if (old == null || key == null || old == key) {
            return;
        }
        Map<K, Object> itemsMap = this.itemsMap;
        Object obj = itemsMap.remove(old);
        if (obj != null) {
            itemsMap.put(key, obj);
        }
    }

    public String toString() {
        return "size = " + this.size();
    }

    static class Groups<T>
    extends ArrayCollection<T> {
        Groups() {
        }

        void addIfAbsent(T item) {
            if (!this.containsExact(item)) {
                this.add(item);
            }
        }
    }
}

