/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.utils;

import com.reandroid.utils.ByteDigest;

public class SHA256
extends ByteDigest {
    private final int digestLength;
    private final int blockSize;
    private final int[] WORD;
    private final int[] state = new int[8];
    private final byte[] buffer;
    private int bufferOffset;
    private long bytesProcessed;
    private static final int[] ROUND_CONSTS = new int[]{1116352408, 1899447441, -1245643825, -373957723, 961987163, 1508970993, -1841331548, -1424204075, -670586216, 310598401, 607225278, 1426881987, 1925078388, -2132889090, -1680079193, -1046744716, -459576895, -272742522, 264347078, 604807628, 770255983, 1249150122, 1555081692, 1996064986, -1740746414, -1473132947, -1341970488, -1084653625, -958395405, -710438585, 113926993, 338241895, 666307205, 773529912, 1294757372, 1396182291, 1695183700, 1986661051, -2117940946, -1838011259, -1564481375, -1474664885, -1035236496, -949202525, -778901479, -694614492, -200395387, 275423344, 430227734, 506948616, 659060556, 883997877, 958139571, 1322822218, 1537002063, 1747873779, 1955562222, 2024104815, -2067236844, -1933114872, -1866530822, -1538233109, -1090935817, -965641998};
    private static final byte[] PADDING;

    public SHA256() {
        this.digestLength = 32;
        this.blockSize = 64;
        this.WORD = new int[64];
        this.buffer = new byte[this.blockSize];
        this.reset();
    }

    @Override
    public void update(byte[] bytes, int offset, int length) {
        if (length != 0) {
            int limit;
            if (this.bytesProcessed < 0L) {
                this.restart();
            }
            this.bytesProcessed += (long)length;
            if (this.bufferOffset != 0) {
                limit = Math.min(length, this.blockSize - this.bufferOffset);
                System.arraycopy(bytes, offset, this.buffer, this.bufferOffset, limit);
                this.bufferOffset += limit;
                offset += limit;
                length -= limit;
                if (this.bufferOffset >= this.blockSize) {
                    this.compress(this.buffer, 0);
                    this.bufferOffset = 0;
                }
            }
            if (length >= this.blockSize) {
                limit = offset + length;
                offset = this.compressMultiBlock(bytes, offset, limit - this.blockSize);
                length = limit - offset;
            }
            if (length > 0) {
                System.arraycopy(bytes, offset, this.buffer, 0, length);
                this.bufferOffset = length;
            }
        }
    }

    @Override
    public void digest(byte[] out, int outOffset) {
        if (this.bytesProcessed < 0L) {
            this.restart();
        }
        long bitsProcessed = this.bytesProcessed << 3;
        int index = (int)this.bytesProcessed & 0x3F;
        int padLen = index < 56 ? 56 - index : 120 - index;
        this.update(PADDING, 0, padLen);
        SHA256.putBigEndianInteger(this.buffer, 56, (int)(bitsProcessed >>> 32));
        SHA256.putBigEndianInteger(this.buffer, 60, (int)bitsProcessed);
        this.compress(this.buffer, 0);
        SHA256.i2bBig(this.state, out, outOffset, this.getDigestLength());
        this.bytesProcessed = -1L;
    }

    @Override
    public void reset() {
        int[] state = this.state;
        state[0] = 1779033703;
        state[1] = -1150833019;
        state[2] = 1013904242;
        state[3] = -1521486534;
        state[4] = 1359893119;
        state[5] = -1694144372;
        state[6] = 528734635;
        state[7] = 1541459225;
        SHA256.fillZero(this.WORD);
    }

    @Override
    public int getDigestLength() {
        return this.digestLength;
    }

    private void restart() {
        if (this.bytesProcessed != 0L) {
            this.reset();
            this.bufferOffset = 0;
            this.bytesProcessed = 0L;
            SHA256.fillZero(this.buffer);
        }
    }

    private int compressMultiBlock(byte[] b, int ofs, int limit) {
        while (ofs <= limit) {
            this.compress(b, ofs);
            ofs += this.blockSize;
        }
        return ofs;
    }

    private void compress(byte[] buf, int ofs) {
        this.compressCheck(buf, ofs);
        this.compressWord();
    }

    private void compressCheck(byte[] buf, int ofs) {
        SHA256.b2iBig64(buf, ofs, this.WORD);
    }

    private void compressWord() {
        int e;
        int d;
        int c;
        int b;
        int a;
        int[] word = this.WORD;
        int[] state = this.state;
        for (a = 16; a < 64; ++a) {
            b = word[a - 2];
            c = word[a - 15];
            d = (c >>> 7 | c << 25) ^ (c >>> 18 | c << 14) ^ c >>> 3;
            e = (b >>> 17 | b << 15) ^ (b >>> 19 | b << 13) ^ b >>> 10;
            word[a] = d + e + word[a - 7] + word[a - 16];
        }
        a = state[0];
        b = state[1];
        c = state[2];
        d = state[3];
        e = state[4];
        int f = state[5];
        int g = state[6];
        int h = state[7];
        for (int i = 0; i < 64; ++i) {
            int T1 = h + this.sigmaCh(e, f, g) + ROUND_CONSTS[i] + word[i];
            int T2 = this.T2(a, b, c);
            h = g;
            g = f;
            f = e;
            e = d + T1;
            d = c;
            c = b;
            b = a;
            a = T1 + T2;
        }
        state[0] = state[0] + a;
        state[1] = state[1] + b;
        state[2] = state[2] + c;
        state[3] = state[3] + d;
        state[4] = state[4] + e;
        state[5] = state[5] + f;
        state[6] = state[6] + g;
        state[7] = state[7] + h;
    }

    private int sigmaCh(int e, int f, int g) {
        int sigma = (e >>> 6 | e << 26) ^ (e >>> 11 | e << 21) ^ (e >>> 25 | e << 7);
        int ch = e & f ^ ~e & g;
        return sigma + ch;
    }

    private int T2(int a, int b, int c) {
        int sigma = (a >>> 2 | a << 30) ^ (a >>> 13 | a << 19) ^ (a >>> 22 | a << 10);
        int maj = a & b ^ a & c ^ b & c;
        return sigma + maj;
    }

    private static void b2iBig64(byte[] in, int inOfs, int[] out) {
        if ((inOfs & 3) == 0) {
            for (int i = 0; i < 16; ++i) {
                out[i] = SHA256.getBigEndianInteger(in, inOfs + i * 4);
            }
        } else {
            int outOfs = 0;
            int len = 64;
            len += inOfs;
            while (inOfs < len) {
                out[outOfs++] = SHA256.getBigEndianInteger(in, inOfs);
                inOfs += 4;
            }
        }
    }

    private static void i2bBig(int[] in, byte[] out, int outOffset, int len) {
        int inOfs = 0;
        if ((outOffset & 3) == 0) {
            len += outOffset;
            while (outOffset < len) {
                SHA256.putBigEndianInteger(out, outOffset, in[inOfs++]);
                outOffset += 4;
            }
        } else {
            len += outOffset;
            while (outOffset < len) {
                int i = in[inOfs++];
                out[outOffset++] = (byte)(i >> 24);
                out[outOffset++] = (byte)(i >> 16);
                out[outOffset++] = (byte)(i >> 8);
                out[outOffset++] = (byte)i;
            }
        }
    }

    static {
        byte[] pad = new byte[136];
        PADDING = pad;
        pad[0] = -128;
    }
}

