/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.utils;

import com.reandroid.utils.ByteDigest;
import com.reandroid.utils.NumbersUtil;

public class SHA1
extends ByteDigest {
    private static final int round1_kt = 1518500249;
    private static final int round2_kt = 1859775393;
    private static final int round3_kt = -1894007588;
    private static final int round4_kt = -899497514;
    private final byte[] padding = new byte[136];
    private final int[] WORD;
    private final int[] state;
    private final byte[] buffer = new byte[64];
    private int bufferOffset;
    private long bytesProcessed;

    public SHA1() {
        this.WORD = new int[80];
        this.state = new int[5];
        this.padding[0] = -128;
        this.resetState();
    }

    @Override
    public void update(byte[] bytes, int offset, int length) {
        int limit;
        if (this.bytesProcessed < 0L) {
            this.reset();
        }
        this.bytesProcessed += (long)length;
        if (this.bufferOffset != 0) {
            limit = NumbersUtil.min(length, 64 - this.bufferOffset);
            System.arraycopy(bytes, offset, this.buffer, this.bufferOffset, limit);
            this.bufferOffset += limit;
            offset += limit;
            length -= limit;
            if (this.bufferOffset >= 64) {
                this.compressBytes(this.buffer, 0);
                this.bufferOffset = 0;
            }
        }
        if (length >= 64) {
            limit = offset + length;
            offset = this.compressMultiBlock(bytes, offset, limit - 64);
            length = limit - offset;
        }
        if (length > 0) {
            System.arraycopy(bytes, offset, this.buffer, 0, length);
            this.bufferOffset = length;
        }
    }

    @Override
    public int getDigestLength() {
        return 20;
    }

    @Override
    public void reset() {
        if (this.bytesProcessed != 0L) {
            this.resetState();
            SHA1.fillZero(this.WORD);
            this.bufferOffset = 0;
            this.bytesProcessed = 0L;
            SHA1.fillZero(this.buffer);
        }
    }

    @Override
    public void digest(byte[] out, int offset) {
        if (this.bytesProcessed < 0L) {
            this.reset();
        }
        this.digestBytes(out, offset);
        this.bytesProcessed = -1L;
    }

    private void digestBytes(byte[] out, int offset) {
        long bitsProcessed = this.bytesProcessed << 3;
        int index = (int)this.bytesProcessed & 0x3F;
        int padLen = index < 56 ? 56 - index : 120 - index;
        this.update(this.padding, 0, padLen);
        SHA1.putBigEndianInteger(this.buffer, 56, (int)(bitsProcessed >>> 32));
        SHA1.putBigEndianInteger(this.buffer, 60, (int)bitsProcessed);
        this.compressBytes(this.buffer, 0);
        this.writeBigInt(this.state, out, offset);
    }

    private void resetState() {
        int[] state = this.state;
        state[0] = 1732584193;
        state[1] = -271733879;
        state[2] = -1732584194;
        state[3] = 271733878;
        state[4] = -1009589776;
    }

    private int compressMultiBlock(byte[] bytes, int offset, int limit) {
        while (offset <= limit) {
            this.compressBytes(bytes, offset);
            offset += 64;
        }
        return offset;
    }

    private void compressBytes(byte[] buf, int offset) {
        int[] word = this.WORD;
        for (int i = 0; i < 16; ++i) {
            word[i] = SHA1.getBigEndianInteger(buf, offset + i * 4);
        }
        this.compressWord(word);
    }

    private void compressWord(int[] word) {
        int temp;
        int i;
        int b;
        int a;
        for (a = 16; a <= 79; ++a) {
            b = word[a - 3] ^ word[a - 8] ^ word[a - 14] ^ word[a - 16];
            word[a] = b << 1 | b >>> 31;
        }
        int[] state = this.state;
        a = state[0];
        b = state[1];
        int c = state[2];
        int d = state[3];
        int e = state[4];
        for (i = 0; i < 20; ++i) {
            temp = (a << 5 | a >>> 27) + (b & c | ~b & d) + e + word[i] + 1518500249;
            e = d;
            d = c;
            c = b << 30 | b >>> 2;
            b = a;
            a = temp;
        }
        for (i = 20; i < 40; ++i) {
            temp = (a << 5 | a >>> 27) + (b ^ c ^ d) + e + word[i] + 1859775393;
            e = d;
            d = c;
            c = b << 30 | b >>> 2;
            b = a;
            a = temp;
        }
        for (i = 40; i < 60; ++i) {
            temp = (a << 5 | a >>> 27) + (b & c | b & d | c & d) + e + word[i] + -1894007588;
            e = d;
            d = c;
            c = b << 30 | b >>> 2;
            b = a;
            a = temp;
        }
        for (i = 60; i < 80; ++i) {
            temp = (a << 5 | a >>> 27) + (b ^ c ^ d) + e + word[i] + -899497514;
            e = d;
            d = c;
            c = b << 30 | b >>> 2;
            b = a;
            a = temp;
        }
        state[0] = state[0] + a;
        state[1] = state[1] + b;
        state[2] = state[2] + c;
        state[3] = state[3] + d;
        state[4] = state[4] + e;
    }

    private void writeBigInt(int[] in, byte[] out, int offset) {
        int length = offset + 20;
        int i = 0;
        while (offset < length) {
            SHA1.putBigEndianInteger(out, offset, in[i]);
            offset += 4;
            ++i;
        }
    }
}

