/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.utils;

import com.reandroid.utils.NumbersUtil;

public class NumberX
extends Number
implements Comparable<Number> {
    private final int width;
    private final long value;

    private NumberX(int width, long value) {
        if (width < 1 || width > 8) {
            throw new NumberFormatException("Width out of range [1 ... 8], " + width);
        }
        this.width = width;
        this.value = value;
    }

    public long unsigned() {
        long l = this.longValue();
        int width = this.width();
        if (width == 8) {
            return l;
        }
        long mask = -1L >>> (8 - width) * 8;
        return l & mask;
    }

    public int width() {
        return this.width;
    }

    @Override
    public int intValue() {
        return (int)this.longValue();
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return Float.intBitsToFloat(this.intValue());
    }

    @Override
    public double doubleValue() {
        return Double.longBitsToDouble(this.longValue());
    }

    public String toHex() {
        return NumberX.toHexString(this.width(), this.longValue());
    }

    @Override
    public int compareTo(Number number) {
        return Long.compare(this.longValue(), number.longValue());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Number)) {
            return false;
        }
        Number number = (Number)obj;
        return this.longValue() == number.longValue();
    }

    public int hashCode() {
        return Long.hashCode(this.longValue());
    }

    public String toString() {
        return Long.toString(this.longValue());
    }

    public static NumberX valueOf(long value) {
        return new NumberX(NumberX.widthOfSigned(value), value);
    }

    public static NumberX valueOfUnsigned(int width, long value) {
        value = NumberX.encodeUnSigned(width, value);
        return new NumberX(width, value);
    }

    public static NumberX valueOf(int width, long value) {
        return new NumberX(width, value);
    }

    public static int toStandardWidth(int width) {
        if (width == 3) {
            width = 4;
        } else if (width == 5 || width == 6 || width == 7) {
            width = 8;
        }
        return width;
    }

    public static int widthOfSigned(long signedValue) {
        int width;
        block3: {
            block2: {
                width = 1;
                if (signedValue >= 0L) break block2;
                while (NumberX.minValueForWidth(width) > signedValue) {
                    ++width;
                }
                break block3;
            }
            if (signedValue <= 0L) break block3;
            while (NumberX.maxValueForWidth(width) < signedValue) {
                ++width;
            }
        }
        return width;
    }

    public static long encodeUnSigned(int width, long unsignedValue) {
        int shift = (width - 1) * 8;
        long high = unsignedValue >>> shift & 0xFFL;
        if (high < 128L) {
            return unsignedValue;
        }
        shift = (16 - width) * 8;
        long mask = -1L >>> shift ^ 0xFFFFFFFFFFFFFFFFL;
        return unsignedValue |= mask;
    }

    public static long maxValueForWidth(int width) {
        return NumberX.minValueForWidth(width) ^ 0xFFFFFFFFFFFFFFFFL;
    }

    public static long minValueForWidth(int width) {
        int shift = (width - 1) * 8;
        long min = 128L << shift;
        return -min;
    }

    private static int hexWidth(long value) {
        if (value == 0L) {
            return 1;
        }
        int i = 0;
        while (value != 0L) {
            value >>>= 4;
            ++i;
        }
        return i;
    }

    public static String toHexString(int width, long value) {
        if (width == 0) {
            width = 1;
        }
        boolean neg = false;
        if (value < 0L) {
            value = -value;
            neg = true;
        }
        int length = NumbersUtil.min(width * 2, NumberX.hexWidth(value));
        int w = length + 2;
        if (neg) {
            ++w;
        }
        byte[] results = new byte[w];
        int j = 0;
        if (neg) {
            results[j] = 45;
            ++j;
        }
        results[j] = 48;
        results[j + 1] = 120;
        j = w - 1;
        for (int i = 0; i < length; ++i) {
            results[j] = NumberX.toHexChar((int)(value & 0xFL));
            value >>>= 4;
            --j;
        }
        return new String(results);
    }

    private static byte toHexChar(int i) {
        if (i >= 0) {
            if (i < 10) {
                return (byte)(i += 48);
            }
            if (i <= 16) {
                i -= 10;
                return (byte)(i += 97);
            }
        }
        return 0;
    }
}

