/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.utils;

import com.reandroid.utils.StringsUtil;
import java.util.Comparator;
import java.util.function.Function;

public class CompareUtil {
    public static final Comparator<String> STRING_COMPARATOR = CompareUtil::compare;
    private static final Comparator<?> TO_STRING_COMPARATOR = StringsUtil::compareToString;
    private static final Comparator<Comparable<?>> COMPARATOR = new Comparator<Comparable<?>>(){

        @Override
        public int compare(Comparable comparable1, Comparable comparable2) {
            return CompareUtil.compare(comparable1, comparable2);
        }
    };
    private static final Comparator<Comparable<?>> INVERSE_COMPARATOR = new Comparator<Comparable<?>>(){

        @Override
        public int compare(Comparable comparable1, Comparable comparable2) {
            return CompareUtil.compare(comparable2, comparable1);
        }
    };

    public static <T, E extends Comparable<E>> Comparator<T> computeComparator(Function<? super T, E> function) {
        return (t1, t2) -> CompareUtil.compare((Comparable)function.apply(t1), (Comparable)function.apply(t2));
    }

    public static <T extends Comparable<? super T>> int compare(T[] items1, T[] items2) {
        if (items1 == items2) {
            return 0;
        }
        boolean empty1 = CompareUtil.isEmpty(items1);
        boolean empty2 = CompareUtil.isEmpty(items2);
        if (empty1 && empty2) {
            return 0;
        }
        if (empty1) {
            return -1;
        }
        if (empty2) {
            return 1;
        }
        int length1 = items1.length;
        int length = length1;
        int length2 = items2.length;
        if (length > length2) {
            length = length2;
        }
        for (int i = 0; i < length; ++i) {
            int compare = CompareUtil.compare(items1[i], items2[i]);
            if (compare == 0) continue;
            return compare;
        }
        return Integer.compare(length1, length2);
    }

    private static boolean isEmpty(Object[] objects) {
        return objects == null || objects.length == 0;
    }

    public static int compare(int i1, int i2) {
        if (i1 == i2) {
            return 0;
        }
        if (i1 > i2) {
            return 1;
        }
        return -1;
    }

    public static int compare(boolean b1, boolean b2) {
        if (b1 == b2) {
            return 0;
        }
        if (b1) {
            return 1;
        }
        return -1;
    }

    public static int compareUnsigned(int i1, int i2) {
        if (i1 == i2) {
            return 0;
        }
        long l1 = (long)i1 & 0xFFFFFFFFL;
        long l2 = (long)i2 & 0xFFFFFFFFL;
        if (l1 > l2) {
            return 1;
        }
        return -1;
    }

    public static <T extends Comparable<? super T>> int compare(T item1, T item2) {
        if (item1 == item2) {
            return 0;
        }
        if (item1 == null) {
            return -1;
        }
        if (item2 == null) {
            return 1;
        }
        int i = item1.compareTo(item2);
        if (i == 0) {
            return 0;
        }
        if (i > 0) {
            return 1;
        }
        return -1;
    }

    public static <T> Comparator<T> getComparatorUnchecked() {
        return COMPARATOR;
    }

    public static <E, T extends Comparable<E>> Comparator<T> getInverseComparator() {
        return INVERSE_COMPARATOR;
    }

    public static <E, T extends Comparable<E>> Comparator<T> getComparableComparator() {
        return COMPARATOR;
    }

    public static <T1> Comparator<T1> getToStringComparator() {
        return TO_STRING_COMPARATOR;
    }
}

