/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.jcommand.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class SpreadSheet
implements Iterable<Row> {
    private final List<Row> rowList = new ArrayList<Row>();
    public static final int INDENT_LEFT = 0;
    public static final int INDENT_CENTER = 1;
    public static final int INDENT_RIGHT = 2;
    public static final int INDENT_TOP = 0;
    public static final int INDENT_MIDDLE = 1;
    public static final int INDENT_BOTTOM = 2;

    public SpreadSheet format() {
        SpreadSheet spreadSheet = new SpreadSheet();
        for (Row parent : this) {
            spreadSheet.addAll(parent.getSplitLines());
        }
        return spreadSheet;
    }

    public SpreadSheet add(Row row) {
        this.rowList.add(row);
        return this;
    }

    public SpreadSheet addAll(Collection<? extends Row> rows) {
        this.rowList.addAll(rows);
        return this;
    }

    public Row get(int i) {
        if (i >= 0 && i < this.rowList.size()) {
            return this.rowList.get(i);
        }
        return null;
    }

    public int size() {
        return this.rowList.size();
    }

    public void clear() {
        this.rowList.clear();
    }

    public int getPrintWidth() {
        int result = 0;
        for (Row row : this) {
            int width = row.getPrintWidth();
            if (width <= result) continue;
            result = width;
        }
        return result;
    }

    public int getMergedCellsWidth() {
        int result = 0;
        for (Row row : this) {
            int width = row.getMergedCellsWidth();
            if (width <= result) continue;
            result = width;
        }
        return result;
    }

    public void setIndent(int columnIndex, int indent) {
        for (Row row : this) {
            row.setIndent(columnIndex, indent);
        }
    }

    public int getColumnCount() {
        int result = 0;
        for (Row row : this) {
            int count = row.getColumnCount();
            if (count <= result) continue;
            result = count;
        }
        return result;
    }

    public void setColumnCount(int columnCount) {
        for (Row row : this) {
            row.ensureSize(columnCount);
        }
    }

    public void fixColumnCount() {
        this.setColumnCount(this.getColumnCount());
    }

    public void setBorderLeft(int columnIndex, String border) {
        for (Row row : this) {
            row.setBorderLeft(columnIndex, border);
        }
    }

    public void setBorderRight(int columnIndex, String border) {
        for (Row row : this) {
            row.setBorderRight(columnIndex, border);
        }
    }

    public int itemWidth(int columnIndex) {
        int result = 0;
        for (Row row : this) {
            int width = row.itemWidth(columnIndex);
            if (width <= result) continue;
            result = width;
        }
        return result;
    }

    public int getColumnPrintWidth(int columnIndex) {
        int result = 0;
        for (Row row : this) {
            int width = row.getColumnPrintWidth(columnIndex);
            if (width <= result) continue;
            result = width;
        }
        return result;
    }

    public void setColumnWidth(int columnIndex, int columnWidth) {
        for (Row row : this) {
            row.setColumnWidth(columnIndex, columnWidth);
        }
    }

    public int fitColumnWidth(int columnIndex) {
        int width = this.itemWidth(columnIndex);
        this.setColumnWidth(columnIndex, width);
        return width;
    }

    public void fitColumnWidth() {
        int columnCount = this.getColumnCount();
        for (int i = 0; i < columnCount; ++i) {
            this.fitColumnWidth(i);
        }
    }

    @Override
    public Iterator<Row> iterator() {
        return this.rowList.iterator();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            if (i != 0) {
                builder.append('\n');
            }
            builder.append(this.get(i));
        }
        return builder.toString();
    }

    public static String[] splitNewLineOrWidth(int width, String line) {
        int count = 0;
        int length = line.length();
        int currentWidth = 0;
        if (width == length) {
            currentWidth = -length;
        }
        StringBuilder lineBuilder = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            char ch = line.charAt(i);
            lineBuilder.append(ch);
            if (ch != '\n' && ++currentWidth != width) continue;
            ++count;
            currentWidth = 0;
            if (ch == '\n') continue;
            currentWidth = SpreadSheet.placeNewline(lineBuilder, width);
        }
        line = lineBuilder.toString();
        length = line.length();
        String[] results = new String[count + 1];
        int index = 0;
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            char ch = line.charAt(i);
            if (ch == '\n') {
                results[index] = builder.toString();
                builder = new StringBuilder();
                ++index;
                continue;
            }
            builder.append(ch);
        }
        if (index < results.length) {
            results[index] = builder.toString();
        }
        return results;
    }

    private static int placeNewline(StringBuilder builder, int width) {
        int half = width / 2;
        int length = builder.length();
        if (half >= length) {
            return 0;
        }
        half = length - half;
        for (int i = length - 1; i > half; --i) {
            char ch = builder.charAt(i);
            if (ch == '\n') {
                return 0;
            }
            if (ch != ' ' && ch != '\t') continue;
            builder.deleteCharAt(i);
            builder.insert(i, '\n');
            return length - i;
        }
        builder.append('\n');
        return 0;
    }

    public static String fillSpace(int amount) {
        return SpreadSheet.fill(' ', amount);
    }

    public static void fillSpace(StringBuilder builder, int amount) {
        SpreadSheet.fill(builder, ' ', amount);
    }

    public static String fill(char ch, int amount) {
        StringBuilder builder = new StringBuilder(amount);
        SpreadSheet.fill(builder, ch, amount);
        return builder.toString();
    }

    public static void fill(StringBuilder builder, char ch, int amount) {
        if (ch != '\u0000') {
            for (int i = 0; i < amount; ++i) {
                builder.append(ch);
            }
        }
    }

    public static class SeparatorCells
    extends MergedCells {
        private char mChar = (char)95;

        public SeparatorCells(List<Cell> childCells) {
            super(childCells);
        }

        public char getChar() {
            return this.mChar;
        }

        public void setChar(char mChar) {
            this.mChar = mChar;
        }

        @Override
        public MergedCells copyOf(Object item) {
            SeparatorCells separatorCells = (SeparatorCells)super.copyOf(item);
            separatorCells.setChar(this.getChar());
            return separatorCells;
        }

        @Override
        SeparatorCells createNew(List<Cell> list) {
            return new SeparatorCells(list);
        }

        @Override
        public String toString() {
            return this.getBorderLeft() + SpreadSheet.fill(this.getChar(), this.getColumnWidth()) + this.getBorderRight();
        }
    }

    public static class MergedCells
    extends Cell
    implements Iterable<Cell> {
        private final List<Cell> childCells;

        public MergedCells(List<Cell> childCells) {
            this.childCells = childCells;
        }

        @Override
        public int itemWidth() {
            return 0;
        }

        @Override
        String indentHorizontally(int width, String line) {
            return super.indentHorizontally(width, line);
        }

        @Override
        public MergedCells copyOf(Object item) {
            ArrayList<Cell> list = new ArrayList<Cell>();
            Cell first = this.getFirst();
            if (first != null) {
                list.add(first.copyOf(item));
                int size = this.size();
                for (int i = 1; i < size; ++i) {
                    Cell cell = this.get(i);
                    list.add(cell.copyOf(""));
                }
            }
            MergedCells mergedCells = this.createNew(list);
            mergedCells.setHorizontalIndent(this.getHorizontalIndent());
            mergedCells.setVerticalIndent(this.getVerticalIndent());
            mergedCells.setBorderLeft(this.getBorderLeft());
            mergedCells.setBorderRight(this.getBorderRight());
            return mergedCells;
        }

        MergedCells createNew(List<Cell> list) {
            return new MergedCells(list);
        }

        @Override
        public int getCellCount() {
            return this.size();
        }

        public Cell get(int i) {
            if (i >= 0 && i < this.childCells.size()) {
                return this.childCells.get(i);
            }
            return null;
        }

        public void add(Cell cell) {
            this.childCells.add(cell);
        }

        public int size() {
            return this.childCells.size();
        }

        public Cell getFirst() {
            return this.get(0);
        }

        @Override
        public Object getItem() {
            Cell cell = this.getFirst();
            if (cell != null) {
                return cell.getItem();
            }
            return null;
        }

        @Override
        public void setItem(Object item) {
            Cell cell = this.getFirst();
            if (cell != null) {
                cell.setItem(item);
            }
        }

        void addEmptyCells(int amount) {
            for (int i = 0; i < amount; ++i) {
                this.add(new Cell(""));
            }
        }

        @Override
        public int getColumnWidth() {
            int result = 0;
            for (Cell cell : this) {
                result += cell.getPrintWidth();
            }
            result -= this.getBorderLeft().length();
            if ((result -= this.getBorderRight().length()) < 0) {
                result = 0;
            }
            return result;
        }

        @Override
        public Iterator<Cell> iterator() {
            return this.childCells.iterator();
        }
    }

    public static class Cell {
        private Object item;
        private String borderLeft;
        private String borderRight;
        private int columnWidth;
        private int horizontalIndent;
        private int verticalIndent;
        private List<Cell> splitLines;

        public Cell(Object item) {
            this.item = item;
            this.borderLeft = "";
            this.borderRight = "  ";
            this.horizontalIndent = 0;
            this.verticalIndent = 0;
        }

        public Cell() {
            this(null);
        }

        public Object getItem() {
            return this.item;
        }

        public void setItem(Object item) {
            this.item = item;
        }

        public Cell copyOf(Object item) {
            Cell cell = new Cell(item);
            cell.setHorizontalIndent(this.getHorizontalIndent());
            cell.setVerticalIndent(this.getVerticalIndent());
            cell.setColumnWidth(this.getColumnWidth());
            cell.setBorderLeft(this.getBorderLeft());
            cell.setBorderRight(this.getBorderRight());
            return cell;
        }

        public int getCellCount() {
            return 1;
        }

        public String getBorderLeft() {
            return this.borderLeft;
        }

        public void setBorderLeft(String borderLeft) {
            this.borderLeft = borderLeft;
        }

        public String getBorderRight() {
            return this.borderRight;
        }

        public void setBorderRight(String borderRight) {
            this.borderRight = borderRight;
        }

        public String getItemString() {
            Object obj = this.getItem();
            return obj == null ? "" : obj.toString();
        }

        public int getPrintWidth() {
            return this.getBorderLeft().length() + this.getColumnWidth() + this.getBorderRight().length();
        }

        public int itemWidth() {
            return this.widthOf(this.getItemString());
        }

        int widthOf(String str) {
            int length = str.length();
            int result = 0;
            int current = 0;
            for (int i = 0; i < length; ++i) {
                char ch = str.charAt(i);
                current += this.widthOf(ch);
                if (str.charAt(i) != '\n') continue;
                if (current > result) {
                    result = current;
                }
                current = 0;
            }
            if (current > result) {
                result = current;
            }
            return result;
        }

        private int widthOf(char ch) {
            if (ch == '\n' || ch == '\r') {
                return 0;
            }
            return 1;
        }

        public int getHorizontalIndent() {
            return this.horizontalIndent;
        }

        public void setHorizontalIndent(int horizontalIndent) {
            if (horizontalIndent != this.horizontalIndent) {
                if (horizontalIndent < 0 || horizontalIndent > 2) {
                    throw new IllegalArgumentException("Invalid horizontal indent: '" + horizontalIndent + "', should be bn " + 0 + "~" + 2);
                }
                this.horizontalIndent = horizontalIndent;
                this.splitLines = null;
            }
        }

        public int getVerticalIndent() {
            return this.verticalIndent;
        }

        public void setVerticalIndent(int verticalIndent) {
            if (verticalIndent != this.verticalIndent) {
                if (verticalIndent < 0 || verticalIndent > 2) {
                    throw new IllegalArgumentException("Invalid vertical indent: '" + verticalIndent + "', should be bn " + 0 + "~" + 2);
                }
                this.verticalIndent = verticalIndent;
                this.splitLines = null;
            }
        }

        public int getColumnWidth() {
            int width = this.columnWidth;
            if (width == 0) {
                width = this.itemWidth();
            }
            return width;
        }

        public void setColumnWidth(int columnWidth) {
            if (columnWidth != this.columnWidth) {
                this.columnWidth = columnWidth;
                this.splitLines = null;
            }
        }

        public Cell getSplitLine(int index) {
            return this.getSplitLines().get(index);
        }

        public int getSplitLinesSize() {
            return this.getSplitLines().size();
        }

        public void setSplitLinesSize(int size) {
            int i;
            int bottomHalf;
            int topHalf;
            List<Cell> splitLines = this.getSplitLines();
            String filler = SpreadSheet.fillSpace(this.getColumnWidth());
            int remaining = size - splitLines.size();
            int indent = this.getVerticalIndent();
            if (indent == 2) {
                topHalf = remaining;
                bottomHalf = 0;
            } else if (indent == 1) {
                topHalf = remaining / 2;
                bottomHalf = remaining - topHalf;
            } else {
                topHalf = 0;
                bottomHalf = remaining;
            }
            for (i = 0; i < topHalf; ++i) {
                splitLines.add(0, this.copyOf(filler));
            }
            for (i = 0; i < bottomHalf; ++i) {
                splitLines.add(this.copyOf(filler));
            }
        }

        public List<Cell> getSplitLines() {
            List<Cell> splitLines = this.splitLines;
            if (splitLines == null) {
                this.splitLines = splitLines = this.splitLines();
            }
            return splitLines;
        }

        private List<Cell> splitLines() {
            int width = this.getColumnWidth();
            String[] lines = SpreadSheet.splitNewLineOrWidth(width, this.getItemString());
            ArrayList<Cell> results = new ArrayList<Cell>(lines.length);
            for (String line : lines) {
                line = this.indentHorizontally(width, line);
                results.add(this.copyOf(line));
            }
            return results;
        }

        String indentHorizontally(int width, String line) {
            int rightHalf;
            int leftHalf;
            int remaining = width - line.length();
            if (remaining == 0) {
                return line;
            }
            int indent = this.getHorizontalIndent();
            if (indent == 2) {
                leftHalf = remaining;
                rightHalf = 0;
            } else if (indent == 1) {
                leftHalf = remaining / 2;
                rightHalf = remaining - leftHalf;
            } else {
                leftHalf = 0;
                rightHalf = remaining;
            }
            StringBuilder builder = new StringBuilder();
            SpreadSheet.fillSpace(builder, leftHalf);
            builder.append(line);
            SpreadSheet.fillSpace(builder, rightHalf);
            return builder.toString();
        }

        public String toString() {
            return this.getBorderLeft() + this.getItemString() + this.getBorderRight();
        }
    }

    public static class Row
    implements Iterable<Cell> {
        private final List<Cell> cellList = new ArrayList<Cell>();
        private String mTab = "";

        public void add(Cell cell) {
            this.cellList.add(cell);
        }

        public void add(int i, Cell cell) {
            this.cellList.add(i, cell);
        }

        public String getTab() {
            return this.mTab;
        }

        public void setTab(String tab) {
            if (tab == null) {
                tab = "";
            }
            this.mTab = tab;
        }

        public MergedCells merge(int start, int count) {
            ArrayList<Cell> childList = new ArrayList<Cell>(count);
            for (int i = 0; i < count; ++i) {
                childList.add(this.remove(start));
            }
            MergedCells mergedCells = new MergedCells(childList);
            this.add(start, mergedCells);
            return mergedCells;
        }

        public SeparatorCells asSeparator() {
            Cell first = this.get(0);
            if (first instanceof SeparatorCells) {
                return (SeparatorCells)first;
            }
            int count = this.size();
            ArrayList<Cell> childList = new ArrayList<Cell>(count);
            for (int i = 0; i < count; ++i) {
                childList.add(this.remove(0));
            }
            SeparatorCells separatorCells = new SeparatorCells(childList);
            this.add(separatorCells);
            return separatorCells;
        }

        public Cell get(int i) {
            if (i >= 0 && i < this.cellList.size()) {
                return this.cellList.get(i);
            }
            return null;
        }

        public Cell getLast() {
            return this.get(this.size() - 1);
        }

        private Cell getCell(int index) {
            int size = this.cellList.size();
            for (int i = 0; i < size; ++i) {
                MergedCells mergedCells;
                Cell cell = this.cellList.get(i);
                if (i == index) {
                    if (cell instanceof MergedCells) {
                        return ((MergedCells)cell).get(0);
                    }
                    return cell;
                }
                if (!(cell instanceof MergedCells) || (cell = (mergedCells = (MergedCells)cell).get(index + i)) == null) continue;
                return cell;
            }
            return null;
        }

        public Cell remove(int i) {
            if (i >= 0 && i < this.cellList.size()) {
                return this.cellList.remove(i);
            }
            return null;
        }

        public int size() {
            return this.cellList.size();
        }

        public int getColumnCount() {
            int result = 0;
            for (Cell cell : this) {
                result += cell.getCellCount();
            }
            return result;
        }

        public int getPrintWidth() {
            int result = this.getTab().length();
            for (Cell cell : this) {
                result += cell.getPrintWidth();
            }
            return result;
        }

        public int getMergedCellsWidth() {
            for (Cell cell : this) {
                MergedCells mergedCells;
                Cell first;
                if (!(cell instanceof MergedCells) || (first = (mergedCells = (MergedCells)cell).getFirst()) == null) continue;
                return first.itemWidth();
            }
            return 0;
        }

        public int getColumnPrintWidth(int columnIndex) {
            Cell cell = this.getCell(columnIndex);
            if (cell != null) {
                return cell.getPrintWidth();
            }
            return 0;
        }

        public void ensureSize(int size) {
            int remaining = size - this.getColumnCount();
            if (remaining <= 0) {
                return;
            }
            Cell last = this.getLast();
            if (last instanceof MergedCells) {
                ((MergedCells)last).addEmptyCells(remaining);
            } else {
                for (int i = 0; i < remaining; ++i) {
                    this.add(new Cell(""));
                }
            }
        }

        public int itemWidth(int index) {
            Cell cell = this.get(index);
            return cell == null ? 0 : cell.itemWidth();
        }

        public void setIndent(int columnIndex, int indent) {
            Cell cell = this.get(columnIndex);
            if (cell != null) {
                cell.setHorizontalIndent(indent);
            }
        }

        public void setColumnWidth(int columnIndex, int columnWidth) {
            Cell cell = this.getCell(columnIndex);
            if (cell != null) {
                cell.setColumnWidth(columnWidth);
            }
        }

        public void setBorderLeft(int columnIndex, String border) {
            Cell cell = this.get(columnIndex);
            if (cell != null) {
                cell.setBorderLeft(border);
            }
        }

        public void setBorderRight(int columnIndex, String border) {
            Cell cell = this.get(columnIndex);
            if (cell != null) {
                cell.setBorderRight(border);
            }
        }

        public List<Row> getSplitLines() {
            ArrayList<Row> results = new ArrayList<Row>();
            int splitLinesSize = this.getSplitLinesSize();
            this.setSplitLinesSize(splitLinesSize);
            int column = this.size();
            for (int line = 0; line < splitLinesSize; ++line) {
                Row row = new Row();
                for (int i = 0; i < column; ++i) {
                    Cell parent = this.get(i);
                    row.add(parent.getSplitLine(line));
                }
                results.add(row);
            }
            return results;
        }

        private void setSplitLinesSize(int size) {
            for (Cell cell : this) {
                cell.setSplitLinesSize(size);
            }
        }

        private int getSplitLinesSize() {
            int result = 0;
            for (Cell cell : this) {
                int width = cell.getSplitLinesSize();
                if (width <= result) continue;
                result = width;
            }
            return result;
        }

        @Override
        public Iterator<Cell> iterator() {
            return this.cellList.iterator();
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getTab());
            int size = this.size();
            for (int i = 0; i < size; ++i) {
                builder.append(this.get(i));
            }
            return builder.toString();
        }
    }
}

