/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.jcommand;

import com.reandroid.jcommand.CommandStrings;
import com.reandroid.jcommand.SubCommandParser;
import com.reandroid.jcommand.annotations.CommandOptions;
import com.reandroid.jcommand.annotations.MainCommand;
import com.reandroid.jcommand.annotations.OnOptionSelected;
import com.reandroid.jcommand.annotations.OtherOption;
import com.reandroid.jcommand.exceptions.CommandException;
import com.reandroid.jcommand.utils.ReflectionUtil;
import java.lang.reflect.Method;
import java.util.List;

public class CommandParser {
    private final Class<?> mainCommandClass;

    public CommandParser(Class<?> mainCommandClass) {
        this.mainCommandClass = mainCommandClass;
    }

    public void parse(Object callback, String ... args) {
        String[] subArgs;
        if (args == null || args.length == 0) {
            throw new CommandException(CommandStrings.empty_command_args_exception, new Object[0]);
        }
        String command = args[0];
        Method otherOptionMethod = this.getOtherOptionMethod(command, callback == null);
        if (otherOptionMethod != null) {
            try {
                otherOptionMethod.setAccessible(true);
                otherOptionMethod.invoke(callback, new Object[0]);
                return;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        Class<?> optionClass = this.getOptionClass(command);
        if (optionClass != null) {
            int length = args.length;
            subArgs = new String[length - 1];
            for (int i = 1; i < length; ++i) {
                subArgs[i - 1] = args[i];
            }
        } else {
            throw new CommandException(CommandStrings.unknown_command_exception, command);
        }
        this.parseSubCommand(callback, optionClass, subArgs);
    }

    private void parseSubCommand(Object callback, Class<?> optionClass, String[] args) {
        Object obj = SubCommandParser.parse(optionClass, args);
        boolean empty = args.length == 0;
        Method onOptionSelectedMethod = this.getOnOptionSelectedMethod(callback == null);
        try {
            onOptionSelectedMethod.setAccessible(true);
            onOptionSelectedMethod.invoke(callback, obj, empty);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Class<?> getOptionClass(String command) {
        Class<?>[] classes;
        MainCommand mainCommand = this.mainCommandClass.getAnnotation(MainCommand.class);
        for (Class<?> clazz : classes = mainCommand.options()) {
            String[] names;
            CommandOptions commandOptions = clazz.getAnnotation(CommandOptions.class);
            if (commandOptions.name().equals(command)) {
                return clazz;
            }
            for (String name : names = commandOptions.alternates()) {
                if (!name.equals(command)) continue;
                return clazz;
            }
        }
        return null;
    }

    private Method getOtherOptionMethod(String command, boolean is_static) {
        List<Method> methodList = ReflectionUtil.listMethods(this.mainCommandClass);
        for (Method method : methodList) {
            OtherOption option;
            boolean staticMethod = (method.getModifiers() & 8) == 8;
            if (staticMethod != is_static || (option = method.getAnnotation(OtherOption.class)) == null || !this.contains(command, option.names()) && !this.contains(command, option.alternates())) continue;
            return method;
        }
        return null;
    }

    private Method getOnOptionSelectedMethod(boolean is_static) {
        List<Method> methodList = ReflectionUtil.listMethods(this.mainCommandClass);
        for (Method method : methodList) {
            OnOptionSelected option;
            boolean staticMethod = (method.getModifiers() & 8) == 8;
            if (staticMethod != is_static || (option = method.getAnnotation(OnOptionSelected.class)) == null) continue;
            return method;
        }
        if (is_static) {
            throw new RuntimeException("No static method annotated with OnOptionSelected in class: '" + this.mainCommandClass + "'");
        }
        throw new RuntimeException("No instance method annotated with OnOptionSelected in class: '" + this.mainCommandClass + "'");
    }

    private boolean contains(String command, String[] names) {
        for (String name : names) {
            if (!name.equals(command)) continue;
            return true;
        }
        return false;
    }
}

