/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.jcommand;

import com.reandroid.jcommand.CommandStringResource;
import com.reandroid.jcommand.CommandStrings;
import com.reandroid.jcommand.HelpBuilder;
import com.reandroid.jcommand.annotations.CommandOptions;
import com.reandroid.jcommand.annotations.MainCommand;
import com.reandroid.jcommand.annotations.OtherOption;
import com.reandroid.jcommand.utils.ReflectionUtil;
import com.reandroid.jcommand.utils.SpreadSheet;
import com.reandroid.jcommand.utils.TwoColumnTable;
import java.util.ArrayList;
import java.util.List;

public class CommandHelpBuilder
extends HelpBuilder {
    private final Class<?> mainCommandClass;
    private MainCommand mainCommand;

    public CommandHelpBuilder(CommandStringResource stringResource, Class<?> mainCommandClass) {
        super(stringResource);
        if (mainCommandClass == null) {
            throw new NullPointerException("Null MainCommand");
        }
        this.mainCommandClass = mainCommandClass;
    }

    public CommandHelpBuilder(Class<?> mainCommandClass) {
        this(null, mainCommandClass);
    }

    @Override
    public SpreadSheet buildTable() {
        this.reset();
        this.appendLines(false, this.getMainCommand().headers());
        this.appendUsageLines();
        this.appendCommandOptions();
        this.appendOtherOptions();
        this.appendFooters();
        TwoColumnTable twoColumnTable = this.getTable();
        twoColumnTable.addSeparator();
        return twoColumnTable.buildTable();
    }

    public MainCommand getMainCommand() {
        MainCommand mainCommand = this.mainCommand;
        if (mainCommand == null) {
            mainCommand = this.mainCommandClass.getAnnotation(MainCommand.class);
            if (mainCommand == null) {
                throw new RuntimeException("Class not annotated with MainCommand: '" + this.mainCommandClass + "'");
            }
            this.mainCommand = mainCommand;
        }
        return mainCommand;
    }

    private void appendCommandOptions() {
        List<CommandOptions> commandOptionsList = this.getCommandOptions();
        TwoColumnTable twoColumnTable = this.getTable();
        twoColumnTable.addMergedRow(this.getStringResource().getString(CommandStrings.title_commands));
        for (CommandOptions options : commandOptionsList) {
            this.appendCommandOptions(options);
        }
        twoColumnTable.addSeparator();
    }

    private void appendCommandOptions(CommandOptions options) {
        String[] alternates;
        TwoColumnTable twoColumnTable = this.getTable();
        StringBuilder name = new StringBuilder();
        name.append(options.name());
        for (String alt : alternates = options.alternates()) {
            name.append(" | ");
            name.append(alt);
        }
        twoColumnTable.addRow(name.toString(), this.getStringResource().getString(options.description()));
    }

    private void appendOtherOptions() {
        List<OtherOption> otherOptionList = this.getOtherOptions();
        if (otherOptionList.isEmpty()) {
            return;
        }
        TwoColumnTable twoColumnTable = this.getTable();
        twoColumnTable.addMergedRow(this.getStringResource().getString(CommandStrings.title_other_options));
        for (OtherOption options : otherOptionList) {
            this.appendOtherOption(options);
        }
        twoColumnTable.addSeparator();
    }

    private void appendOtherOption(OtherOption options) {
        TwoColumnTable twoColumnTable = this.getTable();
        StringBuilder nameBuilder = new StringBuilder();
        String[] names = options.names();
        int length = names.length;
        for (int i = 0; i < length; ++i) {
            if (i != 0) {
                nameBuilder.append(" | ");
            }
            nameBuilder.append(names[i]);
        }
        twoColumnTable.addRow(nameBuilder.toString(), this.getStringResource().getString(options.description()));
    }

    private void appendUsageLines() {
        MainCommand mainCommand = this.getMainCommand();
        if (mainCommand == null) {
            return;
        }
        String[] usageLines = mainCommand.usages();
        if (usageLines.length == 0) {
            return;
        }
        CommandStringResource stringResource = this.getStringResource();
        TwoColumnTable twoColumnTable = this.getTable();
        twoColumnTable.addSeparator();
        twoColumnTable.addMergedRow(stringResource.getString(CommandStrings.title_usage));
        for (String line : usageLines) {
            twoColumnTable.addMergedRowTabbed(stringResource.getString(line));
        }
        twoColumnTable.addSeparator();
    }

    public List<CommandOptions> getCommandOptions() {
        Class<?>[] optionClasses;
        ArrayList<CommandOptions> results = new ArrayList<CommandOptions>();
        for (Class<?> clazz : optionClasses = this.getMainCommand().options()) {
            CommandOptions commandOptions = clazz.getAnnotation(CommandOptions.class);
            if (commandOptions == null) {
                throw new IllegalArgumentException("Invalid option class: '" + clazz + "', should annotate CommandOptions");
            }
            results.add(commandOptions);
        }
        return results;
    }

    public List<OtherOption> getOtherOptions() {
        return ReflectionUtil.listOtherOptions(this.mainCommandClass);
    }
}

