/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.identifiers;

import com.reandroid.arsc.coder.xml.XmlCoder;
import com.reandroid.utils.HexUtil;
import java.io.File;

public class Identifier
implements Comparable<Identifier> {
    private int id;
    private String name;
    private Identifier mParent;
    private Object mTag;
    static final String XML_TAG_RESOURCES = "resources";
    static final String XML_TAG_PUBLIC = "public";
    static final String XML_ATTRIBUTE_ID = "id";
    static final String XML_ATTRIBUTE_NAME = "name";
    static final String XML_ATTRIBUTE_PACKAGE = "package";
    static final String XML_ATTRIBUTE_TYPE = "type";
    public static final boolean CASE_INSENSITIVE_FS = new File("ABC").equals(new File("abc"));

    public Identifier(int id, String name) {
        this.id = id;
        this.name = name;
    }

    public Object getTag() {
        return this.mTag;
    }

    public void setTag(Object tag) {
        this.mTag = tag;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    Identifier getParent() {
        return this.mParent;
    }

    void setParent(Identifier parent) {
        if (parent == this) {
            return;
        }
        this.mParent = parent;
    }

    public String getHexId() {
        return HexUtil.toHex2((byte)this.getId());
    }

    long getUniqueId() {
        return this.getId();
    }

    @Override
    public int compareTo(Identifier identifier) {
        return Long.compare(this.getUniqueId(), identifier.getUniqueId());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Identifier other = (Identifier)obj;
        return this.getUniqueId() == other.getUniqueId();
    }

    public int hashCode() {
        return Long.hashCode(this.getUniqueId());
    }

    public String toString() {
        return this.getName() + "(" + this.getHexId() + ")";
    }

    public static boolean isAapt() {
        return XmlCoder.getInstance().getSetting().isAapt();
    }
}

