/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.graph.cleaners;

import com.reandroid.apk.ApkModule;
import com.reandroid.dex.key.TypeKey;
import com.reandroid.dex.model.DexClass;
import com.reandroid.dex.model.DexClassRepository;
import com.reandroid.graph.ApkBuildOption;
import com.reandroid.graph.RequiredClassesScanner;
import com.reandroid.graph.VitalClassesSet;
import com.reandroid.graph.cleaners.UnusedCleaner;
import java.util.Iterator;
import java.util.Set;

public class UnusedClassesCleaner
extends UnusedCleaner<DexClass> {
    private VitalClassesSet vitalClassesSet;
    private static final int MAXIMUM_CYCLE = 25;

    public UnusedClassesCleaner(ApkBuildOption buildOption, ApkModule apkModule, DexClassRepository classRepository) {
        super(buildOption, apkModule, classRepository);
    }

    @Override
    public void apply() {
        if (!this.isEnabled()) {
            this.debug("Skip");
            return;
        }
        this.getVitalClassesSet().setReporter(this.getReporter()).apply();
        this.cleanCyclic();
    }

    public VitalClassesSet getVitalClassesSet() {
        VitalClassesSet vitalClassesSet = this.vitalClassesSet;
        if (vitalClassesSet == null) {
            this.vitalClassesSet = vitalClassesSet = new VitalClassesSet(this.getBuildOption(), this.getApkModule(), this.getClassRepository());
        }
        return vitalClassesSet;
    }

    public void setVitalClassesSet(VitalClassesSet vitalClassesSet) {
        this.vitalClassesSet = vitalClassesSet;
    }

    private void cleanCyclic() {
        int cycle = 0;
        int totalRemoved = 0;
        int removedCount = 1;
        while (cycle < 25 && removedCount > 0) {
            Set<TypeKey> requiredClasses = this.scanRequiredClasses();
            this.debugReportClassesToRemove(requiredClasses);
            removedCount = this.cleanUnusedClasses(requiredClasses);
            this.verbose("Cycle: " + ++cycle + ", removed: " + removedCount + ", total: " + (totalRemoved += removedCount));
        }
        this.setCount(totalRemoved);
    }

    private int cleanUnusedClasses(Set<TypeKey> requiredClasses) {
        DexClassRepository repository = this.getClassRepository();
        int previousCount = repository.getDexClassesCount();
        repository.removeClassesWithKeys(typeKey -> !requiredClasses.contains(typeKey));
        int removed = previousCount - repository.getDexClassesCount();
        this.setCount(removed);
        if (removed != 0) {
            repository.shrink();
        }
        return removed;
    }

    private void debugReportClassesToRemove(Set<TypeKey> requiredClasses) {
        if (!this.isDebugEnabled()) {
            return;
        }
        DexClassRepository repository = this.getClassRepository();
        Iterator<DexClass> iterator = repository.getDexClasses((? super TypeKey typeKey) -> !requiredClasses.contains(typeKey));
        while (iterator.hasNext()) {
            this.debug(iterator.next().getKey().toString());
        }
    }

    private Set<TypeKey> scanRequiredClasses() {
        RequiredClassesScanner scanner = new RequiredClassesScanner(this.vitalClassesSet, this.getApkModule(), this.getClassRepository());
        scanner.setReporter(this.getReporter());
        scanner.setLookInStrings(this.getBuildOption().isProcessClassNamesOnStrings());
        scanner.apply();
        return scanner.getResults();
    }

    @Override
    protected boolean isEnabled() {
        return this.getBuildOption().isMinifyClasses();
    }
}

