/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.value;

import com.reandroid.dex.base.DexBlockItem;
import com.reandroid.utils.HexUtil;

public class NumberValue
extends DexBlockItem {
    public NumberValue() {
        super(1);
    }

    public int getSize() {
        return this.countBytes();
    }

    public void setSize(int size) {
        this.setBytesLength(size, false);
    }

    public long getSignedNumber() {
        return NumberValue.getSignedNumber(this.getBytesInternal(), 0, this.getSize());
    }

    public long getUnsignedNumber() {
        return NumberValue.getUnsignedNumber(this.getBytesInternal(), 0, this.getSize());
    }

    public void setNumberValue(byte value) {
        this.setSize(1);
        this.getBytesInternal()[0] = value;
    }

    public void setNumberValue(short value) {
        this.setSignedNumberValue((long)value & 0xFFFFL, value < 0);
    }

    public void setNumberValue(int value) {
        this.setSignedNumberValue((long)value & 0xFFFFFFFFL, value < 0);
    }

    public void setNumberValue(long value) {
        this.setSignedNumberValue(value, value < 0L);
    }

    public void setUnsignedNumber(long value) {
        int size = NumberValue.calculateUnsignedSize(value);
        this.setSize(size);
        NumberValue.putNumber(this.getBytesInternal(), 0, size, value);
    }

    public void setNumber(long value, int size) {
        this.setSize(size);
        NumberValue.putNumber(this.getBytesInternal(), 0, size, value);
    }

    private void setSignedNumberValue(long value, boolean negative) {
        int size = NumberValue.calculateSignedSize(value, negative);
        this.setSize(size);
        NumberValue.putNumber(this.getBytesInternal(), 0, size, value);
    }

    public String toHex() {
        return HexUtil.toHex(this.getUnsignedNumber(), this.getSize());
    }

    public void merge(NumberValue value) {
        byte[] coming = value.getBytes();
        int length = coming.length;
        this.setBytesLength(length, false);
        byte[] bytes = this.getBytesInternal();
        for (int i = 0; i < length; ++i) {
            bytes[i] = coming[i];
        }
    }

    public int hashCode() {
        return Long.hashCode(this.getUnsignedNumber());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        return this.getUnsignedNumber() == ((NumberValue)obj).getUnsignedNumber();
    }

    public String toString() {
        return this.getSize() + ":" + this.toHex();
    }

    private static int calculateSignedSize(long l, boolean negative) {
        if (l == 0L) {
            return 1;
        }
        int size = 0;
        int sign = 0;
        long value = l;
        while (value != 0L) {
            sign = (int)value;
            value >>>= 8;
            ++size;
        }
        if (!negative && sign >= 128) {
            ++size;
        } else if (negative) {
            byte[] bytes = new byte[size];
            NumberValue.putNumber(bytes, 0, size, l);
            for (int j = size - 1; j > 0; --j) {
                int high = bytes[j] & 0xFF;
                int next = bytes[j - 1] & 0xFF;
                if (high != 255 || next <= 128) break;
                --size;
            }
        }
        return size;
    }

    private static int calculateUnsignedSize(long value) {
        if (value == 0L) {
            return 1;
        }
        int i = 0;
        while (value != 0L) {
            value >>>= 8;
            ++i;
        }
        return i;
    }
}

