/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.smali.model;

import com.reandroid.dex.key.ArrayValueKey;
import com.reandroid.dex.key.Key;
import com.reandroid.dex.smali.SmaliParseException;
import com.reandroid.dex.smali.SmaliReader;
import com.reandroid.dex.smali.SmaliWriter;
import com.reandroid.dex.smali.model.SmaliSet;
import com.reandroid.dex.smali.model.SmaliValue;
import com.reandroid.dex.smali.model.SmaliValueFactory;
import com.reandroid.dex.value.DexValueType;
import java.io.IOException;
import java.util.Iterator;

public class SmaliValueArray
extends SmaliValue
implements Iterable<SmaliValue> {
    private final SmaliSet<SmaliValue> values = new SmaliSet();

    public SmaliValueArray() {
        this.values.setParent(this);
    }

    @Override
    public ArrayValueKey getKey() {
        int size = this.size();
        Key[] elements = new Key[size];
        for (int i = 0; i < size; ++i) {
            elements[i] = this.get(i).getKey();
        }
        return ArrayValueKey.of(elements);
    }

    @Override
    public void setKey(Key key) {
        ArrayValueKey arrayKey = (ArrayValueKey)key;
        this.clear();
        for (Key entry : arrayKey) {
            this.addValue(entry);
        }
    }

    public SmaliSet<SmaliValue> getValues() {
        return this.values;
    }

    public boolean contains(SmaliValue value) {
        return this.values.contains(value);
    }

    public SmaliValue remove(int i) {
        return this.values.remove(i);
    }

    public boolean remove(SmaliValue value) {
        return this.values.remove(value);
    }

    public void clear() {
        this.values.clear();
    }

    public void addValue(Key value) {
        SmaliValue smaliValue = SmaliValueFactory.createForValue(value);
        this.add(smaliValue);
        smaliValue.setKey(value);
    }

    public boolean add(SmaliValue value) {
        return this.values.add(value);
    }

    public SmaliValue get(int i) {
        return this.values.get(i);
    }

    public int size() {
        return this.values.size();
    }

    public boolean isEmpty() {
        return this.values.isEmpty();
    }

    @Override
    public Iterator<SmaliValue> iterator() {
        return this.values.iterator();
    }

    @Override
    public DexValueType<?> getValueType() {
        return DexValueType.ARRAY;
    }

    @Override
    public void append(SmaliWriter writer) throws IOException {
        writer.append('{');
        Iterator<SmaliValue> iterator = this.iterator();
        boolean appendOnce = false;
        while (iterator.hasNext()) {
            SmaliValue value = iterator.next();
            if (appendOnce) {
                writer.append(',');
            } else {
                writer.indentPlus();
            }
            writer.newLine();
            value.append(writer);
            appendOnce = true;
        }
        if (appendOnce) {
            writer.indentMinus();
            writer.newLine();
        }
        writer.append('}');
    }

    @Override
    public void parse(SmaliReader reader) throws IOException {
        SmaliValue value;
        reader.skipWhitespaces();
        SmaliParseException.expect(reader, '{');
        reader.skipWhitespaces();
        while ((value = this.createNext(reader)) != null) {
            this.add(value);
            value.parse(reader);
            reader.skipWhitespacesOrComment();
            if (reader.get() != 44) continue;
            reader.skip(1);
        }
        reader.skipWhitespaces();
        SmaliParseException.expect(reader, '}');
    }

    private SmaliValue createNext(SmaliReader reader) throws IOException {
        reader.skipWhitespacesOrComment();
        byte b = reader.get();
        if (b == 125) {
            return null;
        }
        return SmaliValueFactory.create(reader);
    }
}

