/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.smali.model;

import com.reandroid.dex.smali.SmaliReader;
import com.reandroid.dex.smali.SmaliWriter;
import com.reandroid.dex.smali.model.Smali;
import com.reandroid.utils.collection.ArrayCollection;
import com.reandroid.utils.collection.InstanceIterator;
import java.io.IOException;
import java.util.Iterator;
import java.util.function.Predicate;

public class SmaliSet<T extends Smali>
extends Smali {
    private final ArrayCollection<T> body = new ArrayCollection();

    public SmaliSet() {
        this.body.setMonitor(new SmaliSetMonitor(this));
    }

    public Iterator<T> iterator() {
        return this.body.iterator();
    }

    public Iterator<T> iterator(int start) {
        return this.body.iterator(start);
    }

    public <T2> Iterator<T2> iterator(Class<T2> instance) {
        return this.body.iterator(instance);
    }

    public <T2> Iterator<T2> iterator(int start, Class<T2> instance) {
        return InstanceIterator.of(this.body.iterator(start), instance);
    }

    public Iterator<T> reversedIterator() {
        return this.body.reversedIterator();
    }

    public Iterator<T> reversedIterator(int start) {
        return this.body.reversedIterator(start);
    }

    public <T2> Iterator<T2> reversedIterator(Class<T2> instance) {
        return InstanceIterator.of(this.body.reversedIterator(), instance);
    }

    public <T2> Iterator<T2> reversedIterator(int start, Class<T2> instance) {
        return InstanceIterator.of(this.body.reversedIterator(start), instance);
    }

    public int size() {
        return this.body.size();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public int indexOf(T smali) {
        return this.body.indexOf(smali);
    }

    public T get(int i) {
        return (T)((Smali)this.body.get(i));
    }

    public boolean add(T smali) {
        return this.body.add(smali);
    }

    public void add(int i, T smali) {
        this.body.add(i, smali);
    }

    public void addAll(Iterator<? extends T> iterator) {
        while (iterator.hasNext()) {
            this.add((Smali)iterator.next());
        }
    }

    public boolean contains(T smali) {
        return this.body.contains(smali);
    }

    public boolean remove(T smali) {
        return this.body.remove(smali);
    }

    public T remove(int i) {
        return (T)((Smali)this.body.remove(i));
    }

    public boolean removeIf(Predicate<? super T> filter) {
        return this.body.removeIf(filter);
    }

    public boolean removeInstances(Class<?> instance) {
        return this.body.removeIf(instance::isInstance);
    }

    public void clear() {
        for (Smali smali : this.body) {
            smali.setParent(null);
        }
        this.body.clear();
    }

    void onRemoved(T item) {
        if (item != null) {
            ((Smali)item).setParent(null);
        }
    }

    void onAdded(T item) {
        if (item != null) {
            ((Smali)item).setParent(this);
        }
    }

    @Override
    public void append(SmaliWriter writer) throws IOException {
        writer.appendAllWithDoubleNewLine(this.iterator());
    }

    @Override
    public void parse(SmaliReader reader) throws IOException {
        while (this.parseNext(reader) != null) {
            reader.skipWhitespacesOrComment();
        }
    }

    public T parseNext(SmaliReader reader) throws IOException {
        if (reader.finished()) {
            return null;
        }
        T item = this.createNext(reader);
        if (item != null) {
            this.add(item);
            item.parse(reader);
        }
        return item;
    }

    T createNext(SmaliReader reader) {
        throw new RuntimeException("Method not implemented");
    }

    static class SmaliSetMonitor<T extends Smali>
    implements ArrayCollection.Monitor<T> {
        private final SmaliSet<T> smaliSet;

        SmaliSetMonitor(SmaliSet<T> smaliSet) {
            this.smaliSet = smaliSet;
        }

        @Override
        public void onAdd(int i, T item) {
            this.smaliSet.onAdded(item);
        }

        @Override
        public void onRemoved(int i, T item) {
            this.smaliSet.onRemoved(item);
        }
    }
}

