/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.smali.model;

import com.reandroid.dex.ins.InsSparseSwitch;
import com.reandroid.dex.ins.InsSparseSwitchData;
import com.reandroid.dex.ins.Opcode;
import com.reandroid.dex.smali.SmaliDirective;
import com.reandroid.dex.smali.model.SmaliInstructionOperand;
import com.reandroid.dex.smali.model.SmaliSparseSwitchEntry;
import com.reandroid.dex.smali.model.SmaliSwitchPayload;

public class SmaliPayloadSparseSwitch
extends SmaliSwitchPayload<SmaliSparseSwitchEntry> {
    public SmaliPayloadSparseSwitch() {
        super(SmaliInstructionOperand.NO_OPERAND);
    }

    @Override
    public Opcode<InsSparseSwitch> getSwitchOpcode() {
        return Opcode.SPARSE_SWITCH;
    }

    @Override
    public int getCodeUnits() {
        int count = this.getCount();
        int size = 4 + 8 * count;
        return size / 2;
    }

    @Override
    public SmaliDirective getSmaliDirective() {
        return SmaliDirective.SPARSE_SWITCH;
    }

    @Override
    public Opcode<InsSparseSwitchData> getOpcode() {
        return Opcode.SPARSE_SWITCH_PAYLOAD;
    }

    @Override
    SmaliSparseSwitchEntry createEntry() {
        return new SmaliSparseSwitchEntry();
    }
}

