/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.smali.model;

import com.reandroid.dex.ins.InsPackedSwitch;
import com.reandroid.dex.ins.InsPackedSwitchData;
import com.reandroid.dex.ins.Opcode;
import com.reandroid.dex.smali.SmaliDirective;
import com.reandroid.dex.smali.SmaliRegion;
import com.reandroid.dex.smali.model.SmaliInstructionOperand;
import com.reandroid.dex.smali.model.SmaliPackedSwitchEntry;
import com.reandroid.dex.smali.model.SmaliSwitchPayload;

public class SmaliPayloadPackedSwitch
extends SmaliSwitchPayload<SmaliPackedSwitchEntry>
implements SmaliRegion {
    public SmaliPayloadPackedSwitch() {
        super(new SmaliInstructionOperand.SmaliHexOperand());
    }

    public int getFirstKey() {
        return (int)this.getOperand().getValueAsLong();
    }

    public void setFirstKey(int firstKey) {
        this.getOperand().setNumber(firstKey);
    }

    @Override
    public Opcode<InsPackedSwitch> getSwitchOpcode() {
        return Opcode.PACKED_SWITCH;
    }

    @Override
    public int getCodeUnits() {
        int count = this.getEntries().size();
        int size = 8 + 4 * count;
        return size / 2;
    }

    @Override
    public SmaliInstructionOperand.SmaliHexOperand getOperand() {
        return (SmaliInstructionOperand.SmaliHexOperand)super.getOperand();
    }

    @Override
    public Opcode<InsPackedSwitchData> getOpcode() {
        return Opcode.PACKED_SWITCH_PAYLOAD;
    }

    @Override
    SmaliPackedSwitchEntry createEntry() {
        return new SmaliPackedSwitchEntry();
    }

    @Override
    public SmaliDirective getSmaliDirective() {
        return SmaliDirective.PACKED_SWITCH;
    }
}

