/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.smali.model;

import com.reandroid.dex.common.AccessFlag;
import com.reandroid.dex.common.HiddenApiFlag;
import com.reandroid.dex.common.Modifier;
import com.reandroid.dex.key.FieldKey;
import com.reandroid.dex.key.Key;
import com.reandroid.dex.key.StringKey;
import com.reandroid.dex.key.TypeKey;
import com.reandroid.dex.program.FieldProgram;
import com.reandroid.dex.smali.SmaliDirective;
import com.reandroid.dex.smali.SmaliParseException;
import com.reandroid.dex.smali.SmaliReader;
import com.reandroid.dex.smali.SmaliWriter;
import com.reandroid.dex.smali.model.SmaliAnnotationSet;
import com.reandroid.dex.smali.model.SmaliClass;
import com.reandroid.dex.smali.model.SmaliDef;
import com.reandroid.dex.smali.model.SmaliInstruction;
import com.reandroid.dex.smali.model.SmaliMethod;
import com.reandroid.dex.smali.model.SmaliValue;
import com.reandroid.dex.smali.model.SmaliValueFactory;
import java.io.IOException;
import java.util.Iterator;

public class SmaliField
extends SmaliDef
implements FieldProgram {
    private TypeKey type;
    private SmaliValue value;

    @Override
    public FieldKey getKey() {
        TypeKey defining = this.getDefining();
        if (defining != null) {
            return this.getKey(defining);
        }
        return null;
    }

    public void setKey(Key key) {
        FieldKey fieldKey = (FieldKey)key;
        this.setName(fieldKey.getNameKey());
        this.setType(fieldKey.getType());
        this.setDefining(fieldKey.getDeclaring());
    }

    public FieldKey getKey(TypeKey declaring) {
        return FieldKey.create(declaring, this.getName(), this.getType());
    }

    public TypeKey getType() {
        return this.type;
    }

    public void setType(TypeKey type) {
        this.type = type;
    }

    @Override
    public Key getStaticValue() {
        SmaliValue value = this.getValue();
        if (value != null) {
            return value.getKey();
        }
        return null;
    }

    public void setStaticValue(Key key) {
        this.setStaticValue(SmaliValueFactory.createForValue(key));
    }

    public SmaliValue getValue() {
        return this.value;
    }

    public void setStaticValue(SmaliValue value) {
        SmaliValue oldValue = this.value;
        this.value = value;
        if (value != null) {
            value.setParent(this);
        }
        if (oldValue != null && oldValue != value) {
            oldValue.setParent(null);
        }
    }

    void fixUninitializedFinalValue() {
        if (this.getValue() != null || !this.isStatic() || !this.isFinal()) {
            return;
        }
        SmaliClass smaliClass = this.getSmaliClass();
        FieldKey fieldKey = this.getKey();
        if (smaliClass == null || fieldKey == null) {
            return;
        }
        if (!this.isInitializedInStaticConstructor(smaliClass, fieldKey)) {
            this.setStaticValue(SmaliValueFactory.createForField(fieldKey.getType()));
        }
    }

    private boolean isInitializedInStaticConstructor(SmaliClass smaliClass, FieldKey fieldKey) {
        SmaliMethod method = smaliClass.getStaticConstructor();
        if (method == null) {
            return false;
        }
        Iterator<SmaliInstruction> iterator = method.getInstructions();
        while (iterator.hasNext()) {
            SmaliInstruction instruction = iterator.next();
            if (!fieldKey.equals(instruction.getKey())) continue;
            return instruction.getOpcode().isFieldStaticPut();
        }
        return false;
    }

    @Override
    public SmaliDirective getSmaliDirective() {
        return SmaliDirective.FIELD;
    }

    @Override
    public void append(SmaliWriter writer) throws IOException {
        SmaliAnnotationSet annotationSet;
        this.getSmaliDirective().append(writer);
        Modifier.append(writer, this.getModifiers());
        writer.append(this.getName());
        writer.append(':');
        this.getType().append(writer);
        SmaliValue value = this.getValue();
        if (value != null) {
            writer.append(" = ");
            value.append(writer);
        }
        if ((annotationSet = this.getAnnotationSet()) != null && !annotationSet.isEmpty()) {
            writer.indentPlus();
            writer.newLine();
            annotationSet.append(writer);
            writer.indentMinus();
            this.getSmaliDirective().appendEnd(writer);
        }
    }

    @Override
    public void parse(SmaliReader reader) throws IOException {
        SmaliParseException.expect(reader, this.getSmaliDirective());
        this.setAccessFlags(AccessFlag.parse(reader));
        this.setHiddenApiFlags(HiddenApiFlag.parse(reader));
        this.setName(StringKey.readSimpleName(reader, ':'));
        reader.skip(1);
        this.setType(TypeKey.read(reader));
        this.parseValue(reader);
        this.parseAnnotationSet(reader);
    }

    private void parseValue(SmaliReader reader) throws IOException {
        reader.skipWhitespaces();
        if (reader.finished()) {
            return;
        }
        if (reader.get() != 61) {
            return;
        }
        reader.skip(1);
        reader.skipWhitespaces();
        SmaliValue value = SmaliValueFactory.create(reader);
        this.setStaticValue(value);
        value.parse(reader);
    }

    private void parseAnnotationSet(SmaliReader reader) throws IOException {
        reader.skipWhitespacesOrComment();
        SmaliDirective directive = SmaliDirective.parse(reader, false);
        if (directive != SmaliDirective.ANNOTATION) {
            this.getSmaliDirective().skipEnd(reader);
            return;
        }
        int position = reader.position();
        SmaliAnnotationSet annotationSet = new SmaliAnnotationSet();
        annotationSet.parse(reader);
        reader.skipWhitespacesOrComment();
        if (this.getSmaliDirective().isEnd(reader)) {
            this.setSmaliAnnotationSet(annotationSet);
            SmaliDirective.parse(reader);
        } else {
            reader.position(position);
        }
    }

    @Override
    public String toDebugString() {
        StringBuilder builder = new StringBuilder();
        TypeKey typeKey = this.getDefining();
        if (typeKey != null) {
            builder.append(typeKey);
            builder.append(", ");
        }
        builder.append("field = ");
        builder.append(this.getName());
        builder.append(':');
        builder.append(this.getType());
        SmaliValue value = this.getValue();
        if (value != null) {
            builder.append(" = ");
            builder.append(value.toDebugString());
        }
        return builder.toString();
    }
}

