/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.smali.model;

import com.reandroid.dex.smali.SmaliDirective;
import com.reandroid.dex.smali.SmaliReader;
import com.reandroid.dex.smali.SmaliWriter;
import com.reandroid.dex.smali.model.SmaliCode;
import com.reandroid.dex.smali.model.SmaliCodeCatch;
import com.reandroid.dex.smali.model.SmaliCodeCatchAll;
import com.reandroid.dex.smali.model.SmaliCodeExceptionHandler;
import com.reandroid.dex.smali.model.SmaliCodeSet;
import com.reandroid.dex.smali.model.SmaliInstruction;
import com.reandroid.dex.smali.model.SmaliLabel;
import com.reandroid.dex.smali.model.SmaliSet;
import com.reandroid.utils.collection.CollectionUtil;
import com.reandroid.utils.collection.InstanceIterator;
import java.io.IOException;
import java.util.Iterator;

public class SmaliCodeTryItem
extends SmaliCode {
    private final SmaliSet<SmaliCodeCatch> catchSet = new SmaliSet();
    private SmaliCodeCatchAll catchAll;

    public SmaliCodeTryItem() {
        this.catchSet.setParent(this);
    }

    public int getStartAddress() {
        SmaliLabel label = this.pickStartLabel();
        if (label != null) {
            return label.getAddress();
        }
        return -1;
    }

    public int getAddress() {
        SmaliCodeSet codeSet = this.getCodeSet();
        if (codeSet == null) {
            return -1;
        }
        Iterator iterator = codeSet.iterator(codeSet.indexOf(this) + 1);
        SmaliInstruction next = CollectionUtil.getFirst(InstanceIterator.of(iterator, SmaliInstruction.class));
        if (next != null) {
            return next.getAddress();
        }
        return -1;
    }

    public SmaliCodeCatchAll getCatchAll() {
        return this.catchAll;
    }

    public void setCatchAll(SmaliCodeCatchAll catchAll) {
        this.catchAll = catchAll;
        if (catchAll != null) {
            catchAll.setParent(this);
        }
    }

    public SmaliSet<SmaliCodeCatch> getCatchSet() {
        return this.catchSet;
    }

    private SmaliLabel pickStartLabel() {
        Iterator<SmaliCodeCatch> iterator = this.getCatchSet().iterator();
        if (iterator.hasNext()) {
            return iterator.next().getStart();
        }
        SmaliCodeCatchAll catchAll = this.getCatchAll();
        if (catchAll != null) {
            return catchAll.getStart();
        }
        return null;
    }

    @Override
    public void append(SmaliWriter writer) throws IOException {
        writer.appendAll(this.getCatchSet().iterator());
        SmaliCodeCatchAll catchAll = this.getCatchAll();
        if (catchAll != null) {
            writer.newLine();
            catchAll.append(writer);
        }
    }

    @Override
    public void parse(SmaliReader reader) throws IOException {
        this.parseCatches(reader);
        this.parseCatchAll(reader);
    }

    private void parseCatches(SmaliReader reader) throws IOException {
        reader.skipWhitespacesOrComment();
        SmaliSet<SmaliCodeCatch> catchSet = this.getCatchSet();
        SmaliDirective directive = SmaliDirective.parse(reader, false);
        while (directive == SmaliDirective.CATCH) {
            int position = reader.position();
            SmaliCodeCatch codeCatch = new SmaliCodeCatch();
            codeCatch.parse(reader);
            if (this.isDifferentGroup(codeCatch)) {
                reader.position(position);
                break;
            }
            catchSet.add(codeCatch);
            reader.skipWhitespacesOrComment();
            directive = SmaliDirective.parse(reader, false);
        }
    }

    private void parseCatchAll(SmaliReader reader) throws IOException {
        reader.skipWhitespacesOrComment();
        SmaliDirective directive = SmaliDirective.parse(reader, false);
        if (directive == SmaliDirective.CATCH_ALL) {
            SmaliCodeCatchAll catchAll = new SmaliCodeCatchAll();
            int position = reader.position();
            catchAll.parse(reader);
            if (this.isDifferentGroup(catchAll)) {
                reader.position(position);
            } else {
                this.setCatchAll(catchAll);
            }
        }
    }

    private boolean isDifferentGroup(SmaliCodeExceptionHandler exceptionHandler) {
        SmaliLabel smaliLabel = this.pickStartLabel();
        return smaliLabel != null && !smaliLabel.equals(exceptionHandler.getStart());
    }
}

