/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.smali.fix;

import com.reandroid.dex.ins.InsGoto;
import com.reandroid.dex.ins.Opcode;
import com.reandroid.dex.smali.model.SmaliInstruction;
import com.reandroid.dex.smali.model.SmaliMethod;
import com.reandroid.utils.collection.CollectionUtil;
import com.reandroid.utils.collection.FilterIterator;
import java.util.List;

public class SmaliGotoFix {
    private final SmaliMethod smaliMethod;

    public SmaliGotoFix(SmaliMethod smaliMethod) {
        this.smaliMethod = smaliMethod;
    }

    public void apply() {
        List<SmaliInstruction> gotoList = CollectionUtil.toList(FilterIterator.of(this.smaliMethod.getInstructions(), instruction -> {
            Opcode<?> opcode = instruction.getOpcode();
            return opcode == Opcode.GOTO || opcode == Opcode.GOTO_16;
        }));
        if (gotoList.isEmpty()) {
            return;
        }
        boolean changed = false;
        for (SmaliInstruction instruction2 : gotoList) {
            if (!this.fix(instruction2)) continue;
            changed = true;
        }
        if (changed) {
            this.smaliMethod.getCodeSet().updateAddresses();
        }
    }

    private boolean fix(SmaliInstruction instruction) {
        Opcode<?> opcode = this.getReplacement(instruction);
        if (opcode != null) {
            instruction.replaceOpcode(opcode);
            return true;
        }
        return false;
    }

    private Opcode<?> getReplacement(SmaliInstruction instruction) {
        long data = instruction.getDataAsLong();
        Opcode<InsGoto> replacement = null;
        if (data < -128L || data > 127L) {
            replacement = Opcode.GOTO_16;
            if (data < -32768L || data > 32767L) {
                replacement = Opcode.GOTO_32;
            }
        }
        return replacement;
    }
}

