/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.sections;

import com.reandroid.dex.base.UsageMarker;
import com.reandroid.dex.id.StringId;
import com.reandroid.dex.model.DexLayout;
import com.reandroid.dex.sections.Section;
import com.reandroid.dex.sections.SectionType;
import com.reandroid.json.JSONArray;
import com.reandroid.json.JSONObject;
import com.reandroid.utils.CompareUtil;
import com.reandroid.utils.StringsUtil;
import com.reandroid.utils.collection.ComputeIterator;
import com.reandroid.utils.collection.EmptyIterator;
import java.util.Iterator;

public class Marker {
    public static final String VERSION = "version";
    public static final String MIN_API = "min-api";
    public static final String DESUGARED_LIBRARY_IDENTIFIERS = "desugared-library-identifiers";
    public static final String SHA1 = "sha-1";
    public static final String COMPILATION_MODE = "compilation-mode";
    public static final String HAS_CHECKSUMS = "has-checksums";
    public static final String BACKEND = "backend";
    public static final String PG_MAP_ID = "pg-map-id";
    public static final String R8_MODE = "r8-mode";
    private static final String ANDROID_PLATFORM_BUILD = "platform";
    private static final char PREFIX_CHAR = '~';
    private static final String PREFIX = "~~";
    private static final String D8_PREFIX = "~~" + (Object)((Object)Tool.D8) + "{";
    private static final String R8_PREFIX = "~~" + (Object)((Object)Tool.R8) + "{";
    private static final String L8_PREFIX = "~~" + (Object)((Object)Tool.L8) + "{";
    private JSONObject jsonObject;
    private Tool tool;
    private StringId stringId;
    public static final String R8_TEMPLATE = "~~R8{\"backend\":\"dex\",\"compilation-mode\":\"release\",\"has-checksums\":false,\"r8-mode\":\"compatibility\",\"version\":\"3.2.74\"}";
    public static final String D8_TEMPLATE = "~~D8{\"backend\":\"dex\",\"compilation-mode\":\"release\",\"has-checksums\":false,\"min-api\":24,\"version\":\"4.0.48\"}";

    public Marker(Tool tool) {
        this(tool, new JSONObject());
    }

    public Marker(Tool tool, JSONObject jsonObject) {
        this.tool = tool;
        this.jsonObject = jsonObject;
    }

    public JSONObject getJsonObject() {
        return this.jsonObject;
    }

    public void setJsonObject(JSONObject jsonObject) {
        this.jsonObject = jsonObject;
    }

    public void setTool(Tool tool) {
        this.tool = tool;
    }

    public StringId getStringId() {
        return this.stringId;
    }

    public void setStringId(StringId stringId) {
        this.stringId = stringId;
        if (stringId != null) {
            stringId.addUsageType(UsageMarker.USAGE_MARKER);
        }
    }

    public void removeSelf() {
        StringId stringId = this.getStringId();
        if (stringId != null) {
            this.setStringId(null);
            stringId.removeSelf();
        }
    }

    public void save() {
        StringId stringData = this.getStringId();
        if (stringData != null) {
            stringData.setString(this.buildString());
        }
    }

    public Tool getTool() {
        return this.tool;
    }

    public boolean isD8() {
        return this.tool == Tool.D8;
    }

    public boolean isR8() {
        return this.tool == Tool.R8;
    }

    public boolean isL8() {
        return this.tool == Tool.L8;
    }

    public boolean isRelocator() {
        return this.tool == Tool.Relocator;
    }

    public String getVersion() {
        return this.jsonObject.optString(VERSION, null);
    }

    public Marker setVersion(String version) {
        this.jsonObject.put(VERSION, version);
        return this;
    }

    public boolean isDesugared() {
        return this.hasMinApi();
    }

    public boolean hasMinApi() {
        return this.jsonObject.has(MIN_API);
    }

    public Long getMinApi() {
        return this.jsonObject.getLong(MIN_API);
    }

    public Marker setMinApi(Long minApi) {
        this.jsonObject.put(MIN_API, minApi);
        return this;
    }

    public boolean hasDesugaredLibraryIdentifiers() {
        return this.jsonObject.has(DESUGARED_LIBRARY_IDENTIFIERS);
    }

    public String[] getDesugaredLibraryIdentifiers() {
        if (this.jsonObject.has(DESUGARED_LIBRARY_IDENTIFIERS)) {
            JSONArray array = this.jsonObject.getJSONArray(DESUGARED_LIBRARY_IDENTIFIERS);
            String[] identifiers = new String[array.length()];
            for (int i = 0; i < array.length(); ++i) {
                identifiers[i] = array.getString(i);
            }
            return identifiers;
        }
        return new String[0];
    }

    public Marker setDesugaredLibraryIdentifiers(String[] identifiers) {
        if (identifiers == null || identifiers.length == 0) {
            this.jsonObject.remove(DESUGARED_LIBRARY_IDENTIFIERS);
            return this;
        }
        JSONArray jsonIdentifiers = new JSONArray();
        for (String identifier : identifiers) {
            jsonIdentifiers.put(identifier);
        }
        this.jsonObject.put(DESUGARED_LIBRARY_IDENTIFIERS, jsonIdentifiers);
        return this;
    }

    public String getSha1() {
        return this.jsonObject.optString(SHA1, null);
    }

    public Marker setSha1(String sha1) {
        this.jsonObject.put(SHA1, sha1);
        return this;
    }

    public String getCompilationMode() {
        return this.jsonObject.optString(COMPILATION_MODE, null);
    }

    public Marker setCompilationMode(String mode) {
        this.jsonObject.put(COMPILATION_MODE, mode);
        return this;
    }

    public boolean hasBackend() {
        return this.jsonObject.has(BACKEND);
    }

    public String getBackend() {
        if (!this.hasBackend()) {
            return this.hasMinApi() ? StringsUtil.toLowercase(Backend.DEX.name()) : StringsUtil.toLowercase(Backend.CF.name());
        }
        return this.jsonObject.getString(BACKEND);
    }

    public boolean isCfBackend() {
        return this.getBackend().equals(StringsUtil.toLowercase(Backend.CF.name()));
    }

    public boolean isDexBackend() {
        return this.getBackend().equals(StringsUtil.toLowercase(Backend.DEX.name()));
    }

    public Marker setBackend(Backend backend) {
        if (backend == null) {
            this.jsonObject.remove(BACKEND);
        } else {
            this.jsonObject.put(BACKEND, StringsUtil.toLowercase(backend.name()));
        }
        return this;
    }

    public Boolean getHasChecksums() {
        if (this.jsonObject.has(HAS_CHECKSUMS)) {
            return this.jsonObject.getBoolean(HAS_CHECKSUMS);
        }
        return null;
    }

    public Marker setHasChecksums(Boolean hasChecksums) {
        this.jsonObject.put(HAS_CHECKSUMS, hasChecksums);
        return this;
    }

    public String getPgMapId() {
        return this.jsonObject.optString(PG_MAP_ID, null);
    }

    public Marker setPgMapId(String pgMapId) {
        this.jsonObject.put(PG_MAP_ID, pgMapId);
        return this;
    }

    public String getR8Mode() {
        return this.jsonObject.getString(R8_MODE);
    }

    public Marker setR8Mode(String r8Mode) {
        this.jsonObject.put(R8_MODE, r8Mode);
        return this;
    }

    public Boolean isAndroidPlatformBuild() {
        if (this.jsonObject.has(ANDROID_PLATFORM_BUILD)) {
            return this.jsonObject.getBoolean(ANDROID_PLATFORM_BUILD);
        }
        return null;
    }

    public Marker setAndroidPlatformBuild(Boolean value) {
        this.jsonObject.put(ANDROID_PLATFORM_BUILD, value);
        return this;
    }

    public String buildString() {
        this.jsonObject.sort(CompareUtil.getComparableComparator(), true);
        return PREFIX + (Object)((Object)this.tool) + this.jsonObject;
    }

    public String toString() {
        return PREFIX + (Object)((Object)this.tool) + this.jsonObject;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Marker) {
            Marker other = (Marker)obj;
            return this.tool == other.tool && this.jsonObject.equals(other.jsonObject);
        }
        return false;
    }

    public int hashCode() {
        return this.tool.hashCode() + 3 * this.jsonObject.hashCode();
    }

    public static Iterator<Marker> parse(DexLayout dexLayout) {
        return Marker.parse(dexLayout.getSection(SectionType.STRING_ID));
    }

    public static Iterator<Marker> parse(Section<StringId> stringIdSection) {
        if (stringIdSection == null) {
            return EmptyIterator.of();
        }
        return Marker.parse(stringIdSection.iterator());
    }

    public static Iterator<Marker> parse(Iterator<StringId> iterator) {
        return ComputeIterator.of(iterator, Marker::parse);
    }

    public static Marker parse(StringId stringId) {
        String str = stringId.getString();
        if (Marker.hasMarkerPrefix(str)) {
            Marker marker = null;
            if (str.startsWith(D8_PREFIX)) {
                marker = Marker.internalParse(Tool.D8, str.substring(D8_PREFIX.length() - 1));
            } else if (str.startsWith(R8_PREFIX)) {
                marker = Marker.internalParse(Tool.R8, str.substring(R8_PREFIX.length() - 1));
            } else if (str.startsWith(L8_PREFIX)) {
                marker = Marker.internalParse(Tool.L8, str.substring(L8_PREFIX.length() - 1));
            }
            if (marker != null) {
                marker.setStringId(stringId);
            }
            return marker;
        }
        return null;
    }

    public static Marker parse(String dexString) {
        if (Marker.hasMarkerPrefix(dexString)) {
            if (dexString.startsWith(D8_PREFIX)) {
                return Marker.internalParse(Tool.D8, dexString.substring(D8_PREFIX.length() - 1));
            }
            if (dexString.startsWith(R8_PREFIX)) {
                return Marker.internalParse(Tool.R8, dexString.substring(R8_PREFIX.length() - 1));
            }
            if (dexString.startsWith(L8_PREFIX)) {
                return Marker.internalParse(Tool.L8, dexString.substring(L8_PREFIX.length() - 1));
            }
        }
        return null;
    }

    public static Marker createR8() {
        return Marker.parse(R8_TEMPLATE);
    }

    public static Marker createD8() {
        return Marker.parse(D8_TEMPLATE);
    }

    public static boolean hasMarkerPrefix(String content) {
        if (content == null || content.length() < 3) {
            return false;
        }
        return content.charAt(0) == '~' && content.charAt(1) == '~';
    }

    private static Marker internalParse(Tool tool, String str) {
        try {
            return new Marker(tool, new JSONObject(str));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static enum Backend {
        CF,
        DEX;

    }

    public static enum Tool {
        D8,
        GlobalSyntheticsGenerator,
        L8,
        R8,
        Relocator,
        TraceReferences;


        public static Tool[] valuesR8andD8() {
            return new Tool[]{D8, R8};
        }
    }
}

