/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.resource;

import com.reandroid.dex.model.DexClass;
import com.reandroid.dex.model.DexField;
import com.reandroid.dex.model.DexMethod;
import com.reandroid.dex.resource.REntry;
import com.reandroid.dex.resource.RTypeItem;
import com.reandroid.dex.smali.SmaliWriter;
import com.reandroid.utils.collection.ComputeIterator;
import java.io.IOException;
import java.util.Iterator;

public class RType
extends RTypeItem
implements Iterable<REntry> {
    public RType(DexClass dexClass) {
        super(dexClass);
    }

    @Override
    public Iterator<REntry> iterator() {
        return ComputeIterator.of(this.getDexClass().getStaticFields(), this::create);
    }

    public boolean isEmpty() {
        return !this.iterator().hasNext();
    }

    REntry create(DexField dexField) {
        return new REntry(dexField);
    }

    @Override
    public boolean isValid() {
        DexClass dexClass = this.getDexClass();
        if (dexClass.getInstanceFields().hasNext()) {
            return false;
        }
        Iterator<DexMethod> declaredMethods = dexClass.getDeclaredMethods();
        while (declaredMethods.hasNext()) {
            DexMethod dexMethod = declaredMethods.next();
            if (dexMethod.isConstructor()) continue;
            return false;
        }
        return this.isEntriesValid();
    }

    private boolean isEntriesValid() {
        boolean hasEntries = false;
        for (REntry entry : this) {
            if (!entry.isValid()) {
                return false;
            }
            hasEntries = true;
        }
        return hasEntries;
    }

    @Override
    public void appendJavaEntries(SmaliWriter writer) throws IOException {
        for (REntry entry : this) {
            writer.newLine();
            entry.appendJava(writer);
        }
    }
}

