/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.resource;

import com.reandroid.apk.XmlHelper;
import com.reandroid.arsc.chunk.TableBlock;
import com.reandroid.dex.key.TypeKey;
import com.reandroid.dex.model.DexClass;
import com.reandroid.dex.model.DexField;
import com.reandroid.dex.model.DexMethod;
import com.reandroid.dex.resource.RDeclareStyleable;
import com.reandroid.dex.resource.RStyleableIndex;
import com.reandroid.dex.resource.RStyleableItem;
import com.reandroid.dex.resource.RTypeItem;
import com.reandroid.dex.smali.SmaliWriter;
import com.reandroid.utils.collection.CollectionUtil;
import com.reandroid.utils.collection.ComputeIterator;
import com.reandroid.utils.collection.InstanceIterator;
import java.io.IOException;
import java.util.Iterator;
import org.xmlpull.v1.XmlSerializer;

public class RStyleableType
extends RTypeItem
implements Iterable<RStyleableItem> {
    public RStyleableType(DexClass dexClass) {
        super(dexClass);
    }

    @Override
    public Iterator<RStyleableItem> iterator() {
        return ComputeIterator.of(this.getDexClass().getStaticFields(), this::create);
    }

    public Iterator<RDeclareStyleable> getRDeclareStyleables() {
        return InstanceIterator.of(this.iterator(), RDeclareStyleable.class);
    }

    public boolean isEmpty() {
        return !this.iterator().hasNext();
    }

    RStyleableItem create(DexField dexField) {
        if (!dexField.isPublic() || !dexField.isStatic()) {
            return null;
        }
        TypeKey typeKey = dexField.getKey().getType();
        if (TypeKey.TYPE_I.equals(typeKey)) {
            return new RStyleableIndex(dexField);
        }
        if (RDeclareStyleable.INT_ARRAY.equals(typeKey)) {
            return new RDeclareStyleable(dexField);
        }
        return null;
    }

    @Override
    public boolean isValid() {
        DexClass dexClass = this.getDexClass();
        if (dexClass.getInstanceFields().hasNext()) {
            return false;
        }
        Iterator<DexMethod> declaredMethods = dexClass.getDeclaredMethods();
        while (declaredMethods.hasNext()) {
            DexMethod dexMethod = declaredMethods.next();
            if (dexMethod.isConstructor()) continue;
            return false;
        }
        return this.isEntriesValid();
    }

    private boolean isEntriesValid() {
        int attrCount = 0;
        int indexCount = 0;
        for (RStyleableItem item : this) {
            if (!item.isValid()) {
                return false;
            }
            if (item instanceof RStyleableIndex) {
                ++indexCount;
                continue;
            }
            ++attrCount;
        }
        if (indexCount == 0 || attrCount == 0) {
            return false;
        }
        return CollectionUtil.count(this.getDexClass().getStaticFields()) == indexCount + attrCount;
    }

    @Override
    public void appendJavaEntries(SmaliWriter writer) throws IOException {
        for (RStyleableItem item : this) {
            writer.newLine();
            item.appendJava(writer);
        }
    }

    public void serialize(TableBlock tableBlock, XmlSerializer serializer) throws IOException {
        serializer.startDocument("utf8", null);
        XmlHelper.setIndent(serializer, true);
        String tag = "resources";
        serializer.startTag(null, tag);
        for (RStyleableItem item : this) {
            item.serialize(tableBlock, serializer);
        }
        XmlHelper.setIndent(serializer, true);
        serializer.endTag(null, tag);
    }
}

