/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.refactor;

import com.reandroid.dex.id.FieldId;
import com.reandroid.dex.key.FieldKey;
import com.reandroid.dex.key.KeyPair;
import com.reandroid.dex.model.DexClassRepository;
import com.reandroid.dex.refactor.Rename;
import com.reandroid.dex.sections.SectionType;
import com.reandroid.utils.collection.ArrayCollection;
import java.util.Iterator;
import java.util.List;

public class RenameFields
extends Rename<FieldKey, FieldKey> {
    public void add(DexClassRepository classRepository, FieldKey search, String replace) {
        this.add(classRepository, search, search.changeName(replace));
    }

    public void add(DexClassRepository classRepository, FieldKey search, FieldKey replace) {
        KeyPair<FieldKey, FieldKey> start = new KeyPair<FieldKey, FieldKey>(search, replace);
        if (!start.isValid() || this.isLocked(start) || !search.getType().equals(replace.getType())) {
            return;
        }
        if (this.containsDeclaration(classRepository, replace)) {
            this.lock(start);
            return;
        }
        ArrayCollection list = new ArrayCollection();
        list.add(start);
        Iterator<FieldKey> iterator = classRepository.findEquivalentFields(search);
        while (iterator.hasNext()) {
            FieldKey equivalent = iterator.next();
            KeyPair<FieldKey, FieldKey> pair = new KeyPair<FieldKey, FieldKey>(equivalent, equivalent.changeName(replace.getName()));
            if (this.isLocked(pair)) {
                this.lockAll(list);
                list.clear();
                break;
            }
            list.add(pair);
        }
        this.addAll(list);
    }

    @Override
    public int apply(DexClassRepository classRepository) {
        List<KeyPair<FieldKey, FieldKey>> list = this.toList();
        return this.applyToFieldIds(classRepository, list);
    }

    private int applyToFieldIds(DexClassRepository classRepository, List<KeyPair<FieldKey, FieldKey>> keyPairList) {
        int count = 0;
        for (KeyPair<FieldKey, FieldKey> pair : keyPairList) {
            FieldKey search = pair.getFirst();
            FieldKey replace = pair.getSecond();
            Iterator<FieldId> iterator = classRepository.getItems(SectionType.FIELD_ID, search);
            while (iterator.hasNext()) {
                FieldId fieldId = iterator.next();
                fieldId.setKey(replace);
                ++count;
            }
        }
        return count;
    }

    @Override
    protected boolean containsDeclaration(DexClassRepository classRepository, FieldKey replaceKey) {
        return classRepository.getDeclaredField(replaceKey) != null;
    }
}

