/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.pool;

import com.reandroid.dex.common.SectionItem;
import com.reandroid.dex.key.Key;
import com.reandroid.dex.key.KeyItem;
import com.reandroid.dex.key.KeyReference;
import com.reandroid.dex.sections.Section;
import com.reandroid.dex.sections.SectionType;
import com.reandroid.utils.CompareUtil;
import com.reandroid.utils.collection.ArrayCollection;
import com.reandroid.utils.collection.MultiMap;
import java.util.Comparator;

public class DexSectionPool<T extends SectionItem>
extends MultiMap<Key, T> {
    private final Section<T> section;
    private boolean keyItems;
    private boolean keyItemsCreate;
    private boolean keyItemsChecked;

    public DexSectionPool(Section<T> section) {
        this.section = section;
    }

    public T getOrCreate(Key key) {
        if (key == null || !this.isKeyItemsCreate()) {
            return null;
        }
        SectionItem item = (SectionItem)this.get(key);
        if (item == null) {
            item = this.createNext(key);
            this.put(item.getKey(), item);
        }
        return (T)item;
    }

    public SectionType<T> getSectionType() {
        return this.getSection().getSectionType();
    }

    @Override
    public void remove(T item) {
        if (item != null) {
            super.remove(((SectionItem)item).getKey(), item);
        }
    }

    public boolean contains(Key key) {
        return super.containsKey(key);
    }

    public void load() {
        if (!this.isKeyItems()) {
            return;
        }
        Section<T> section = this.getSection();
        this.putAll(SectionItem::getKey, section.iterator());
    }

    T createNext(Key key) {
        T item = this.getSection().createItem();
        ((KeyReference)item).setKey(key);
        return item;
    }

    Section<T> getSection() {
        return this.section;
    }

    public int clearDuplicates() {
        if (this.size() == 0 || this.size() == this.getSection().getCount()) {
            return 0;
        }
        ArrayCollection result = new ArrayCollection();
        Comparator comparator = (item1, item2) -> {
            int i = CompareUtil.compare(item1.isRemoved(), item2.isRemoved());
            if (i != 0 || item1.isRemoved()) {
                return i;
            }
            i = CompareUtil.compare(item1.getKey(), item2.getKey());
            return i;
        };
        this.findDuplicates(comparator, list -> {
            SectionItem first = (SectionItem)list.get(0);
            for (int i = 1; i < list.size(); ++i) {
                SectionItem item = (SectionItem)list.get(i);
                item.setReplace(first);
                result.add(item);
            }
        });
        Section<T> section = this.getSection();
        section.getItemArray().removeAll(result);
        return result.size();
    }

    boolean isKeyItemsCreate() {
        this.isKeyItems();
        return this.keyItemsCreate;
    }

    private boolean isKeyItems() {
        if (this.keyItemsChecked) {
            return this.keyItems;
        }
        if (this.getSectionType().isIdSection()) {
            this.keyItemsChecked = true;
            this.keyItems = true;
            this.keyItemsCreate = true;
            return true;
        }
        SectionItem sample = (SectionItem)this.getSectionType().getCreator().newInstance();
        this.keyItemsChecked = true;
        this.keyItems = sample instanceof KeyItem;
        this.keyItemsCreate = sample instanceof KeyReference;
        return this.keyItems;
    }

    @Override
    public String toString() {
        return this.getSectionType().getName() + "-Pool = " + this.size();
    }
}

