/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.model;

import com.reandroid.dex.data.MethodParameter;
import com.reandroid.dex.key.Key;
import com.reandroid.dex.key.TypeKey;
import com.reandroid.dex.model.AnnotatedDex;
import com.reandroid.dex.model.Dex;
import com.reandroid.dex.model.DexAnnotation;
import com.reandroid.dex.model.DexClass;
import com.reandroid.dex.model.DexClassRepository;
import com.reandroid.dex.model.DexMethod;
import com.reandroid.dex.program.MethodParameterProgram;
import com.reandroid.dex.program.ProgramElement;
import com.reandroid.dex.smali.SmaliWriter;
import com.reandroid.utils.ObjectsUtil;
import java.io.IOException;
import java.util.Iterator;

public class DexMethodParameter
extends Dex
implements AnnotatedDex,
MethodParameterProgram {
    private final DexMethod dexMethod;
    private final MethodParameter parameter;

    public DexMethodParameter(DexMethod dexMethod, MethodParameter parameter) {
        this.dexMethod = dexMethod;
        this.parameter = parameter;
    }

    @Override
    public TypeKey getKey() {
        return this.getParameter().getKey();
    }

    @Override
    public String getDebugName() {
        return this.getParameter().getDebugName();
    }

    @Override
    public void setDebugName(String name) {
        this.getParameter().setDebugName(name);
    }

    public DexClass getTypeClass() {
        return this.getClassRepository().getDexClass(this.getType());
    }

    public TypeKey getType() {
        return this.getParameter().getType();
    }

    public int getIndex() {
        return this.getParameter().getDefinitionIndex();
    }

    public DexMethod getDexMethod() {
        return this.dexMethod;
    }

    public MethodParameter getParameter() {
        return this.parameter;
    }

    @Override
    public boolean uses(Key key) {
        if (ObjectsUtil.equals(this.getType(), key)) {
            return true;
        }
        Iterator<DexAnnotation> iterator = this.getDexAnnotations();
        while (iterator.hasNext()) {
            DexAnnotation dexAnnotation = iterator.next();
            if (!dexAnnotation.uses(key)) continue;
            return true;
        }
        return false;
    }

    @Override
    public DexClassRepository getClassRepository() {
        return this.getDexMethod().getClassRepository();
    }

    @Override
    public void removeSelf() {
        this.getDexMethod().removeParameter(this.getIndex());
    }

    @Override
    public ProgramElement getProgramElement() {
        return this.getParameter();
    }

    @Override
    public void append(SmaliWriter writer) throws IOException {
        this.getParameter().append(writer);
    }

    public static DexMethodParameter create(DexMethod dexMethod, MethodParameter parameter) {
        if (dexMethod != null && parameter != null) {
            return new DexMethodParameter(dexMethod, parameter);
        }
        return null;
    }
}

