/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.model;

import com.reandroid.dex.common.SectionItem;
import com.reandroid.dex.key.Key;
import com.reandroid.dex.key.TypeKey;
import com.reandroid.dex.model.DexClass;
import com.reandroid.dex.model.DexClassRepository;
import com.reandroid.dex.model.DexSectionInfo;
import com.reandroid.dex.sections.Marker;
import com.reandroid.dex.sections.Section;
import com.reandroid.dex.sections.SectionType;
import com.reandroid.utils.ObjectsUtil;
import com.reandroid.utils.collection.CombiningIterator;
import com.reandroid.utils.collection.EmptyIterator;
import com.reandroid.utils.collection.SingleIterator;
import java.util.Iterator;
import java.util.function.Predicate;

public interface DexClassModule
extends DexClassRepository {
    @Override
    public int getVersion();

    @Override
    public void setVersion(int var1);

    public boolean isMultiLayoutEntry();

    public int getOffset();

    public Iterator<DexClass> getExtendingClasses(TypeKey var1);

    public Iterator<DexClass> getImplementClasses(TypeKey var1);

    @Override
    public DexClass getDexClass(TypeKey var1);

    public DexClass getOrCreateClass(TypeKey var1);

    @Override
    public Iterator<DexClass> getDexClasses(Predicate<? super TypeKey> var1);

    @Override
    public Iterator<DexClass> getDexClassesCloned(Predicate<? super TypeKey> var1);

    @Override
    public boolean sort();

    @Override
    default public Iterator<DexClass> getSuccessorClasses(TypeKey typeKey) {
        return CombiningIterator.two(this.getExtendingClasses(typeKey), this.getImplementClasses(typeKey));
    }

    @Override
    default public <T extends SectionItem> Iterator<Section<T>> getSections(SectionType<T> sectionType) {
        return SingleIterator.of(this.getSection(sectionType));
    }

    public <T extends SectionItem> Section<T> getSection(SectionType<T> var1);

    public <T extends SectionItem> Section<T> getOrCreateSection(SectionType<T> var1);

    @Override
    default public <T extends SectionItem> T getItem(SectionType<T> sectionType, Key key) {
        Section<T> section = this.getSection(sectionType);
        if (section != null) {
            return section.get(key);
        }
        return null;
    }

    @Override
    default public <T extends SectionItem> Iterator<T> getItems(SectionType<T> sectionType) {
        Section<T> section = this.getSection(sectionType);
        if (section != null) {
            return section.iterator();
        }
        return EmptyIterator.of();
    }

    default public int getCount(SectionType<?> sectionType) {
        Section<?> section = this.getSection(sectionType);
        if (section != null) {
            return section.getCount();
        }
        return 0;
    }

    @Override
    default public int getDexClassesCount() {
        return this.getCount(SectionType.CLASS_ID);
    }

    public void addMarker(Marker var1);

    @Override
    public Iterator<Marker> getMarkers();

    public Iterator<DexSectionInfo> getSectionInfo();

    default public DexSectionInfo getSectionInfo(SectionType<?> sectionType) {
        Iterator<DexSectionInfo> iterator = this.getSectionInfo();
        while (iterator.hasNext()) {
            DexSectionInfo sectionInfo = iterator.next();
            if (!ObjectsUtil.equals(sectionType, sectionInfo.getSectionType())) continue;
            return sectionInfo;
        }
        return null;
    }

    @Override
    public <T1 extends SectionItem> boolean removeEntries(SectionType<T1> var1, Predicate<T1> var2);

    @Override
    public <T1 extends SectionItem> boolean removeEntriesWithKey(SectionType<T1> var1, Predicate<? super Key> var2);

    @Override
    public <T1 extends SectionItem> boolean removeEntry(SectionType<T1> var1, Key var2);

    @Override
    public boolean removeClasses(Predicate<? super DexClass> var1);

    @Override
    public void clearPoolMap();

    @Override
    public int shrink();
}

