/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.model;

import com.reandroid.dex.ins.CatchAllHandler;
import com.reandroid.dex.ins.ExceptionHandler;
import com.reandroid.dex.key.Key;
import com.reandroid.dex.key.TypeKey;
import com.reandroid.dex.model.DexCode;
import com.reandroid.dex.model.DexInstruction;
import com.reandroid.dex.model.DexMethod;
import com.reandroid.dex.model.DexTry;
import com.reandroid.dex.smali.SmaliWriter;
import java.io.IOException;

public class DexCatch
extends DexCode {
    private final DexTry dexTry;
    private final ExceptionHandler exceptionHandler;

    public DexCatch(DexTry dexTry, ExceptionHandler exceptionHandler) {
        this.dexTry = dexTry;
        this.exceptionHandler = exceptionHandler;
    }

    public TypeKey getKey() {
        return this.getExceptionHandler().getKey();
    }

    public void setKey(TypeKey typeKey) {
        this.getExceptionHandler().setKey(typeKey);
    }

    public boolean traps(TypeKey typeKey) {
        return this.getExceptionHandler().traps(typeKey);
    }

    public boolean isCatchAll() {
        return this.getExceptionHandler() instanceof CatchAllHandler;
    }

    public int getCatchAddress() {
        return this.getExceptionHandler().getCatchAddress();
    }

    public void setCatchAddress(int address) {
        this.getExceptionHandler().setCatchAddress(address);
    }

    public DexInstruction getCaughtInstruction() {
        return this.getDexMethod().getInstructionAt(this.getCatchAddress());
    }

    @Override
    public void removeSelf() {
        this.getExceptionHandler().removeSelf();
    }

    @Override
    public DexMethod getDexMethod() {
        return this.getDexTry().getDexMethod();
    }

    public DexTry getDexTry() {
        return this.dexTry;
    }

    public ExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }

    @Override
    public boolean uses(Key key) {
        TypeKey typeKey = this.getKey();
        if (typeKey != null) {
            return typeKey.uses(key);
        }
        return false;
    }

    @Override
    public void append(SmaliWriter writer) throws IOException {
        this.getExceptionHandler().getHandlerLabel().appendExtra(writer);
    }
}

