/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.key;

import com.reandroid.dex.common.MethodHandleType;
import com.reandroid.dex.key.FieldKey;
import com.reandroid.dex.key.Key;
import com.reandroid.dex.key.MethodKey;
import com.reandroid.dex.key.ProgramKey;
import com.reandroid.dex.key.TypeKey;
import com.reandroid.dex.smali.SmaliParseException;
import com.reandroid.dex.smali.SmaliReader;
import com.reandroid.dex.smali.SmaliWriter;
import com.reandroid.utils.CompareUtil;
import com.reandroid.utils.ObjectsUtil;
import com.reandroid.utils.StringsUtil;
import java.io.IOException;
import java.util.Iterator;

public class MethodHandleKey
implements Key {
    private final MethodHandleType handleType;
    private final Key member;

    public MethodHandleKey(MethodHandleType handleType, Key member) {
        this.handleType = handleType;
        this.member = member;
    }

    public MethodHandleType getHandleType() {
        return this.handleType;
    }

    public Key getMember() {
        return this.member;
    }

    @Override
    public TypeKey getDeclaring() {
        return this.getMember().getDeclaring();
    }

    @Override
    public Iterator<? extends Key> mentionedKeys() {
        return this.getMember().mentionedKeys();
    }

    @Override
    public Key replaceKey(Key search, Key replace) {
        if (search.equals(this)) {
            return replace;
        }
        Key key = this.getMember().replaceKey(search, replace);
        if (key != this.getMember()) {
            return new MethodHandleKey(this.getHandleType(), key);
        }
        return this;
    }

    @Override
    public void append(SmaliWriter writer) throws IOException {
        this.append(writer, true);
    }

    public void append(SmaliWriter writer, boolean appendHandle) throws IOException {
        if (appendHandle) {
            this.getHandleType().append(writer);
        }
        writer.append('@');
        this.getMember().append(writer);
    }

    @Override
    public int compareTo(Object obj) {
        if (obj == this) {
            return 0;
        }
        if (!(obj instanceof MethodHandleKey)) {
            return StringsUtil.compareToString(this, obj);
        }
        MethodHandleKey other = (MethodHandleKey)obj;
        int i = CompareUtil.compare(this.getHandleType(), other.getHandleType());
        if (i != 0) {
            return i;
        }
        return CompareUtil.compare(this.getMember(), other.getMember());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MethodHandleKey)) {
            return false;
        }
        MethodHandleKey other = (MethodHandleKey)obj;
        return ObjectsUtil.equals(this.getHandleType(), other.getHandleType()) && ObjectsUtil.equals(this.getMember(), other.getMember());
    }

    public int hashCode() {
        return ObjectsUtil.hash(this.getHandleType(), this.getMember().hashCode());
    }

    public String toString() {
        return this.getHandleType() + "@" + this.getMember();
    }

    public static MethodHandleKey read(SmaliReader reader) throws IOException {
        MethodHandleType handleType = MethodHandleType.read(reader);
        if (handleType == null) {
            return null;
        }
        SmaliParseException.expect(reader, '@');
        return MethodHandleKey.read(handleType, reader);
    }

    public static MethodHandleKey read(MethodHandleType handleType, SmaliReader reader) throws IOException {
        ProgramKey key = handleType.isField() ? FieldKey.read(reader) : MethodKey.read(reader);
        return new MethodHandleKey(handleType, key);
    }
}

