/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.key;

import com.reandroid.dex.key.Key;
import com.reandroid.utils.CompareUtil;
import com.reandroid.utils.ObjectsUtil;
import com.reandroid.utils.collection.ArrayCollection;
import com.reandroid.utils.collection.ComputeIterator;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class KeyPair<T1 extends Key, T2 extends Key>
implements Comparable<KeyPair<Key, Key>> {
    private T1 first;
    private T2 second;

    public KeyPair(T1 first, T2 second) {
        this.first = first;
        this.second = second;
    }

    public KeyPair(T1 first) {
        this(first, null);
    }

    public KeyPair() {
        this(null, null);
    }

    public T1 getFirst() {
        return this.first;
    }

    public void setFirst(T1 first) {
        this.first = first;
    }

    public T2 getSecond() {
        return this.second;
    }

    public void setSecond(T2 second) {
        this.second = second;
    }

    public KeyPair<T2, T1> flip() {
        return new KeyPair<T2, T1>(this.getSecond(), this.getFirst());
    }

    public boolean isValid() {
        T1 t1 = this.getFirst();
        if (t1 == null) {
            return false;
        }
        T2 t2 = this.getSecond();
        if (t2 == null) {
            return false;
        }
        return !t1.equals(t2);
    }

    @Override
    public int compareTo(KeyPair<Key, Key> pair) {
        if (pair == null) {
            return -1;
        }
        T1 key1 = this.getFirst();
        Key key2 = pair.getFirst();
        if (key1 == null) {
            if (key2 == null) {
                return 0;
            }
            return 1;
        }
        if (key2 == null) {
            return -1;
        }
        int i = key1.getDeclaring().compareInnerFirst(key2.getDeclaring());
        if (i == 0) {
            i = CompareUtil.compare(key1, key2);
        }
        return i;
    }

    public boolean equalsBoth(KeyPair<?, ?> keyPair) {
        if (this == keyPair) {
            return true;
        }
        return ObjectsUtil.equals(this.getFirst(), keyPair.getFirst()) && ObjectsUtil.equals(this.getSecond(), keyPair.getSecond());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof KeyPair)) {
            return false;
        }
        KeyPair keyPair = (KeyPair)obj;
        return ObjectsUtil.equals(this.getFirst(), keyPair.getFirst());
    }

    public int hashCode() {
        return ObjectsUtil.hash(this.getFirst());
    }

    public String toString() {
        return this.getFirst() + "=" + this.getSecond();
    }

    public static <E1 extends Key, E2 extends Key> Iterator<KeyPair<E2, E1>> flip(Iterator<KeyPair<E1, E2>> iterator) {
        return ComputeIterator.of(iterator, KeyPair::flip);
    }

    public static <E1 extends Key, E2 extends Key> List<KeyPair<E2, E1>> flip(Collection<KeyPair<E1, E2>> list) {
        ArrayCollection<KeyPair<E2, E1>> results = new ArrayCollection<KeyPair<E2, E1>>(list.size());
        results.addAll(KeyPair.flip(list.iterator()));
        return results;
    }
}

