/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.key;

import com.reandroid.dex.common.MethodHandleType;
import com.reandroid.dex.key.ArrayKey;
import com.reandroid.dex.key.Key;
import com.reandroid.dex.key.MethodHandleKey;
import com.reandroid.dex.key.ProtoKey;
import com.reandroid.dex.key.StringKey;
import com.reandroid.dex.smali.SmaliParseException;
import com.reandroid.dex.smali.SmaliReader;
import com.reandroid.dex.smali.SmaliWriter;
import com.reandroid.utils.CompareUtil;
import com.reandroid.utils.ObjectsUtil;
import com.reandroid.utils.StringsUtil;
import java.io.IOException;

public class CallSiteKey
implements Key {
    private final MethodHandleKey methodHandle;
    private final StringKey name;
    private final ProtoKey proto;
    private final ArrayKey<?> arguments;

    public CallSiteKey(MethodHandleKey methodHandle, StringKey name, ProtoKey proto, ArrayKey<?> arguments) {
        this.methodHandle = methodHandle;
        this.name = name;
        this.proto = proto;
        this.arguments = arguments;
    }

    public MethodHandleKey getMethodHandle() {
        return this.methodHandle;
    }

    public StringKey getName() {
        return this.name;
    }

    public ProtoKey getProto() {
        return this.proto;
    }

    public ArrayKey<?> getArguments() {
        return this.arguments;
    }

    public ArrayKey<?> toArrayKey() {
        ArrayKey<?> arguments = this.getArguments();
        int argumentsLength = arguments.size();
        Key[] elements = new Key[3 + arguments.size()];
        elements[0] = this.getMethodHandle();
        elements[1] = this.getName();
        elements[2] = this.getProto();
        for (int i = 0; i < argumentsLength; ++i) {
            elements[i + 3] = arguments.get(i);
        }
        return ArrayKey.create(elements);
    }

    public CallSiteKey changeMethodHandle(MethodHandleKey methodHandle) {
        if (methodHandle.equals(this.getMethodHandle())) {
            return this;
        }
        return new CallSiteKey(methodHandle, this.getName(), this.getProto(), this.getArguments());
    }

    public CallSiteKey changeName(StringKey name) {
        if (name.equals(this.getName())) {
            return this;
        }
        return new CallSiteKey(this.getMethodHandle(), name, this.getProto(), this.getArguments());
    }

    public CallSiteKey changeProto(ProtoKey proto) {
        if (proto.equals(this.getProto())) {
            return this;
        }
        return new CallSiteKey(this.getMethodHandle(), this.getName(), proto, this.getArguments());
    }

    public CallSiteKey changeArguments(ArrayKey<?> arguments) {
        if (arguments.equals(this.getArguments())) {
            return this;
        }
        return new CallSiteKey(this.getMethodHandle(), this.getName(), this.getProto(), arguments);
    }

    @Override
    public void append(SmaliWriter writer) throws IOException {
        writer.append('(');
        this.getName().append(writer);
        writer.append(", ");
        this.getProto().append(writer);
        ArrayKey<?> arguments = this.getArguments();
        int size = arguments.size();
        for (int i = 0; i < size; ++i) {
            if (i != 0) {
                writer.append(", ");
            }
            arguments.get(i).append(writer);
        }
        writer.append(')');
        this.getMethodHandle().append(writer, false);
    }

    @Override
    public int compareTo(Object obj) {
        if (obj == this) {
            return 0;
        }
        if (!(obj instanceof CallSiteKey)) {
            return StringsUtil.compareToString(this, obj);
        }
        CallSiteKey key = (CallSiteKey)obj;
        int i = CompareUtil.compare(this.getMethodHandle(), key.getMethodHandle());
        if (i == 0 && (i = CompareUtil.compare(this.getArguments(), key.getArguments())) == 0 && (i = CompareUtil.compare(this.getName(), key.getName())) == 0) {
            i = CompareUtil.compare(this.getProto(), key.getProto());
        }
        return i;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CallSiteKey)) {
            return false;
        }
        CallSiteKey other = (CallSiteKey)obj;
        return ObjectsUtil.equals(this.getMethodHandle(), other.getMethodHandle()) && ObjectsUtil.equals(this.getName(), other.getName()) && ObjectsUtil.equals(this.getProto(), other.getProto()) && ObjectsUtil.equals(this.getArguments(), other.getArguments());
    }

    public int hashCode() {
        return ObjectsUtil.hash(this.getMethodHandle(), this.getName(), this.getProto(), this.getArguments());
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append('(');
        builder.append(this.getName());
        builder.append(", ");
        builder.append(this.getProto());
        ArrayKey<?> arguments = this.getArguments();
        if (!arguments.isEmpty()) {
            builder.append(", ");
            builder.append(arguments.toString(", "));
        }
        builder.append(')');
        builder.append('@');
        MethodHandleKey handle = this.getMethodHandle();
        if (handle != null) {
            builder.append(handle.getMember());
        } else {
            builder.append("null");
        }
        return builder.toString();
    }

    public static CallSiteKey read(SmaliReader reader) throws IOException {
        reader.skipWhitespaces();
        String label = CallSiteKey.readCallSiteLabel(reader);
        SmaliParseException.expect(reader, '(');
        StringKey name = StringKey.read(reader);
        reader.skipWhitespacesOrComment();
        SmaliParseException.expect(reader, ',');
        ProtoKey protoKey = ProtoKey.read(reader);
        reader.skipWhitespacesOrComment();
        SmaliParseException.expect(reader, ',');
        ArrayKey arguments = ArrayKey.read(reader, ')');
        reader.skipWhitespacesOrComment();
        SmaliParseException.expect(reader, '@');
        MethodHandleKey methodHandleKey = MethodHandleKey.read(MethodHandleType.INVOKE_STATIC, reader);
        return new CallSiteKey(methodHandleKey, name, protoKey, arguments);
    }

    public static CallSiteKey parse(String text) {
        throw new RuntimeException("CallSiteKey.parse not implemented");
    }

    private static String readCallSiteLabel(SmaliReader reader) throws IOException {
        int position = reader.position();
        if (reader.getASCII(position) == '(') {
            return null;
        }
        int i = reader.indexOfBeforeLineEnd('(');
        if (i < 0) {
            throw new SmaliParseException("Expecting call site", reader);
        }
        return reader.readString(i - position);
    }
}

