/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.key;

import com.reandroid.dex.key.Key;
import com.reandroid.dex.key.KeyList;
import com.reandroid.dex.key.KeyUtil;
import com.reandroid.dex.smali.SmaliParseException;
import com.reandroid.dex.smali.SmaliReader;
import com.reandroid.dex.smali.SmaliWriter;
import com.reandroid.utils.StringsUtil;
import com.reandroid.utils.collection.ArrayCollection;
import java.io.IOException;
import java.io.StringWriter;
import java.util.Comparator;
import java.util.function.Predicate;

public class ArrayKey<T extends Key>
extends KeyList<T> {
    private static final ArrayKey<?> EMPTY = new ArrayKey(EMPTY_ARRAY);

    protected ArrayKey(Key[] elements) {
        super(elements);
    }

    @Override
    public ArrayKey<T> add(T item) {
        return (ArrayKey)super.add(item);
    }

    @Override
    public ArrayKey<T> remove(T itemKey) {
        return (ArrayKey)super.remove(itemKey);
    }

    @Override
    public ArrayKey<T> remove(int index) {
        return (ArrayKey)super.remove(index);
    }

    @Override
    public ArrayKey<T> removeIf(Predicate<? super T> predicate) {
        return (ArrayKey)super.removeIf(predicate);
    }

    @Override
    public ArrayKey<T> set(int i, T item) {
        return (ArrayKey)super.set(i, item);
    }

    @Override
    public ArrayKey<T> sort(Comparator<? super T> comparator) {
        return (ArrayKey)super.sort(comparator);
    }

    @Override
    public ArrayKey<T> clearDuplicates() {
        return (ArrayKey)super.clearDuplicates();
    }

    @Override
    public ArrayKey<T> clearDuplicates(Comparator<? super T> comparator) {
        return (ArrayKey)super.clearDuplicates(comparator);
    }

    @Override
    protected ArrayKey<T> newInstance(Key[] elements) {
        if (this.getClass() != ArrayKey.class) {
            throw new RuntimeException("Method not implemented");
        }
        return ArrayKey.create(elements);
    }

    @Override
    public void append(SmaliWriter writer) throws IOException {
        this.append(writer, ", ");
    }

    public void append(SmaliWriter writer, String separator) throws IOException {
        boolean appendOnce = false;
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            Object key = this.get(i);
            if (appendOnce) {
                writer.append(separator);
            }
            if (key == null) {
                writer.append("# null");
            } else {
                key.append(writer);
            }
            appendOnce = true;
        }
    }

    @Override
    public String toString() {
        return this.toString(", ");
    }

    public String toString(String separator) {
        StringWriter stringWriter = new StringWriter();
        SmaliWriter writer = new SmaliWriter(stringWriter);
        try {
            this.append(writer, separator);
            writer.close();
            return stringWriter.toString();
        }
        catch (IOException exception) {
            return "# " + exception.toString();
        }
    }

    @Override
    public ArrayKey<T> replaceKey(Key search, Key replace) {
        return (ArrayKey)super.replaceKey(search, replace);
    }

    @Override
    public int compareTo(Object obj) {
        if (obj == this) {
            return 0;
        }
        if (!(obj instanceof ArrayKey)) {
            return StringsUtil.compareToString(this, obj);
        }
        return this.compareElements((ArrayKey)obj);
    }

    @Override
    public int hashCode() {
        return this.getHashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ArrayKey)) {
            return false;
        }
        return this.equalsElements((ArrayKey)obj);
    }

    public static <E extends Key> ArrayKey<E> empty() {
        return EMPTY;
    }

    public static <E extends Key> ArrayKey<E> create(Key ... elements) {
        if (elements == null || elements.length == 0) {
            return ArrayKey.empty();
        }
        return new ArrayKey(elements);
    }

    public static <E extends Key> ArrayKey<E> read(SmaliReader reader, char end) throws IOException {
        return ArrayKey.create(ArrayKey.readElements(reader, end));
    }

    public static Key[] readElements(SmaliReader reader, char end) throws IOException {
        reader.skipWhitespacesOrComment();
        if (reader.getASCII(reader.position()) == end) {
            reader.readASCII();
            return EMPTY_ARRAY;
        }
        ArrayCollection<Key> results = new ArrayCollection<Key>();
        while (true) {
            Key key = KeyUtil.readKey(reader);
            results.add(key);
            reader.skipWhitespacesOrComment();
            if (reader.getASCII(reader.position()) == end) break;
            SmaliParseException.expect(reader, ',');
        }
        SmaliParseException.expect(reader, end);
        return results.toArrayFill(new Key[results.size()]);
    }

    public static <E extends Key> ArrayKey<E> parse(String text) {
        throw new RuntimeException("ArrayKey.parse not implemented");
    }
}

