/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.key;

import com.reandroid.dex.key.Key;
import com.reandroid.dex.key.KeyUtil;
import com.reandroid.dex.key.MethodKey;
import com.reandroid.dex.key.NullValueKey;
import com.reandroid.dex.key.ProtoKey;
import com.reandroid.dex.key.StringKey;
import com.reandroid.dex.key.TypeKey;
import com.reandroid.dex.smali.SmaliParseException;
import com.reandroid.dex.smali.SmaliReader;
import com.reandroid.dex.smali.SmaliWriter;
import com.reandroid.utils.CompareUtil;
import com.reandroid.utils.ObjectsUtil;
import com.reandroid.utils.StringsUtil;
import com.reandroid.utils.collection.CombiningIterator;
import com.reandroid.utils.collection.EmptyIterator;
import com.reandroid.utils.collection.SingleIterator;
import java.io.IOException;
import java.util.Iterator;

public class AnnotationElementKey
implements Key {
    private final String name;
    private final Key value;

    private AnnotationElementKey(String name, Key value) {
        this.name = name;
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public StringKey getNameKey() {
        return StringKey.create(this.getName());
    }

    public Key getValue() {
        return this.value;
    }

    public AnnotationElementKey changeName(StringKey name) {
        return this.changeName(name == null ? null : name.getString());
    }

    public AnnotationElementKey changeName(String name) {
        if (ObjectsUtil.equals(this.getName(), name)) {
            return this;
        }
        return AnnotationElementKey.create(name, this.getValue());
    }

    public AnnotationElementKey changeValue(Key value) {
        if (ObjectsUtil.equals(this.getValue(), value)) {
            return this;
        }
        return AnnotationElementKey.create(this.getName(), value);
    }

    public MethodKey toMethod(TypeKey declaring) {
        return MethodKey.create(declaring, this.getNameKey(), ProtoKey.create(KeyUtil.getReturnTypeForValue(this.getValue()), new TypeKey[0]));
    }

    @Override
    public AnnotationElementKey replaceKey(Key search, Key replace) {
        Key value;
        if (this.equals(search)) {
            return (AnnotationElementKey)replace;
        }
        AnnotationElementKey result = this;
        if (ObjectsUtil.equals(this.getNameKey(), search)) {
            result = this.changeName((StringKey)replace);
        }
        if ((value = this.getValue()) != null && (value = value.replaceKey(search, replace)) != this.getValue()) {
            result = result.changeValue(value);
        }
        return result;
    }

    @Override
    public Iterator<? extends Key> mentionedKeys() {
        Key value = this.getValue();
        Iterator<Object> valueMentions = value == null ? EmptyIterator.of() : value.mentionedKeys();
        return CombiningIterator.singleThree(this, SingleIterator.of(this.getNameKey()), SingleIterator.of(value), valueMentions);
    }

    @Override
    public int compareTo(Object obj) {
        if (obj == this) {
            return 0;
        }
        if (!(obj instanceof AnnotationElementKey)) {
            return StringsUtil.compareToString(this, obj);
        }
        AnnotationElementKey elementKey = (AnnotationElementKey)obj;
        int i = CompareUtil.compare(this.getName(), elementKey.getName());
        if (i == 0) {
            i = CompareUtil.compare(this.getValue(), elementKey.getValue());
        }
        return i;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AnnotationElementKey)) {
            return false;
        }
        AnnotationElementKey other = (AnnotationElementKey)obj;
        return ObjectsUtil.equals(this.getName(), other.getName()) && ObjectsUtil.equals(this.getValue(), other.getValue());
    }

    public int hashCode() {
        return ObjectsUtil.hash(this.getName(), this.getValue());
    }

    @Override
    public void append(SmaliWriter writer) throws IOException {
        writer.append(this.getName());
        writer.append(" = ");
        this.getValue().append(writer);
    }

    public String toString() {
        return this.getName() + " = " + this.getValue();
    }

    public static AnnotationElementKey create(String name, Key value) {
        if (name == null) {
            return null;
        }
        if (value == null) {
            value = NullValueKey.INSTANCE;
        }
        return new AnnotationElementKey(name, value);
    }

    public static AnnotationElementKey read(SmaliReader reader) throws IOException {
        String name = reader.readSimpleNameIgnoreWhitespaces();
        SmaliParseException.expect(reader, '=');
        reader.skipWhitespacesOrComment();
        Key value = KeyUtil.readKey(reader);
        return AnnotationElementKey.create(name, value);
    }
}

