/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.ins;

import com.reandroid.arsc.io.BlockReader;
import com.reandroid.arsc.item.ByteArray;
import com.reandroid.dex.common.OperandType;
import com.reandroid.dex.common.Register;
import com.reandroid.dex.common.RegisterFormat;
import com.reandroid.dex.common.RegistersTable;
import com.reandroid.dex.data.CodeItem;
import com.reandroid.dex.data.InstructionList;
import com.reandroid.dex.data.MethodDef;
import com.reandroid.dex.id.IdItem;
import com.reandroid.dex.ins.Ins;
import com.reandroid.dex.ins.InsConstCommentHelper;
import com.reandroid.dex.ins.InstructionException;
import com.reandroid.dex.ins.Label;
import com.reandroid.dex.ins.Opcode;
import com.reandroid.dex.ins.RegisterReference;
import com.reandroid.dex.ins.RegistersIterator;
import com.reandroid.dex.ins.RegistersSet;
import com.reandroid.dex.key.DualKeyReference;
import com.reandroid.dex.key.Key;
import com.reandroid.dex.reference.InsIdSectionReference;
import com.reandroid.dex.sections.SectionType;
import com.reandroid.dex.smali.SmaliWriter;
import com.reandroid.dex.smali.model.SmaliInstruction;
import com.reandroid.dex.smali.model.SmaliInstructionOperand;
import com.reandroid.dex.smali.model.SmaliLabel;
import com.reandroid.dex.smali.model.SmaliRegisterSet;
import com.reandroid.utils.HexUtil;
import com.reandroid.utils.collection.SingleIterator;
import java.io.IOException;
import java.util.Iterator;
import java.util.Objects;

public class SizeXIns
extends Ins {
    private final ByteArray valueBytes = new ByteArray();
    private final InsIdSectionReference sectionReference;

    public SizeXIns(Opcode<?> opcode, boolean hasSectionData) {
        super(opcode);
        this.addChild(0, this.valueBytes);
        this.valueBytes.setSize(opcode.size());
        this.valueBytes.putShort(0, opcode.getValue());
        InsIdSectionReference sectionReference = hasSectionData ? new InsIdSectionReference(this) : null;
        this.sectionReference = sectionReference;
    }

    public SizeXIns(Opcode<?> opcode) {
        this(opcode, opcode.getSectionType() != null);
    }

    public SectionType<? extends IdItem> getSectionType() {
        return this.getOpcode().getSectionType();
    }

    public SectionType<? extends IdItem> getSectionType2() {
        return this.getOpcode().getSectionType2();
    }

    final ByteArray getValueBytes() {
        return this.valueBytes;
    }

    long getLong() {
        return SizeXIns.getLong(this.valueBytes.getBytes(), 2);
    }

    void setLong(long value) {
        SizeXIns.putLong(this.valueBytes.getBytes(), 2, value);
    }

    int getInteger() {
        return this.valueBytes.getInteger(2);
    }

    void setInteger(int value) {
        this.valueBytes.putInteger(2, value);
    }

    int getShortUnsigned(int offset) {
        return this.valueBytes.getShortUnsigned(offset);
    }

    int getShortSigned() {
        return this.valueBytes.getShort(2);
    }

    void setShort(int offset, int value) {
        if ((value & 0xFFFF0000) != 0 && value != (short)value) {
            throw new InstructionException("Short value out of range " + HexUtil.toHex(value, 4) + " > 0xffff", this);
        }
        this.valueBytes.putShort(offset, value);
    }

    int getByteSigned() {
        return this.valueBytes.get(1);
    }

    void setByte(int offset, int value) {
        if ((value & 0xFFFFFF00) != 0 && value != (byte)value) {
            throw new InstructionException("Byte value out of range " + HexUtil.toHex(value & 0xFFFF, 2) + "> 0xff", this);
        }
        this.valueBytes.put(offset, (byte)value);
    }

    int getByteUnsigned(int offset) {
        return this.valueBytes.getByteUnsigned(offset);
    }

    int getNibble(int index) {
        int i = this.valueBytes.getByteUnsigned(index / 2);
        int shift = index % 2 * 4;
        return i >> shift & 0xF;
    }

    void setNibble(int index, int value) {
        if ((value & 0xF) != value) {
            throw new InstructionException("Nibble value out of range " + HexUtil.toHex(value, 1) + " > 0xf", this);
        }
        int i = index / 2;
        int half = this.valueBytes.getByteUnsigned(i);
        int shift = index % 2 * 4;
        int mask = 15;
        if (shift == 0) {
            mask = 240;
        }
        int result = value << shift | half & mask;
        this.valueBytes.put(i, (byte)result);
    }

    @Override
    public int countBytes() {
        return this.valueBytes.countBytes();
    }

    @Override
    public void onReadBytes(BlockReader reader) throws IOException {
        this.valueBytes.onReadBytes(reader);
        this.pullSectionItem();
    }

    void pullSectionItem() {
        InsIdSectionReference sectionReference = this.sectionReference;
        if (sectionReference != null) {
            sectionReference.pullItem();
        }
    }

    public IdItem getSectionId() {
        InsIdSectionReference sectionReference = this.sectionReference;
        if (sectionReference != null) {
            return sectionReference.getItem();
        }
        return null;
    }

    public void setSectionId(IdItem item) {
        this.sectionReference.setItem(item);
    }

    public Key getKey() {
        InsIdSectionReference sectionReference = this.sectionReference;
        if (sectionReference != null) {
            return sectionReference.getKey();
        }
        return null;
    }

    public void setKey(Key key) {
        this.sectionReference.setKey(key);
    }

    @Deprecated
    public void setSectionIdKey(Key key) {
        this.setKey(key);
    }

    @Deprecated
    public Key getSectionIdKey() {
        return this.getKey();
    }

    public int getData() {
        return this.getShortUnsigned(2);
    }

    public int getSignedData() {
        return this.getData();
    }

    public long getDataAsLong() {
        return this.getSignedData();
    }

    public void setData(long data) {
        this.setData((int)data);
    }

    public void setData(int data) {
        this.setShort(2, data);
    }

    @Override
    public int getOutSize() {
        if (this.getOpcode().hasOutRegisters()) {
            return ((RegistersSet)((Object)this)).getRegistersCount();
        }
        return 0;
    }

    @Override
    protected void onRefreshed() {
        super.onRefreshed();
        InsIdSectionReference sectionItem = this.sectionReference;
        if (sectionItem != null) {
            sectionItem.refresh();
        }
    }

    public RegistersIterator getRegistersIterator() {
        RegistersTable table;
        if (this instanceof RegistersSet && (table = this.getRegistersTable()) != null) {
            return new RegistersIterator(table, (RegistersSet)((Object)this));
        }
        return null;
    }

    private RegistersTable getRegistersTable() {
        InstructionList instructionList = this.getParentInstance(InstructionList.class);
        if (instructionList != null) {
            return instructionList.getCodeItem();
        }
        return null;
    }

    @Override
    public void appendCode(SmaliWriter writer) throws IOException {
        Opcode<?> opcode = this.getOpcode();
        writer.append(opcode.getName());
        writer.append(' ');
        this.appendRegisters(writer);
        this.appendOperand(writer);
    }

    void appendRegisters(SmaliWriter writer) throws IOException {
        RegistersIterator iterator = this.getRegistersIterator();
        if (iterator == null) {
            return;
        }
        boolean out = this.getOpcode().hasOutRegisters();
        if (out) {
            writer.append('{');
        }
        iterator.append(writer);
        if (out) {
            writer.append('}');
        }
    }

    void appendOperand(SmaliWriter writer) throws IOException {
        writer.append(", ");
        IdItem sectionItem = this.getSectionId();
        if (sectionItem != null) {
            sectionItem.append(writer);
        } else {
            this.appendHexData(writer);
            this.appendHexDataComment(writer);
        }
    }

    void appendHexData(SmaliWriter writer) throws IOException {
        writer.appendHex(this.getSignedData());
    }

    private void appendHexDataComment(SmaliWriter writer) {
        String comment = InsConstCommentHelper.getCommentForConstNumber(this);
        if (comment != null) {
            writer.appendComment(comment);
        }
    }

    @Override
    public void replaceKeys(Key search, Key replace) {
        Key key = this.getKey();
        if (key == null) {
            return;
        }
        Key key2 = key.replaceKey(search, replace);
        if (key != key2) {
            this.setKey(key2);
        }
    }

    @Override
    public Iterator<IdItem> usedIds() {
        return SingleIterator.of(this.getSectionId());
    }

    @Override
    public void merge(Ins ins) {
        SizeXIns coming = (SizeXIns)ins;
        SectionType<? extends IdItem> sectionType = coming.getSectionType();
        if (sectionType == null) {
            this.valueBytes.set((byte[])coming.valueBytes.getBytes().clone());
            return;
        }
        this.setKey(coming.getKey());
        this.sectionReference.validate();
        RegistersSet comingSet = (RegistersSet)((Object)coming);
        RegistersSet set = (RegistersSet)((Object)this);
        int count = comingSet.getRegistersCount();
        set.setRegistersCount(count);
        for (int i = 0; i < count; ++i) {
            set.setRegister(i, comingSet.getRegister(i));
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SizeXIns sizeXIns = (SizeXIns)obj;
        if (this.getIndex() != sizeXIns.getIndex()) {
            return false;
        }
        if (this.getOpcode() != sizeXIns.getOpcode()) {
            return false;
        }
        if (this instanceof RegistersSet && !SizeXIns.areEqual((RegistersSet)((Object)this), (RegistersSet)((Object)sizeXIns))) {
            return false;
        }
        if (this.getSectionType() != null) {
            return Objects.equals(this.getKey(), sizeXIns.getKey());
        }
        return this.getDataAsLong() == sizeXIns.getDataAsLong();
    }

    public int hashCode() {
        int hash = 1;
        hash += this.getIndex();
        hash = hash * 31 + this.getOpcode().getValue();
        if (this instanceof RegistersSet) {
            RegistersSet set = (RegistersSet)((Object)this);
            int count = set.getRegistersCount();
            hash = hash * 31 + count;
            for (int i = 0; i < count; ++i) {
                hash = hash * 31 + set.getRegister(i);
            }
        }
        hash *= 31;
        Key key = this.getKey();
        hash = key != null ? (hash += key.hashCode()) : hash * 31 + Long.hashCode(this.getDataAsLong());
        return hash;
    }

    @Override
    public void fromSmali(SmaliInstruction smaliInstruction) {
        this.validateOpcode(smaliInstruction);
        this.fromSmaliRegisters(smaliInstruction);
        this.fromSmaliKey(smaliInstruction);
        this.fromSmaliData(smaliInstruction);
    }

    private void fromSmaliRegisters(SmaliInstruction smaliInstruction) {
        if (!(this instanceof RegistersSet)) {
            return;
        }
        if (smaliInstruction.getRegistersTable() == null) {
            smaliInstruction.setRegistersTable(this.getRegistersTable());
        }
        int count = smaliInstruction.getRegistersCount();
        RegistersSet registersSet = (RegistersSet)((Object)this);
        registersSet.setRegistersCount(count);
        for (int i = 0; i < count; ++i) {
            Register register = smaliInstruction.getRegister(i);
            registersSet.setRegister(i, register.getValue());
        }
    }

    private void fromSmaliKey(SmaliInstruction smaliInstruction) {
        if (this.getSectionType() == null) {
            return;
        }
        this.setKey(smaliInstruction.getKey());
    }

    private void fromSmaliData(SmaliInstruction smaliInstruction) {
        if (this.getSectionType() == null && smaliInstruction.hasNumberData()) {
            this.setData(smaliInstruction.getDataAsLong());
        }
    }

    @Override
    void toSmaliOperand(SmaliInstruction instruction) {
        super.toSmaliOperand(instruction);
        SmaliInstructionOperand operand = instruction.getOperand();
        OperandType operandType = instruction.getOperandType();
        if (operandType == OperandType.HEX) {
            ((SmaliInstructionOperand.SmaliHexOperand)operand).setNumber(this.getData());
        } else if (operandType == OperandType.KEY) {
            ((SmaliInstructionOperand.SmaliKeyOperand)operand).setKey(this.getKey());
        } else if (operandType == OperandType.LABEL) {
            SmaliLabel smaliLabel = ((SmaliInstructionOperand.SmaliLabelOperand)operand).getLabel();
            Label label = (Label)((Object)this);
            smaliLabel.setLabelName(label.getLabelName());
        } else if (operandType == OperandType.DUAL_KEY) {
            ((SmaliInstructionOperand.SmaliDualKeyOperand)operand).setKey(this.getKey());
            ((SmaliInstructionOperand.SmaliDualKeyOperand)operand).setKey2(((DualKeyReference)((Object)this)).getKey2());
        }
    }

    @Override
    void toSmaliRegisters(SmaliInstruction instruction) {
        super.toSmaliRegisters(instruction);
        SmaliRegisterSet smaliRegisterSet = instruction.getRegisterSet();
        RegisterFormat registerFormat = smaliRegisterSet.getFormat();
        if (registerFormat == RegisterFormat.NONE) {
            return;
        }
        RegistersIterator registersIterator = this.getRegistersIterator();
        RegisterReference ref = registersIterator.get(0);
        smaliRegisterSet.addRegister(ref.isParameter(), ref.getNumber());
        int size = registersIterator.size();
        int start = 1;
        if (registerFormat.isRange()) {
            start = size - 1;
        }
        for (int i = start; i < size; ++i) {
            ref = registersIterator.get(i);
            smaliRegisterSet.addRegister(ref.isParameter(), ref.getNumber());
        }
    }

    private static boolean areEqual(RegistersSet set1, RegistersSet set2) {
        if (set1 == set2) {
            return true;
        }
        if (set1 == null) {
            return false;
        }
        int count = set1.getRegistersCount();
        if (count != set2.getRegistersCount()) {
            return false;
        }
        for (int i = 0; i < count; ++i) {
            if (set1.getRegister(i) == set2.getRegister(i)) continue;
            return false;
        }
        return true;
    }

    public static String buildTrace(SizeXIns sizeXIns, IdItem item, int data) {
        InstructionList instructionList = sizeXIns.getInstructionList();
        if (instructionList == null) {
            return "removed instruction";
        }
        CodeItem codeItem = instructionList.getCodeItem();
        if (codeItem == null) {
            return "removed instruction list";
        }
        if (codeItem.getParent() == null) {
            return "removed code item";
        }
        MethodDef methodDef = codeItem.getMethodDef();
        StringBuilder builder = new StringBuilder();
        if (methodDef != null) {
            builder.append("method = ");
            builder.append(methodDef.getKey());
            builder.append(", ");
        }
        builder.append(sizeXIns.getOpcode());
        String key = SizeXIns.toDebugString(item);
        if (key == null) {
            key = HexUtil.toHex(data, 1);
        }
        builder.append(", key = '");
        builder.append(key);
        builder.append('\'');
        return builder.toString();
    }

    static String toDebugString(IdItem item) {
        if (item == null) {
            return null;
        }
        Key key = item.getKey();
        if (key == null) {
            return null;
        }
        String keyString = key.toString();
        if (keyString == null) {
            return null;
        }
        if (keyString.length() > 100) {
            keyString = keyString.substring(0, 100) + "...";
        }
        if (keyString.startsWith("\"")) {
            keyString = keyString.substring(1);
        }
        if (keyString.endsWith("\"")) {
            keyString = keyString.substring(0, keyString.length() - 1);
        }
        return keyString;
    }
}

