/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.ins;

import com.reandroid.arsc.base.Creator;
import com.reandroid.arsc.container.CountedBlockList;
import com.reandroid.arsc.item.IntegerItem;
import com.reandroid.arsc.item.IntegerReference;
import com.reandroid.dex.ins.Ins;
import com.reandroid.dex.ins.InsPackedSwitch;
import com.reandroid.dex.ins.InsPackedSwitchData;
import com.reandroid.dex.ins.InsSwitchPayload;
import com.reandroid.dex.ins.LabelsSet;
import com.reandroid.dex.smali.SmaliFormat;
import com.reandroid.dex.smali.SmaliWriter;
import com.reandroid.dex.smali.model.SmaliPackedSwitchEntry;
import com.reandroid.dex.smali.model.SmaliPayloadPackedSwitch;
import com.reandroid.dex.smali.model.SmaliSet;
import com.reandroid.utils.HexUtil;
import java.io.IOException;
import java.util.Iterator;
import java.util.Objects;

public class PackedSwitchDataList
extends CountedBlockList<PackedSwitchEntry>
implements SmaliFormat,
LabelsSet {
    private final InsPackedSwitchData switchData;
    private static final Creator<PackedSwitchEntry> CREATOR = PackedSwitchEntry::new;

    public PackedSwitchDataList(InsPackedSwitchData switchData, IntegerReference itemCount) {
        super(CREATOR, itemCount);
        this.switchData = switchData;
    }

    public int getFirstKey() {
        return this.switchData.getFirstKey();
    }

    public int getBaseAddress() {
        InsPackedSwitch packedSwitch = this.switchData.getSwitch();
        if (packedSwitch == null) {
            return 0;
        }
        return packedSwitch.getAddress();
    }

    public InsPackedSwitchData getSwitchData() {
        return this.switchData;
    }

    void onDataChange(int index, int value) {
        this.switchData.onDataChange(index, value);
    }

    public void merge(PackedSwitchDataList dataList) {
        int size = dataList.size();
        this.setSize(size);
        for (int i = 0; i < size; ++i) {
            ((PackedSwitchEntry)this.get(i)).merge((PackedSwitchEntry)dataList.get(i));
        }
    }

    public void fromSmali(SmaliPayloadPackedSwitch smali) {
        SmaliSet entries = smali.getEntries();
        int size = entries.size();
        this.setSize(size);
        for (int i = 0; i < size; ++i) {
            ((PackedSwitchEntry)this.get(i)).fromSmali((SmaliPackedSwitchEntry)entries.get(i));
        }
    }

    public void toSmali(SmaliPayloadPackedSwitch smali) {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            smali.addEntry(((PackedSwitchEntry)this.get(i)).toSmali());
        }
    }

    @Override
    public void append(SmaliWriter writer) throws IOException {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            ((PackedSwitchEntry)this.get(i)).append(writer);
        }
    }

    public Iterator<PackedSwitchEntry> getLabels() {
        return this.iterator();
    }

    public static class PackedSwitchEntry
    extends IntegerItem
    implements InsSwitchPayload.SwitchEntry {
        private Ins targetIns;

        @Override
        public Ins getTargetIns() {
            Ins targetIns = this.targetIns;
            if (targetIns == null) {
                this.setTargetIns(this.findTargetIns());
                targetIns = this.targetIns;
            }
            return targetIns;
        }

        @Override
        public void setTargetIns(Ins targetIns) {
            if (targetIns != this.targetIns) {
                this.targetIns = targetIns;
                if (targetIns != null) {
                    targetIns.addExtraLine(this);
                }
            }
        }

        @Override
        public InsPackedSwitchData getPayload() {
            return this.getParentDataList().getSwitchData();
        }

        @Override
        public int get() {
            return this.getParentDataList().getFirstKey() + this.getIndex();
        }

        @Override
        public void set(int value) {
            if (value != this.get()) {
                this.getParentDataList().onDataChange(this.getIndex(), value);
            }
        }

        @Override
        public void append(SmaliWriter writer) throws IOException {
            writer.newLine();
            writer.appendLabelName(this.getLabelName());
            int value = this.get();
            writer.appendComment(HexUtil.toHex(value, 1));
            writer.appendResourceIdComment(value);
        }

        @Override
        public void appendExtra(SmaliWriter writer) throws IOException {
            writer.appendLabelName(this.getLabelName());
            writer.appendComment(HexUtil.toHex(this.get(), 1));
        }

        @Override
        public int getAddress() {
            return super.get();
        }

        public void setAddress(int address) {
            super.set(address);
        }

        @Override
        public int getTargetAddress() {
            return this.getParentDataList().getBaseAddress() + this.getAddress();
        }

        @Override
        public void setTargetAddress(int targetAddress) {
            this.setAddress(targetAddress - this.getParentDataList().getBaseAddress());
        }

        @Override
        public String getLabelName() {
            return HexUtil.toHex(":pswitch_", this.getTargetAddress(), 1);
        }

        private PackedSwitchDataList getParentDataList() {
            return (PackedSwitchDataList)this.getParent();
        }

        @Override
        public int getSortOrder() {
            return 5;
        }

        public void merge(PackedSwitchEntry data) {
            this.setAddress(data.getAddress());
        }

        public void fromSmali(SmaliPackedSwitchEntry smaliEntry) {
            this.setAddress(smaliEntry.getRelativeOffset());
        }

        public SmaliPackedSwitchEntry toSmali() {
            SmaliPackedSwitchEntry entry = new SmaliPackedSwitchEntry();
            entry.getLabel().setLabelName(this.getLabelName());
            return entry;
        }

        public int hashCode() {
            return Objects.hash(this.getIndex());
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            PackedSwitchEntry data = (PackedSwitchEntry)obj;
            return this.getIndex() == data.getIndex() && this.getParent() == data.getParent();
        }

        @Override
        public String toString() {
            return this.getLabelName();
        }
    }
}

