/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.ins;

import com.reandroid.dex.base.DexException;
import com.reandroid.dex.data.CodeItem;
import com.reandroid.dex.data.InstructionList;
import com.reandroid.dex.data.MethodDef;
import com.reandroid.dex.id.MethodId;
import com.reandroid.dex.ins.Ins;
import com.reandroid.dex.sections.DexLayoutBlock;

public class InstructionException
extends DexException {
    private final Ins ins;

    public InstructionException(String message, Ins ins) {
        super(message);
        this.ins = ins;
    }

    public Ins getIns() {
        return this.ins;
    }

    @Override
    public String getMessage() {
        StringBuilder builder = new StringBuilder();
        builder.append(super.getMessage());
        builder.append(", ");
        this.appendDex(builder);
        if (!this.appendMethod(builder)) {
            builder.append(this.getIns());
        }
        return builder.toString();
    }

    private boolean appendMethod(StringBuilder builder) {
        InstructionList instructionList = this.getIns().getInstructionList();
        if (instructionList == null) {
            return false;
        }
        CodeItem codeItem = instructionList.getCodeItem();
        MethodDef methodDef = codeItem.getMethodDef();
        if (methodDef == null) {
            return false;
        }
        MethodId methodId = (MethodId)methodDef.getId();
        if (methodId == null) {
            return false;
        }
        builder.append("class = ");
        builder.append(methodId.getDefining());
        builder.append(", method = ");
        builder.append(methodId.getName());
        builder.append(methodId.getProtoId());
        builder.append(" { ... ");
        builder.append(this.getIns());
        builder.append(" ... }");
        return true;
    }

    private void appendDex(StringBuilder builder) {
        DexLayoutBlock dexLayoutBlock = this.getIns().getParentInstance(DexLayoutBlock.class);
        if (dexLayoutBlock == null) {
            return;
        }
        String simpleName = dexLayoutBlock.getDexContainerBlock().getSimpleName();
        if (simpleName == null) {
            return;
        }
        builder.append("dex = ");
        builder.append(simpleName);
        builder.append(", ");
    }
}

