/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.ins;

import com.reandroid.arsc.item.IntegerItem;
import com.reandroid.arsc.item.IntegerReference;
import com.reandroid.arsc.item.ShortItem;
import com.reandroid.dex.ins.Ins;
import com.reandroid.dex.ins.InsBlockList;
import com.reandroid.dex.ins.InsPackedSwitch;
import com.reandroid.dex.ins.InsSparseSwitch;
import com.reandroid.dex.ins.InsSparseSwitchData;
import com.reandroid.dex.ins.InsSwitchPayload;
import com.reandroid.dex.ins.Opcode;
import com.reandroid.dex.ins.PackedSwitchDataList;
import com.reandroid.dex.smali.SmaliDirective;
import com.reandroid.dex.smali.SmaliWriter;
import com.reandroid.dex.smali.model.SmaliInstruction;
import com.reandroid.dex.smali.model.SmaliInstructionOperand;
import com.reandroid.dex.smali.model.SmaliPayloadPackedSwitch;
import com.reandroid.utils.HexUtil;
import com.reandroid.utils.ObjectsUtil;
import java.io.IOException;
import java.util.Iterator;

public class InsPackedSwitchData
extends InsSwitchPayload {
    private final ShortItem elementCount = new ShortItem();
    private final IntegerItem firstKey = new IntegerItem();
    private final PackedSwitchDataList elements = new PackedSwitchDataList(this, (IntegerReference)this.elementCount);
    private InsSparseSwitchData mReplacement;

    public InsPackedSwitchData() {
        super(3, Opcode.PACKED_SWITCH_PAYLOAD);
        this.addChild(1, this.elementCount);
        this.addChild(2, this.firstKey);
        this.addChild(3, this.elements);
    }

    public int getFirstKey() {
        return this.firstKey.get();
    }

    public void setFirstKey(int firstKey) {
        this.firstKey.set(firstKey);
    }

    @Override
    public Iterator<InsSwitchPayload.SwitchEntry> iterator() {
        return (Iterator)ObjectsUtil.cast(this.elements.getLabels());
    }

    void onDataChange(int index, int value) {
        this.replaceBySparse().get(index).set(value);
    }

    public InsSparseSwitchData replaceBySparse() {
        InsSparseSwitchData sparseData = this.mReplacement;
        if (sparseData != null) {
            return sparseData;
        }
        InsBlockList insBlockList = this.getInsBlockList();
        Object lock = insBlockList.linkLocked();
        InsPackedSwitch packed = this.getSwitch();
        InsSparseSwitch sparse = packed.getSparseSwitchReplacement();
        this.mReplacement = sparseData = (InsSparseSwitchData)Opcode.SPARSE_SWITCH_PAYLOAD.newInstance();
        sparseData.setSwitch(sparse);
        sparseData.fromPackedSwitchData(this.elements);
        this.replace(sparseData);
        insBlockList.unlinkLocked(lock);
        return sparseData;
    }

    public Opcode<InsPackedSwitch> getSwitchOpcode() {
        return Opcode.PACKED_SWITCH;
    }

    @Override
    public InsPackedSwitch getSwitch() {
        return (InsPackedSwitch)super.getSwitch();
    }

    @Override
    public SmaliDirective getSmaliDirective() {
        return SmaliDirective.PACKED_SWITCH;
    }

    public Iterator<PackedSwitchDataList.PackedSwitchEntry> getLabels() {
        return this.elements.getLabels();
    }

    @Override
    public void merge(Ins ins) {
        InsPackedSwitchData switchData = (InsPackedSwitchData)ins;
        this.setFirstKey(switchData.getFirstKey());
        this.elements.merge(switchData.elements);
    }

    @Override
    public void fromSmali(SmaliInstruction smaliInstruction) {
        this.validateOpcode(smaliInstruction);
        SmaliPayloadPackedSwitch smaliPayloadPackedSwitch = (SmaliPayloadPackedSwitch)smaliInstruction;
        this.setFirstKey(smaliPayloadPackedSwitch.getFirstKey());
        this.elements.fromSmali(smaliPayloadPackedSwitch);
    }

    @Override
    void toSmaliOperand(SmaliInstruction instruction) {
        super.toSmaliOperand(instruction);
        SmaliInstructionOperand.SmaliHexOperand operand = (SmaliInstructionOperand.SmaliHexOperand)instruction.getOperand();
        operand.setNumber(this.getFirstKey());
    }

    @Override
    void toSmaliEntries(SmaliInstruction instruction) {
        super.toSmaliEntries(instruction);
        this.elements.toSmali((SmaliPayloadPackedSwitch)instruction);
    }

    @Override
    public void appendCode(SmaliWriter writer) throws IOException {
        this.getSmaliDirective().append(writer);
        writer.append(HexUtil.toHex(this.firstKey.get(), 1));
        writer.indentPlus();
        this.elements.append(writer);
        writer.indentMinus();
        this.getSmaliDirective().appendEnd(writer);
    }

    @Override
    public String toString() {
        return "InsPackedSwitchData{elementCount=" + this.elementCount + ", firstKey=" + this.firstKey + ", elements=" + this.elements + '}';
    }
}

