/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.ins;

import com.reandroid.dex.id.StringId;
import com.reandroid.dex.ins.ConstString;
import com.reandroid.dex.ins.Ins21c;
import com.reandroid.dex.ins.InsConstStringJumbo;
import com.reandroid.dex.ins.Opcode;
import com.reandroid.dex.key.StringKey;

public class InsConstString
extends Ins21c
implements ConstString {
    public InsConstString() {
        super(Opcode.CONST_STRING);
    }

    @Override
    public String getString() {
        StringId stringId = this.getStringId();
        if (stringId != null) {
            return stringId.getString();
        }
        return null;
    }

    @Override
    public void setString(StringKey key) {
        super.setKey(key);
    }

    @Override
    public int getRegister() {
        return this.getRegister(0);
    }

    @Override
    public void setRegister(int register) {
        this.setRegister(0, register);
    }

    public StringId getStringId() {
        return this.getSectionId();
    }

    @Override
    public StringId getSectionId() {
        return (StringId)super.getSectionId();
    }

    @Override
    public StringKey getKey() {
        return (StringKey)super.getKey();
    }

    public InsConstStringJumbo toConstStringJumbo() {
        StringId stringId = this.getSectionId();
        if (stringId == null || !this.needsConvertToConstStringJumbo(stringId)) {
            return null;
        }
        InsConstStringJumbo stringJumbo = (InsConstStringJumbo)Opcode.CONST_STRING_JUMBO.newInstance();
        stringJumbo.setRegister(this.getRegister());
        this.replace(stringJumbo);
        stringJumbo.setSectionId(stringId);
        return stringJumbo;
    }

    private boolean needsConvertToConstStringJumbo(StringId stringId) {
        int index = stringId.getIndex();
        return index != (index & 0xFFFF);
    }
}

