/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.ins;

import com.reandroid.arsc.base.Block;
import com.reandroid.arsc.container.BlockList;
import com.reandroid.arsc.io.BlockReader;
import com.reandroid.arsc.item.AlignItem;
import com.reandroid.arsc.item.IntegerReference;
import com.reandroid.dex.data.InstructionList;
import com.reandroid.dex.data.MethodDef;
import com.reandroid.dex.debug.DebugElement;
import com.reandroid.dex.ins.ExtraLine;
import com.reandroid.dex.ins.Ins;
import com.reandroid.dex.ins.Label;
import com.reandroid.dex.ins.LabelsSet;
import com.reandroid.dex.ins.NullInstruction;
import com.reandroid.dex.ins.Opcode;
import com.reandroid.utils.NumbersUtil;
import com.reandroid.utils.ObjectsUtil;
import com.reandroid.utils.collection.CombiningIterator;
import com.reandroid.utils.collection.EmptyIterator;
import com.reandroid.utils.collection.IterableIterator;
import com.reandroid.utils.collection.SingleIterator;
import java.io.IOException;
import java.util.Iterator;

public class InsBlockList
extends BlockList<Ins> {
    private final AlignItem blockAlign;
    private final IntegerReference codeUnitsReference;
    private final IntegerReference outSizReference;
    private final Iterable<? extends ExtraLine> extraLines;
    private NullInstruction mNullInstruction;
    private boolean mLinked;
    private boolean mLocked;
    private boolean mSecondUpdateRequired;
    private Object mLockedBy;

    public InsBlockList(AlignItem blockAlign, IntegerReference codeUnitsReference, IntegerReference outSizReference, Iterable<? extends ExtraLine> extraLines) {
        this.blockAlign = blockAlign;
        this.codeUnitsReference = codeUnitsReference;
        this.outSizReference = outSizReference;
        this.extraLines = extraLines;
    }

    public Ins getPrevious(Ins ins) {
        return (Ins)this.get(this.indexOf(ins) - 1);
    }

    public Ins getNext(Ins ins) {
        int index = this.indexOf(ins);
        if (index >= 0) {
            return (Ins)this.get(index + 1);
        }
        return null;
    }

    public Ins getAtAddress(int address) {
        int size = this.size();
        int codeUnits = 0;
        for (int i = 0; i < size; ++i) {
            Ins ins = (Ins)this.get(i);
            if (codeUnits == address) {
                return ins;
            }
            codeUnits += ins.getCodeUnits();
        }
        if (address == codeUnits) {
            return this.getOrCreateNullInstruction();
        }
        return null;
    }

    public int addressOf(Ins instruction) {
        int count = this.size();
        int address = 0;
        for (int i = 0; i < count; ++i) {
            Ins ins = (Ins)this.get(i);
            if (ins == instruction) {
                return address;
            }
            address += ins.getCodeUnits();
        }
        if (instruction == this.getNullInstruction()) {
            return address;
        }
        return -1;
    }

    private Ins[] buildAddressMap() {
        int size = this.size();
        int address = 0;
        this.updateCodeUnits();
        Ins[] map = new Ins[this.getCodeUnits()];
        for (int i = 0; i < size; ++i) {
            Ins ins;
            map[address] = ins = (Ins)this.get(i);
            address += ins.getCodeUnits();
        }
        return map;
    }

    public Iterator<Label> getLabels() {
        return new IterableIterator<Ins, Label>(this.iterator()){

            @Override
            public Iterator<Label> iterator(Ins element) {
                Iterator<Label> iterator = null;
                if (element instanceof LabelsSet) {
                    iterator = (EmptyIterator<Label>)ObjectsUtil.cast(((LabelsSet)((Object)element)).getLabels());
                }
                if (element instanceof Label) {
                    Label label = (Label)((Object)element);
                    iterator = iterator == null ? SingleIterator.of(label) : CombiningIterator.singleOne(label, iterator);
                }
                if (iterator == null) {
                    iterator = EmptyIterator.of();
                }
                return iterator;
            }
        };
    }

    public void onEditingInternal(InsBlockList insBlockList) {
        if (this.isLinked() && !insBlockList.isLinked()) {
            insBlockList.linkLocked();
            insBlockList.mLocked = false;
            insBlockList.mLockedBy = null;
        }
    }

    public boolean isLinked() {
        return this.mLinked;
    }

    public boolean isLocked() {
        return this.mLocked || this.mLockedBy != null;
    }

    public Object linkLocked() {
        return this.link(new Object());
    }

    public Object link(Object obj) {
        if (this.mLinked || this.isLocked()) {
            return null;
        }
        this.mLockedBy = obj;
        this.mLocked = true;
        this.linkTargetIns();
        this.linkExtraLines();
        this.mLinked = this.size() != 0;
        this.mLocked = false;
        return obj;
    }

    public void link() {
        if (this.mLinked || this.isLocked()) {
            return;
        }
        this.mLocked = true;
        this.linkTargetIns();
        this.linkExtraLines();
        this.mLinked = true;
        this.mLocked = false;
    }

    private void linkTargetIns() {
        this.mSecondUpdateRequired = false;
        int count = this.size();
        for (int i = 0; i < count; ++i) {
            ((Ins)this.get(i)).linkTargetIns();
        }
    }

    private void linkExtraLines() {
        Iterator<? extends ExtraLine> iterator = this.extraLines.iterator();
        if (!iterator.hasNext()) {
            return;
        }
        Ins[] map = this.buildAddressMap();
        int length = map.length;
        while (iterator.hasNext()) {
            ExtraLine extraLine = iterator.next();
            if (extraLine.isRemoved() || extraLine.getTargetIns() != null) continue;
            int address = extraLine.getTargetAddress();
            if (extraLine instanceof DebugElement && (address < 0 || address >= length || map[address] == null)) continue;
            Ins target = address == length ? this.getOrCreateNullInstruction() : map[address];
            if (target == null) {
                throw new NullPointerException("Invalid address " + address + ": " + extraLine);
            }
            extraLine.setTargetIns(target);
        }
    }

    public void unlinkLocked(Object obj) {
        this.unlink(obj, true);
    }

    public void unlink(Object obj) {
        this.unlink(obj, false);
    }

    public void unlink(Object obj, boolean update) {
        if (update) {
            this.mSecondUpdateRequired = true;
        }
        if (this.mLocked) {
            return;
        }
        if (obj == null || obj != this.mLockedBy) {
            return;
        }
        this.mLocked = true;
        if (!this.mLinked) {
            if (!update) {
                this.mLocked = false;
                this.mLockedBy = null;
                return;
            }
            this.linkTargetIns();
            this.linkExtraLines();
        }
        if (update || this.mSecondUpdateRequired) {
            this.update();
        }
        this.unlinkTargets();
        this.mLocked = false;
        this.mLockedBy = null;
    }

    public void unlink() {
        if (!this.mLinked || this.isLocked()) {
            this.mSecondUpdateRequired = true;
            return;
        }
        this.mLocked = true;
        this.update();
        this.unlinkTargets();
        this.updateCodeUnits();
        this.mLocked = false;
    }

    private void unlinkTargets() {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            ((Ins)this.get(i)).unLinkTargetIns();
        }
        this.removeNullInstruction();
        for (ExtraLine extraLine : this.extraLines) {
            extraLine.setTargetIns(null);
        }
        this.mLinked = false;
    }

    private void update() {
        this.mSecondUpdateRequired = false;
        this.updateInsTarget();
        this.updateExtraLines();
        if (this.mSecondUpdateRequired) {
            this.updateInsTarget();
            this.updateExtraLines();
            this.mSecondUpdateRequired = false;
        }
    }

    private void updateInsTarget() {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            ((Ins)this.get(i)).updateTargetAddress();
        }
    }

    private void updateExtraLines() {
        for (ExtraLine extraLine : this.extraLines) {
            extraLine.updateTarget();
        }
    }

    private String getCurrentMethodForDebug() {
        MethodDef methodDef;
        InstructionList instructionList = this.getParentInstance(InstructionList.class);
        if (instructionList != null && (methodDef = instructionList.getCodeItem().getMethodDef()) != null) {
            return methodDef.getKey().toString();
        }
        return null;
    }

    public NullInstruction getNullInstruction() {
        NullInstruction nullInstruction = this.mNullInstruction;
        if (nullInstruction != null) {
            nullInstruction.setParent(this);
            nullInstruction.setIndex(this.getCount());
        }
        return nullInstruction;
    }

    public NullInstruction getOrCreateNullInstruction() {
        NullInstruction nullInstruction = this.mNullInstruction;
        if (nullInstruction == null) {
            this.mNullInstruction = nullInstruction = new NullInstruction();
        }
        nullInstruction.setParent(this);
        nullInstruction.setIndex(this.getCount());
        return nullInstruction;
    }

    public void removeNullInstruction() {
        NullInstruction nullInstruction = this.mNullInstruction;
        if (nullInstruction != null) {
            this.mNullInstruction = null;
            nullInstruction.setParent(null);
            nullInstruction.setIndex(-1);
        }
    }

    public int getCodeUnits() {
        return this.codeUnitsReference.get();
    }

    public int getOutSize() {
        return this.outSizReference.get();
    }

    public void updateCodeUnits() {
        int address = 0;
        int outSize = 0;
        int count = this.size();
        for (int i = 0; i < count; ++i) {
            Ins ins = (Ins)this.get(i);
            address += ins.getCodeUnits();
            outSize = NumbersUtil.max(ins.getOutSize(), outSize);
        }
        this.codeUnitsReference.set(address);
        this.outSizReference.set(outSize);
        this.blockAlign.align(address * 2);
    }

    @Override
    protected void onRefreshed() {
        super.onRefreshed();
        this.updateCodeUnits();
        this.mLocked = false;
        this.mSecondUpdateRequired = false;
        this.unlink();
        this.mLockedBy = null;
    }

    @Override
    public void onReadBytes(BlockReader reader) throws IOException {
        this.mLockedBy = new Object();
        int insCodeUnits = this.codeUnitsReference.get();
        int position = reader.getPosition() + insCodeUnits * 2;
        int zeroPosition = reader.getPosition();
        int count = (insCodeUnits + 1) / 2;
        this.ensureCapacity(count);
        while (reader.getPosition() < position) {
            Opcode<?> opcode = Opcode.read(reader);
            Block ins = opcode.newInstance();
            this.add(ins);
            ins.readBytes(reader);
        }
        this.trimToSize();
        if (position != reader.getPosition()) {
            reader.seek(position);
        }
        int totalRead = reader.getPosition() - zeroPosition;
        this.blockAlign.align(totalRead);
        reader.offset(this.blockAlign.size());
        this.mLocked = false;
        this.mLinked = false;
        this.mLockedBy = null;
    }

    public void merge(InsBlockList insBlockList) {
        if (insBlockList == this) {
            return;
        }
        this.mLockedBy = new Object();
        this.mLocked = true;
        this.clearChildes();
        int size = insBlockList.size();
        this.ensureCapacity(size);
        for (int i = 0; i < size; ++i) {
            Ins coming = (Ins)insBlockList.get(i);
            Block ins = coming.getOpcode().newInstance();
            this.add(ins);
            ((Ins)ins).merge(coming);
        }
        this.mLocked = false;
        this.mLinked = false;
        this.mLockedBy = null;
        this.updateCodeUnits();
    }
}

