/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.ins;

import com.reandroid.dex.base.Ule128Item;
import com.reandroid.dex.base.UsageMarker;
import com.reandroid.dex.id.TypeId;
import com.reandroid.dex.ins.ExceptionHandler;
import com.reandroid.dex.ins.TryItem;
import com.reandroid.dex.key.TypeKey;
import com.reandroid.dex.reference.Ule128IdItemReference;
import com.reandroid.dex.sections.SectionType;
import com.reandroid.dex.smali.SmaliDirective;
import com.reandroid.dex.smali.model.SmaliCodeCatch;
import com.reandroid.dex.smali.model.SmaliCodeExceptionHandler;
import com.reandroid.utils.ObjectsUtil;

public class CatchTypedHandler
extends ExceptionHandler {
    private final Ule128IdItemReference<TypeId> typeId;

    public CatchTypedHandler() {
        super(1);
        this.typeId = new Ule128IdItemReference<TypeId>(SectionType.TYPE_ID, UsageMarker.USAGE_INSTRUCTION);
        this.addChild(0, this.typeId);
    }

    CatchTypedHandler(Ule128IdItemReference<TypeId> nullForCompact) {
        this.typeId = nullForCompact;
    }

    CatchTypedHandler newCompact(TryItem parent) {
        Compact catchTypedHandler = new Compact(this);
        catchTypedHandler.setIndex(this.getIndex());
        catchTypedHandler.setParent(parent);
        return catchTypedHandler;
    }

    @Override
    public boolean traps(TypeKey typeKey) {
        return typeKey != null && typeKey.equals(this.getKey());
    }

    @Override
    public TypeId getTypeId() {
        return (TypeId)this.getTypeUle128().getItem();
    }

    @Override
    public TypeKey getKey() {
        return (TypeKey)this.getTypeUle128().getKey();
    }

    @Override
    public void setKey(TypeKey typeKey) {
        this.getTypeUle128().setKey(typeKey);
    }

    @Override
    public boolean isCatchAll() {
        return false;
    }

    Ule128IdItemReference<TypeId> getTypeUle128() {
        return this.typeId;
    }

    @Override
    public SmaliDirective getSmaliDirective() {
        return SmaliDirective.CATCH;
    }

    @Override
    public void onRemove() {
        super.onRemove();
        this.typeId.setItem((TypeId)null);
    }

    @Override
    public void merge(ExceptionHandler handler) {
        super.merge(handler);
        CatchTypedHandler typedHandler = (CatchTypedHandler)handler;
        this.typeId.setKey(typedHandler.typeId.getKey());
    }

    @Override
    public void fromSmali(SmaliCodeExceptionHandler smaliCodeExceptionHandler) {
        SmaliCodeCatch smaliCodeCatch = (SmaliCodeCatch)smaliCodeExceptionHandler;
        this.typeId.setKey(smaliCodeCatch.getType());
        super.fromSmali(smaliCodeExceptionHandler);
    }

    @Override
    boolean isTypeEqual(ExceptionHandler handler) {
        return ObjectsUtil.equals(this.getKey(), handler.getKey());
    }

    @Override
    int getTypeHashCode() {
        TypeKey typeKey = this.getKey();
        if (typeKey != null) {
            return typeKey.hashCode();
        }
        return 0;
    }

    static class Compact
    extends CatchTypedHandler {
        private final CatchTypedHandler catchTypedHandler;

        Compact(CatchTypedHandler catchTypedHandler) {
            super(null);
            this.catchTypedHandler = catchTypedHandler;
        }

        @Override
        public boolean isRemoved() {
            return super.isRemoved() || this.catchTypedHandler.isRemoved();
        }

        @Override
        Ule128IdItemReference<TypeId> getTypeUle128() {
            return this.catchTypedHandler.getTypeUle128();
        }

        @Override
        Ule128Item getCatchAddressUle128() {
            return this.catchTypedHandler.getCatchAddressUle128();
        }

        @Override
        public void merge(ExceptionHandler handler) {
        }
    }
}

